/* 
 * Linkoping Intelligent Communication of Knowledge System (LINCKS)
 *      Copyright (C) 1993, 1994 Lin Padgham, Ralph Rnnquist
 *       Department of Computer and Information Sciences
 *		University of Linkoping, Sweden
 *		    581 83 Linkoping, Sweden
 *		       lincks@ida.liu.se
 *
 * These collective LINCKS programs are free software; you can 
 * redistribute them and/or modify them under the terms of the GNU
 * General Public License as published by the Free Software Foundation,
 * version 2 of the License.
 *
 * These programs are distributed in the hope that they will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the programs; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* 
 * MODULE NAME: 	dbserrors.c
 *
 * SCCSINFO:		@(#)dbserrors.c	1.8 6/6/94
 *
 * ORIGINAL AUTHOR(S):  ???, 1987-02-19
 *
 * MODIFICATIONS:
 *	<list mods with name and date>
 *
 * DESCRIPTION:
 *
 *********************************************************************
 * EXTERNALLY-CALLABLE ROUTINES FOUND IN THIS MODULE:
 *********************************************************************
 * void Error(va_alist)
 * void ErrorRPC(int rpcfunction, int errorcode)
 * void RPCTrouble(int rpcfunction, int rpcerror)
 */

/*********************************************************************
 * INCLUDES:
 *********************************************************************/
#include "config.h"	/* includes system dependent includes */

#include <time.h>
#ifdef __STDC__
#include <stdarg.h>
#else
#include <varargs.h>
#endif /* n __STDC__ */
#include <rpc/rpc.h>

#include "lincks.h"
#include "dbserver.h"
#include "libshared.h"	
#include "xconfig.h"

/*********************************************************************
 * EXTERNALLY-AVAILABLE	DATA FOUND IN THIS MODULE:
 *********************************************************************/
#include "f_dbserrors.h"

/*********************************************************************
 * EXTERNAL FUNCTIONS USED BY THIS MODULE:
 *********************************************************************/
#include "f_dbserv.h"
#include "f_rpc.h"

/* libc */
#if defined(sun) || defined(__sun__)
#if !defined(SVR4) && !(__STDC__ == 0)
extern struct tm *localtime P_((time_t *clock));
#endif /* n SVR4 && stdc == 0 */
extern time_t time P_((time_t *tloc));
#endif
/*********************************************************************
 * EXTERNAL DATA STRUCTURES USED BY THIS MODULE:
 *********************************************************************/
extern int errno;		/* errno.h */
extern int sys_nerr;		/* errno.h */
extern UID uid;

/*********************************************************************
 * LOCAL DEFINES, STRUCTS, TYPEDEFS, ETC.:
 *********************************************************************/
/* none */

/*********************************************************************
 * INTERNAL FUNCTIONS USED BY THIS MODULE:
 *********************************************************************/
/* none */

/*********************************************************************
 * INTERNAL (STATIC) DATA: 
 *********************************************************************/
/* none */

/*  */
/**********************************************************************
 * Function: void Error(va_alist)
 * 
 * Modifications:
 *      <list mods with name and date>
 */
#ifdef lint
/*VARARGS2*//*ARGSUSED*/
void Error(no_, format_, va_alist)
    int no_;
    char *format_;
    va_dcl
#else
#ifdef __STDC__
void Error(int no, char *format, ...)
#else
void Error(va_alist)
    va_dcl
#endif /* n __STDC__ */
#endif
{
    va_list ap;
#ifndef __STDC__
    int no;
    char *format;
#endif /* n __STDC__ */
    struct tm *t;
    TIME secs;
    char msg[256];
    char userid[8];
    static int recurse = -1;

    /* Check for error recursion */
    if (++recurse > 1) {
	recurse = -1;
	return;
    }

    /* get arguments */
#ifdef __STDC__
    va_start(ap, format);
#else
    va_start(ap);
    no = va_arg(ap, int);
    format = va_arg(ap, char *);
#endif /* n __STDC__ */

    if (format == NULL)
	format = "(null)";

    /* Get current time */
    (void)time(&secs);
    t = localtime(&secs);
	
    /* Compose error message */
    (void)vsprintf(msg, format, ap);
    switch (uid) {
    case UNKNOWN:
	(void)strcpy(userid, "U");
	break;
    case SUPERUSER:
	(void)strcpy(userid, "S");
	break;
    default:
	(void)sprintf(userid, "%d", uid);
    }

    /* Print time followed by error message on file */
#ifdef DEBUG
    LogFile(DBSERVLOG, "%02d-%02d-%02d  %02d:%02d:%02d  User: (%s) %d  DB: %s\n                    pid %d %s\n                    %s %s\n\n",
		       t->tm_year, t->tm_mon+1, t->tm_mday,
		       t->tm_hour, t->tm_min, t->tm_sec, 
		       userid, TCPIPNO, DBDIR, 
	               (int) getpid(), 
	               (0 < no && no <= ER_SYSERR && 
                        0 < errno & errno <= sys_nerr) ?
	               (char *)strerror(errno) : (char *)"",
	               msg, recurse ? " (Recursive)" : ""); /* Mod. 910926 mikoh */
#else
    LogFile(DBSERVLOG, "%02d-%02d-%02d  %02d:%02d:%02d  User: (%s) %d  DB: %s\n                    %s %s\n\n",
		       t->tm_year, t->tm_mon+1, t->tm_mday,
		       t->tm_hour, t->tm_min, t->tm_sec, 
		       userid, TCPIPNO, DBDIR, 
	               msg, recurse ? " (Recursive)" : "");   /* Mod. 910926 mikoh */
#endif
    va_end(ap);


    /* Process error as suitable */
    switch (no) {

      case 0:			/* Not an error,  don't tell user */	break;
      case ER_MALLOC:		UserError(no, ER_MALLOC_TEXT);		break;
      case ER_REALLOC:		UserError(no, ER_REALLOC_TEXT);		break;
      case ER_FLOCK:		UserError(no, ER_FLOCK_TEXT);		break;
      case ER_LSEEK:		UserError(no, ER_LSEEK_TEXT);		break;
      case ER_WRITE:		UserError(no, ER_WRITE_TEXT);		break;
      case ER_READ:		UserError(no, ER_READ_TEXT);		break;
      case ER_OPEN:		UserError(no, ER_OPEN_TEXT);		break;
      case ER_DATFILE_FMT:	UserError(no, ER_DATFILE_FMT_TEXT);	break;
      case ER_MOLFILE_FMT:	UserError(no, ER_MOLFILE_FMT_TEXT);	break;
      case ER_IT_NO_SPACE:	UserError(no, ER_IT_NO_SPACE_TEXT);	break;
      case ER_ILLEGAL_INDEX:	UserError(no, ER_ILLEGAL_INDEX_TEXT);	break;
      case ER_NOENTRY:		UserError(no, ER_NOENTRY_TEXT);		break;
      case ER_LOCKED:		UserError(no, ER_LOCKED_TEXT);		break;
      case ER_DELETED:		UserError(no, ER_DELETED_TEXT);		break;
      case ER_NOREADPERM:	UserError(no, ER_NOREADPERM_TEXT);	break;
      case ER_NOWRITEPERM:	UserError(no, ER_NOWRITEPERM_TEXT);	break;
      case ER_INIT:		UserError(no, ER_INIT_TEXT);		break;
      case ER_RESOLVE:		UserError(no, ER_RESOLVE_TEXT);		break;
      case ER_CREATEFAIL:	UserError(no, ER_CREATEFAIL_TEXT);	break;
      case ER_LOCKFAIL:		UserError(no, ER_LOCKFAIL_TEXT);	break;
      case ER_SYSERR:		UserError(no, ER_SYSERR_TEXT);		break;
      case ER_UNPACKERR:	UserError(no, ER_UNPACKERR_TEXT);	break;
      default:			UserError(no, ER_UNKNOWN_TEXT);
      }
    
    --recurse;
}

/*  */
/**********************************************************************
 * Function: void ErrorRPC(int rpcfunction, int errorcode)
 * 
 * Handles special RPC errors
 *
 * Modifications:
 *      <list mods with name and date>
 */
void ErrorRPC(rpcfunction, errorcode)
  u_long rpcfunction;
  int errorcode;
{
    char *msg;
    struct tm *t;
    TIME secs;
    char buff[99];
    char userid[8];
    static int recurse = -1;

    /* Check for error recursion */
    if (++recurse > 1) {
	recurse = -1;
	return;
    }

    /* Write user id */
    switch (uid) {
    case UNKNOWN:
	(void)strcpy(userid, "U");
	break;
    case SUPERUSER:
	(void)strcpy(userid, "S");
	break;
    default:
	(void)sprintf(userid, "%d", uid);
    }

    /* Prepare text for error message */
    switch (rpcfunction) {

      case 0:		  msg = "";			break;
      case ACCESS:	  msg = "RPC-Access";		break;
      case LOCKACCESS:	  msg = "RPC-LockAccess";	break;
      case UNLOCK:	  msg = "RPC-Unlock";		break;
      case SETPROT:	  msg = "RPC-SetProt";		break;
      case GETPROT:	  msg = "RPC-GetProt";		break;
      case DELETE:	  msg = "RPC-Delete";		break;
      case UNDELETE:	  msg = "RPC-Undelete";		break;
      case GETCHECKNO:	  msg = "RPC-GetCheckNo";	break;
      case UPDATECHECKNO: msg = "RPC-UpdateCheckNo";	break;
      case CREATE:	  msg = "RPC-Create";		break;
      case KILL:	  msg = "RPC-Kill"; 		break;
      case CHECK:         msg = "RPC-Check";            break;
      case REMOVE:        msg = "RPC-Remove";           break;
      case POLL:          msg = "RPC-Poll";             break;
      default:	       	  msg = "Unknown RPC error,";
    }

    if (errorcode)
	(void)sprintf(buff, " error status %d", errorcode);
    else
	(void)strcpy(buff, " call failed");
	
    /* Get current time */
    (void)time(&secs);
    t = localtime(&secs);

    /* Print time followed by error message on file */
    LogFile(DBSERVLOG, "%02d%02d%02d-%02d%02d%02d: (%s) - %s%s%s\n",
	               t->tm_year, t->tm_mon + 1, t->tm_mday,
	    	       t->tm_hour, t->tm_min, t->tm_sec,
		       userid, msg, buff, recurse ? " (Recursive)" : "");

    if (errorcode)
      Error(errorcode + ER_OFFSET, "dbs: %s%s", msg, buff);
    else
      UserError(99, msg);

    --recurse;
}

/*  */
/**********************************************************************
 * Function: void RPCTrouble(int rpcfunction, int rpcerror)
 * 
 * Special error routine for RPC errors. May be expanded
 * Uses ErrorRPC
 *
 * Modifications:
 *      <list mods with name and date>
 */
void RPCTrouble(rpcfunction,rpcerror)
  u_long rpcfunction;
  int    rpcerror;
{
    ErrorRPC(rpcfunction, 0);
    LogFile(DBSERVLOG, "                     %s\n", 
	    (char *) clnt_sperrno(rpcerror));
}
