/* 
 * Linkoping Intelligent Communication of Knowledge System (LINCKS)
 *      Copyright (C) 1993, 1994 Lin Padgham, Ralph Rnnquist
 *       Department of Computer and Information Sciences
 *		University of Linkoping, Sweden
 *		    581 83 Linkoping, Sweden
 *		       lincks@ida.liu.se
 *
 * These collective LINCKS programs are free software; you can 
 * redistribute them and/or modify them under the terms of the GNU
 * General Public License as published by the Free Software Foundation,
 * version 2 of the License.
 *
 * These programs are distributed in the hope that they will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the programs; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * MODULE NAME: 	makelinks.c
 *
 * SCCSINFO:		@(#)makelinks.c	1.5 5/3/94
 *
 * ORIGINAL AUTHOR(S):  ???, 18 Feb, 1987
 *
 * MODIFICATIONS:
 *	<list mods with name and date>
 *
 * DESCRIPTION:
 *      This file contains MakeLinksIndices and MakeLinksLabels
 */
/*********************************************************************
 * INCLUDES:
 *********************************************************************/
#include "config.h"	/* includes system dependent includes */
#include "lincks.h"
#include "dbserver.h"

/*********************************************************************
 * EXTERNALLY-CALLABLE ROUTINES FOUND IN THIS MODULE:
 *********************************************************************/
#include "f_makelinks.h"

/*********************************************************************
 * EXTERNALLY-AVAILABLE	DATA FOUND IN THIS MODULE:
 *********************************************************************/
/* none */

/*********************************************************************
 * EXTERNAL FUNCTIONS USED BY THIS MODULE:
 *********************************************************************/
#include "f_dbserfs.h"
#include "f_dbserrors.h"

/*********************************************************************
 * EXTERNAL DATA STRUCTURES USED BY THIS MODULE:
 *********************************************************************/
/* none */

/*********************************************************************
 * LOCAL DEFINES, STRUCTS, TYPEDEFS, ETC.:
 *********************************************************************/
/* none */

/*********************************************************************
 * INTERNAL FUNCTIONS USED BY THIS MODULE:
 *********************************************************************/
/* none */

/*********************************************************************
 * INTERNAL (STATIC) DATA:
 *********************************************************************/
/* none */

/*  */
/**********************************************************************
 * Function: int MakeLinksIndices(LINKGROUP *lg)
 *
 * Translates the link labels of a links structure
 * to index table indices
 * Uses TranslateLabelToIndex
 *
 * Modifications:
 *      <list mods with name and date>
 */
int MakeLinksIndices(lg)
  LINKGROUP *lg;
{
  LINKS *lf;
  LINKITEM *li;

  for (; lg != (LINKGROUP *) NULL; lg = lg->nextgroup) {
    for (lf = lg->links; lf != (LINKS *) NULL; lf = lf->nextlinks) {
      for (li = lf->linkitem; li != (LINKITEM *) NULL; li = li->nextitem) {
	if (((li->label =
	      TranslateLabelToIndex(li->label)) == IT_NO_SPACE) ||
	    ((li->vs =
	      TranslateLabelToIndex(li->vs)) == IT_NO_SPACE)) {
	  Error(ER_SYSERR, "MakeLinksIndices: no more space in IT");
	  return (IT_NO_SPACE);
	}
      }
    }
  }

  return (SUCCESS);
}

/*  */
/**********************************************************************
 * Function: int MakeLinksLabels(LINKGROUP *lg)
 *
 * Translates the index table indices in a links
 * structure to their correct labels
 * Uses TranslateIndexToLabel
 *
 * Modifications:
 *      <list mods with name and date>
 */
int MakeLinksLabels(lg)
  LINKGROUP *lg;
{
  LINKS *lf;
  LINKITEM *li;

  for (; lg != (LINKGROUP *) NULL; lg = lg->nextgroup) {
    for (lf = lg->links; lf != (LINKS *) NULL; lf = lf->nextlinks) {
      for (li = lf->linkitem; li != (LINKITEM *) NULL; li = li->nextitem) {
	if (((li->label =
	      TranslateIndexToLabel((WS_LABEL) li->label)) == IT_NO_LABEL) ||
	    ((li->vs =
	      TranslateIndexToLabel((WS_LABEL) li->vs)) == IT_NO_LABEL)) {
	  Error(ER_SYSERR, "MakeLinksLabels: no label space");
	  return (IT_NO_LABEL);
	}
      }
    }
  }

  return (SUCCESS);
}
