/* 
 * Linkoping Intelligent Communication of Knowledge System (LINCKS)
 *      Copyright (C) 1993, 1994 Lin Padgham, Ralph Rnnquist
 *       Department of Computer and Information Sciences
 *		University of Linkoping, Sweden
 *		    581 83 Linkoping, Sweden
 *		       lincks@ida.liu.se
 *
 * These collective LINCKS programs are free software; you can 
 * redistribute them and/or modify them under the terms of the GNU
 * General Public License as published by the Free Software Foundation,
 * version 2 of the License.
 *
 * These programs are distributed in the hope that they will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the programs; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* 
 * MODULE NAME: 	queue.c
 *
 * SCCSINFO:		@(#)queue.c	1.7 5/3/94
 *
 * ORIGINAL AUTHOR(S):  PEN pum project, May 1992
 *
 * MODIFICATIONS:
 *	Martin Sjlin 1993-08-12 Added QueueCount.
 *      <list mods with name and date>
 *
 * DESCRIPTION:
 *      This file contains definitions for the Queue structure methods
 */

/*********************************************************************
 * INCLUDES:
 *********************************************************************/
#include "config.h"	/* includes system dependent includes */
#include "lincks.h"
#include "dbserver.h"

/*********************************************************************
 * EXTERNALLY-CALLABLE ROUTINES FOUND IN THIS MODULE:
 *********************************************************************/
#include "f_queue.h"

/*********************************************************************
 * EXTERNALLY-AVAILABLE	DATA FOUND IN THIS MODULE:
 *********************************************************************/
/* none */

/*********************************************************************
 * EXTERNAL FUNCTIONS USED BY THIS MODULE:
 *********************************************************************/
#include "f_dbserrors.h"

/*********************************************************************
 * EXTERNAL DATA STRUCTURES USED BY THIS MODULE:
 *********************************************************************/
/* none */

/*********************************************************************
 * LOCAL DEFINES, STRUCTS, TYPEDEFS, ETC.:
 *********************************************************************/
/* none */

/*********************************************************************
 * INTERNAL FUNCTIONS USED BY THIS MODULE:
 *********************************************************************/
/* none */

/*********************************************************************
 * INTERNAL (STATIC) DATA: 
 *********************************************************************/
/* none */


/*  */
/**********************************************************************
 * Function: Queue *CreateQueue()
 * 
 * Creates a queue of pointers
 * Uses Error
 *
 * Modifications:
 *      <list mods with name and date>
 */
Queue *CreateQueue()
{
    Queue *queuep;
    
    if ((queuep = (Queue *) malloc(sizeof(Queue))) == NULL) {
	Error(ER_MALLOC, "CreateQueue:");
	return(NULL);
    }
    queuep->elementp = NULL;
    queuep->nextp = NULL;
    queuep->counter = 0;
    return(queuep);
}

/*  */
/**********************************************************************
 * Function: void Enqueue(Queue *queuep, void *elementp)
 * 
 * Inserts a pointer at the end of the queue
 * Uses Error
 *
 * Modifications:
 *      <list mods with name and date>
 */
void Enqueue(queuep, elementp)
  Queue *queuep;
  void *elementp;
{
  Queue *newp;
  Queue *first = queuep;

  /* Go to end of queue */
  while (queuep->nextp != NULL) 
    queuep = queuep->nextp;	

  /* Allocate space for new queue element */
  if ((newp = (Queue *) malloc(sizeof(Queue))) == NULL) {
    Error(ER_MALLOC, "Enqueue:");
    return;
  }

  /* Build new element */
  newp->elementp = elementp;
  newp->nextp = queuep->nextp;
  queuep->nextp = newp;
  first->counter++;
}


/*  */
/**********************************************************************
 * Function: int Mapqueue(Queue *queuep,int (*mapfn)())
 * 
 * Apply mapfn to queue elements until it returns non-zero.
 * Return non-zero in mapfn does, otherwise 0 (at end of queue).
 *
 * Modifications:
 *      <list mods with name and date>
 */
int Mapqueue(queuep,mapfn)
  Queue *queuep;
  int (*mapfn)();
{
  while (queuep) {
    if ((*mapfn)(queuep->elementp))
      return 1;
    queuep = queuep->nextp;
  }
  return 0;
}


/*  */
/**********************************************************************
 * Function: void *Dequeue(Queue *queuep)
 * 
 * Removes and returns the first pointer in the queue.
 * Returns NULL if the queue is empty
 *
 * Modifications:
 *      <list mods with name and date>
 */
void *Dequeue(queuep)
    Queue *queuep;
{
    Queue *oldp;
    void *elementp;
    
    if (queuep->nextp != NULL) {
        if ( queuep->counter-- < 0)
	  queuep->counter = 0;
	elementp = queuep->nextp->elementp;
	oldp = queuep->nextp;
	queuep->nextp = queuep->nextp->nextp; /* remove oldp from queue */
	free((FREEPTR *) oldp);                         /* free oldp */
	return(elementp);
    }
    else 
	return(NULL);
}

/*  */
/**********************************************************************
 * Function: int QueueCount(Queue *queuep)
 * 
 * Returns the number entries in the queue
 * Returns 0 if the queue is empty
 *
 * Modifications:
 *      <list mods with name and date>
 */
int QueueCount(queuep)
    Queue *queuep;
{
    if (queuep->nextp == NULL) 
      return ( (queuep->counter = 0) ); 
    else 
      return ( queuep->counter );
}



