/* 
 * Linkoping Intelligent Communication of Knowledge System (LINCKS)
 *      Copyright (C) 1993, 1994 Lin Padgham, Ralph Rnnquist
 *       Department of Computer and Information Sciences
 *		University of Linkoping, Sweden
 *		    581 83 Linkoping, Sweden
 *		       lincks@ida.liu.se
 *
 * These collective LINCKS programs are free software; you can 
 * redistribute them and/or modify them under the terms of the GNU
 * General Public License as published by the Free Software Foundation,
 * version 2 of the License.
 *
 * These programs are distributed in the hope that they will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the programs; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* 
 * MODULE NAME: 	monerrors.c
 *
 * SCCSINFO:		@(#)monerrors.c	1.7 6/6/94
 *
 * ORIGINAL AUTHOR(S):  ???, 19 Feb, 1987
 *
 * MODIFICATIONS:
 *	<list mods with name and date>
 *
 * DESCRIPTION:
 *	David Partain, 1992-08-24: file standardized, lint errors fixed,
 *		gcc -Wall warnings corrected.
 *      This file contains Error
 */
/*********************************************************************
 * INCLUDES:
 *********************************************************************/
#include "config.h"	/* includes system dependent includes */
#ifdef __STDC__
#include <stdarg.h>
#else
#include <varargs.h>
#endif
#include <time.h>

#include "lincks.h"
#include "monitor.h"
#include "xconfig.h"
#include "libshared.h"

/*********************************************************************
 * EXTERNALLY-CALLABLE ROUTINES FOUND IN THIS MODULE:
 *********************************************************************/
#include "f_monerrors.h"

/*********************************************************************
 * EXTERNALLY-AVAILABLE	DATA FOUND IN THIS MODULE:
 *********************************************************************/
/* none */

/*********************************************************************
 * EXTERNAL FUNCTIONS USED BY THIS MODULE:
 *********************************************************************/
/* libc */
#if defined(sun) || defined(__sun__)
extern time_t time P_((time_t *tloc));
#endif

/*********************************************************************
 * EXTERNAL DATA STRUCTURES USED BY THIS MODULE:
 *********************************************************************/
extern UID uidcom;		/* monitormain.c */
extern int errno;		/* errno.h */
extern int sys_nerr;		/* errno.h */
extern char *sys_errlist[];	/* errno.h */

/*********************************************************************
 * LOCAL DEFINES, STRUCTS, TYPEDEFS, ETC.:
 *********************************************************************/
/* none */

/*********************************************************************
 * INTERNAL FUNCTIONS USED BY THIS MODULE:
 *********************************************************************/
/* none */

/*********************************************************************
 * INTERNAL (STATIC) DATA: 
 *********************************************************************/
/* none */

/*  */
/**********************************************************************
 * Function: void Error(va_alist)
 * 
 * Prints an error message to the error log file
 *
 * Modifications:
 *      <list mods with name and date>
 */
#ifdef lint
/*VARARGS2*//*ARGSUSED*/
void Error(no_, format_, va_alist)
    int no_;
    char *format_;
    va_dcl
#else
#ifdef __STDC__
void Error(int no, char *format, ...)
#else
void Error(va_alist)
    va_dcl
#endif /* n __STDC__ */
#endif /* n linst */
{
    va_list ap;

    char msg[256], error[256], uerror[256];
    char userid[8];
    struct tm *t, *localtime();
    TIME secs;

#ifndef __STDC__
    int no;
    char *format;
    /* Get arguments */
    va_start(ap);
    no = va_arg(ap, int);
    format = va_arg(ap, char *);
#else
    va_start(ap,format);
#endif /* __STDC__ */   
    if (format == NULL)
	format = "(null)";

    /* Get current time */
    (void)time(&secs);
    t = localtime(&secs);
    
    if (no > ER_SYSERR)
	errno = 0;
    
    /* Compose error message */
    (void)vsprintf(msg, format, ap);
    va_end(ap);
    switch (uidcom) {
    case UNKNOWN:
	(void)strcpy(userid, "U");
	break;
    case SUPERUSER:
	(void)strcpy(userid, "S");
	break;
    default:
	(void)sprintf(userid, "%d", uidcom);
    }
    error[0] = uerror[0] = '\0';
    if (no != 0)
	(void)sprintf(error, "<ERROR: %d>", no);
    if (no != 0 && 0 < errno && errno <= sys_nerr)
	(void)sprintf(uerror, "<UNIX: %s>", sys_errlist[errno]);
    
    /* Print time followed by error message on file */
    LogFile(MONITORLOG, 
            "%02d-%02d-%02d  %02d:%02d:%02d  User: (%s) %d  DB: %s\n                    %s  %s  %s\n\n",
	     t->tm_year, t->tm_mon + 1, t->tm_mday,
	     t->tm_hour, t->tm_min, t->tm_sec,
	     userid, TCPIPNO, DBDIR, msg, error, uerror);
	     /* Modified 25 Sep, 1991: mikoh */
    /* Print on stderr if neccesary */
    if (no == ER_INIT) {
	(void)fprintf(stderr, "%s %s\n", msg?msg:"", uerror);
	(void)fflush(stderr);
    }
}
