/* 
 * Linkoping Intelligent Communication of Knowledge System (LINCKS)
 *      Copyright (C) 1993, 1994 Lin Padgham, Ralph Rnnquist
 *       Department of Computer and Information Sciences
 *		University of Linkoping, Sweden
 *		    581 83 Linkoping, Sweden
 *		       lincks@ida.liu.se
 *
 * These collective LINCKS programs are free software; you can 
 * redistribute them and/or modify them under the terms of the GNU
 * General Public License as published by the Free Software Foundation,
 * version 2 of the License.
 *
 * These programs are distributed in the hope that they will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the programs; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* 
 * MODULE NAME: 	verify.c
 *
 * SCCSINFO:		@(#)verify.c	1.7 5/3/94
 *
 * ORIGINAL AUTHOR(S):  
 *
 * MODIFICATIONS:
 *      1993-11-02 Martin Sjlin. Use PASSWD_FORMAT to read
 *                 each field from the password file.
 *      1993-11-03 Martin Sjlin. Reads from password file. Uses 
 *                 fgets to read just one line.
 *	<list mods with name and date>
 *
 * DESCRIPTION:
 *	This file contains VerifyUser, UserName and ChangePassword
 */
/*********************************************************************
 * INCLUDES:
 *********************************************************************/
#include "config.h"	/* includes system dependent includes */
#include "lincks.h"
#include "libshared.h"
#include "xconfig.h"

/*********************************************************************
 * EXTERNALLY-CALLABLE ROUTINES FOUND IN THIS MODULE:
 *********************************************************************/
UID VerifyUser P_(( char *username, char *password ));

/*********************************************************************
 * EXTERNALLY-AVAILABLE	DATA FOUND IN THIS MODULE:
 *********************************************************************/
/* none */

/*********************************************************************
 * EXTERNAL FUNCTIONS USED BY THIS MODULE:
 *********************************************************************/
/* none */

/*********************************************************************
 * EXTERNAL DATA STRUCTURES USED BY THIS MODULE:
 *********************************************************************/
/* none */

/*********************************************************************
 * LOCAL DEFINES, STRUCTS, TYPEDEFS, ETC.:
 *********************************************************************/
/* none */

/*********************************************************************
 * INTERNAL FUNCTIONS USED BY THIS MODULE:
 *********************************************************************/
/* none */

/*********************************************************************
 * INTERNAL (STATIC) DATA: 
 *********************************************************************/
static char line[512];			/* line buffer for fgets */

/*  */
/**********************************************************************
 * Function: UID VerifyUser(char *username, char *password)
 * 
 * Verifies a user name against it's password
 * Returns user id if successful
 *
 * Modifications:
 *      <list mods with name and date>
 */
UID VerifyUser(username, password)
  char *username;
  char *password;
{
  FILE *usersfp;
  char f_username[256];
  char f_password[256];
  int f_uid;
  UID uid = UNKNOWN;

  /* The current implementation does not allow empty fields */
  if (username[0] == '\0' || password[0] == '\0') {
    LogMessage(uid, "netserv: Empty userid or password given\n");
    return (UID)UNKNOWN;
  }

  /* Open password file */
  if ((usersfp = fopen(PASSWDFILE, "r")) == NULL) {
    LogMessage(uid, 
	       "netserv: Failed to open password file '%s'\n",
	       PASSWDFILE);
    return(uid);
  }

  /* Set lock */
  if ((readlockit(fileno(usersfp), (off_t)0, (off_t)0)) == -1) {
    LogMessage(uid,
	       "netserv: Failed to set lock on '%s'\n",
	       PASSWDFILE);
    (void)fclose(usersfp);
    return(uid);
  }

  /* Search for user name */
  while (fgets(line,sizeof(line)-1,usersfp) != NULL) 
    if (sscanf(line, PASSWD_FORMAT,f_username, &f_uid, f_password) == 3 &&
	strcmp(f_username,username) == 0) {
#ifdef CRYPT_PASSWD
	/* must have a password in string, otherwise we do not allow login */
	if (f_password[0] != '\0') {
	  char salt[4];

	  salt[0] = f_password[0];
	  salt[1] = f_password[1];
	  salt[2] = 0;

	  /* check against crypted password */
	  if (strcmp(f_password,crypt(password, salt)) == 0)
	    uid = f_uid;
	}
#else
	/* Check password also */
	if(strcmp(f_password, password) == 0)
	  uid = f_uid;
#endif /* n CRYPT_PASSWD */
	goto exit;
      } /* if (sscanf(line, ... )) */
  
  LogMessage(uid, "netserv: did not find user %s in passwd file\n",
	          username);

exit:
  unlockit(fileno(usersfp), (off_t)0, (off_t)0);
  (void)fclose(usersfp);
  return ((UID) uid);
}
