/* 
 * Linkoping Intelligent Communication of Knowledge System (LINCKS)
 *      Copyright (C) 1993, 1994 Lin Padgham, Ralph Rnnquist
 *       Department of Computer and Information Sciences
 *		University of Linkoping, Sweden
 *		    581 83 Linkoping, Sweden
 *		       lincks@ida.liu.se
 *
 * These collective LINCKS programs are free software; you can 
 * redistribute them and/or modify them under the terms of the GNU
 * General Public License as published by the Free Software Foundation,
 * version 2 of the License.
 *
 * These programs are distributed in the hope that they will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the programs; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* 
 * MODULE NAME:         systypes.h
 *
 * SCCSINFO:            @(#)systypes.h	1.11 5/30/94
 *
 * ORIGINAL AUTHOR(S):  David Partain, 1992-11-24
 *
 * MODIFICATIONS:
 *	<name and date and description>
 * DESCRIPTION:
 * 
 * Contains some declaration that Sun doesn't have in standard
 * include files or things that are screwy.  This is supposed to
 * keep lint and gcc -ansi ... happy.
 */
#ifndef SYSTYPES_H
#define SYSTYPES_H

#if defined(CRYPT_PASSWD)
extern char *crypt P_((const char * key, const char * salt));
#endif	/* CRYPT_PASSWD */

#if (defined(sun)||defined(__sun__))&& !(__STDC__ == 0) && !defined(SVR4)
extern int accept P_((int s, void *addr, int *addrlen));
extern unsigned int alarm P_((unsigned int sec));
extern int atoi P_((const char *str));
extern int bind P_((int s, const void *addr, int addrlen));
extern int chdir P_((const char *path));
extern int close P_((int filedes));
extern int connect P_((int s, const void *addr,int addrlen));
extern int creat P_((/* char *path, mode_t modes */));
extern int dup2 P_((int fd, int fd2));
extern int execl P_((/* char *path, ... */));
extern int fclose P_((FILE *stream));
extern int fflush P_((FILE *strean ));
extern int flock P_((int fd, int operation));
extern pid_t fork P_((void));
extern int fprintf P_((FILE *stream, const char *format, ...));
extern int fputs P_((const char *s, FILE *stream));
extern int fscanf P_((FILE *stream, const char *format, ...));
extern int getdtablesize P_((void));
extern char *getenv P_((const char *name));
extern int gethostname P_((char *hostname, size_t size));
extern int getopt P_((int argc, char * const argv[], const char *optstring));
extern pid_t getpid P_((void));
extern int getrlimit P_((/* int resource,struct rlimit *rlp */)); 
extern int ioctl P_((int fd, int request, ...));
extern int listen P_((int s, int backlog));
extern int lockf P_((int fd, int function, off_t size));
extern off_t lseek P_((int fd, off_t offset, int whence));
extern int pipe P_((int fd[2]));
extern int printf P_((const char* format, ...));
extern long random P_((void));
extern int read P_((int fd, void *buf, READ_SIZE_T nbyte));
extern int recv P_((int s, void *buf, int len, int flags));
extern int rename P_((const char *src, const char *dst));
extern int scanf P_(( char* format, ...));
extern int select P_((/* size_t nfds, fd_set *rdfd, fd_set *wrfd, fd_set *exfd, 
			  struct timeval *timeout */)); 
extern int send P_((int s, const void *buf, int len, int flags));
extern int setlinebuf P_((FILE *stream));
extern int setsockopt P_((int s, int level, int optname, const void *optval, int optlen));
extern int setvbuf P_((FILE *stream, char *buf, int type, size_t size));
extern int srandom P_((int seed));
extern unsigned int sleep P_((unsigned int seconds));
extern int socket P_((int s, int type, int procotol));
extern char *sprintf P_(( /* char *s, const char *format, ... */));
extern int sscanf P_(( char *s, const char *format, ...));
extern long strtol P_((const char *str, char **ptr, int base));
extern char *strcpy P_((char *s1,const char *s2 ));
extern int  shutdown P_((int s, int how));
extern int system P_((const char *command));
extern int tolower P_((int c));
extern void usleep P_((unsigned useconds));
extern int vfprintf P_((FILE *stream, const char *format, ...));
extern int vprintf P_((const char *format, ...));
#if !(defined(SYSV) || defined(SVR4))	/* solaris has this in stdio */
extern int vsprintf P_((char *s, const char *format, char *arg));
#endif
extern int xdr_entry P_((/* XDR *xdrsp, L_ENTRY *l_entry */));
extern int xdr_new P_((/* XDR *xdrsp, N_ENTRY *n_entry */));
extern pid_t wait3 P_((/* int *statusp, int options, struct rusage *rusage */)); 
extern int write P_((int fd, const void *buf, WRITE_SIZE_T nbyte));
extern int _flsbuf P_((unsigned char c, FILE *stream));
extern int _filbuf P_((FILE *stream));	/* _filbuf is used in the macro getchar */
#ifdef lint	
extern void exit P_((int status)); /* this is right.  stdlib.h is wrong */
extern int perror P_((const char *s));
#else
/* exit() in stdlib.h claims it returns int.  it lies. */
extern void perror P_((const char *s ));
#endif /* lint */
#endif /* sun */
#endif /* SYSTYPES_H */
