/* 
 * Linkoping Intelligent Communication of Knowledge System (LINCKS)
 *      Copyright (C) 1993, 1994 Lin Padgham, Ralph Rnnquist
 *       Department of Computer and Information Sciences
 *		University of Linkoping, Sweden
 *		    581 83 Linkoping, Sweden
 *		       lincks@ida.liu.se
 *
 * These collective LINCKS programs are free software; you can 
 * redistribute them and/or modify them under the terms of the GNU
 * General Public License as published by the Free Software Foundation,
 * version 2 of the License.
 *
 * These programs are distributed in the hope that they will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the programs; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* 
 * MODULE NAME: 	ltext.c
 *
 * SCCSINFO:		@(#)ltext.c	1.11 6/9/94
 *
 * ORIGINAL AUTHOR(S):  ????
 *
 * MODIFICATIONS:
 *	<list mods with name and date>
 *
 * DESCRIPTION:
 *
 * XlText Widget
 *
 *********************************************************************
 * EXTERNALLY-CALLABLE ROUTINES FOUND IN THIS MODULE:
 *********************************************************************
 * int XlTextNumLines(Widget widget)
 */

/*********************************************************************
 * INCLUDES:
 *********************************************************************/
#include "config.h"	/* includes system dependent includes */

#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#ifdef NEED_X11_XAW_TEXT_H
#include <X11/Xaw/Text.h>
#endif /* NEED_X11_XAW_TEXT_H */
#include <X11/Xaw/XawInit.h>
#include <X11/Xaw/Cardinals.h>

#include "ltextsrcP.h"
#include "ltextsinkP.h"
#include "ltextP.h"

/*********************************************************************
 * EXTERNAL FUNCTIONS USED BY THIS MODULE:
 *********************************************************************/
#include "f_ltextsink.h"

/*********************************************************************
 * EXTERNAL DATA STRUCTURES USED BY THIS MODULE:
 *********************************************************************/
extern int LL_uid;		/* from liblincks.a */
extern char *sys_errlist[];	/* from liblincks.a */
extern int sys_nerr;		/* from liblincks.a */
extern int errno;		/* from liblincks.a */
extern char *_XlDefaultTextTranslations;	/* ltexttr.c */

/*********************************************************************
 * LOCAL DEFINES, STRUCTS, TYPEDEFS, ETC.:
 *********************************************************************/
#define TAB_COUNT 32

/*********************************************************************
 * INTERNAL FUNCTIONS USED BY THIS MODULE:
 *********************************************************************/
static void ClassInitialize P_(( void ));
static void CreateSourceSink P_(( Widget widget, ArgList args, Cardinal
                                   *num_args ));
static void Destroy P_(( Widget w ));
static void Initialize P_(( Widget request, Widget neww ));
static void Realize P_(( Widget w, Mask *valueMask, XSetWindowAttributes
                          *attributes ));

/*********************************************************************
 * INTERNAL (STATIC) DATA: 
 *********************************************************************/
#define Offset(field) XtOffset(XlTextWidget, xltext.field)
static XtResource resources[] = {
  {XtNreference, XtCreference, XtRImmediate, sizeof(widget_info *), 
     Offset(reference), XtRImmediate, NULL}, 
  {XtNautosave, XtCautosave, XtRInt, sizeof(int), 
     Offset(auto_save), XtRInt, 0}, 
};

/*********************************************************************
 * EXTERNALLY-AVAILABLE	DATA FOUND IN THIS MODULE:
 *********************************************************************/
XlTextClassRec XltextClassRec = {
  { /* core fields */
    /* superclass	    	*/	(WidgetClass) &textClassRec,
    /* class_name		*/	"XlText",
    /* widget_size     		*/	sizeof(XlTextRec),
    /* class_initialize */      ClassInitialize,
    /* class_part_init  */	NULL,
    /* class_inited     */      FALSE,
    /* initialize       */      (XtInitProc)Initialize,
    /* initialize_hook  */	CreateSourceSink,
    /* realize          */      Realize,
    /* actions          */      xltextActionsTable,
    /* num_actions      */      0, 
    /* resources        */      resources,
    /* num_ resource    */      XtNumber(resources),
    /* xrm_class        */      NULLQUARK,
    /* compress_motion  */      TRUE,
    /* compress_exposure*/      XtExposeGraphicsExpose,
    /* compress_enterleave*/	TRUE,
    /* visible_interest */      FALSE,
    /* destroy          */      Destroy,
    /* resize           */      XtInheritResize,
    /* expose           */      XtInheritExpose,
    /* set_values       */      NULL, 
    /* set_values_hook  */	NULL,
    /* set_values_almost*/	XtInheritSetValuesAlmost,
    /* get_values_hook  */	NULL,
    /* accept_focus     */      XtInheritAcceptFocus,
    /* version          */	XtVersion,
    /* callback_private */      NULL,
    /* tm_table         */      NULL, /* Set up in ClassInitialize */
    /* query_geometry	*/	XtInheritQueryGeometry
  },
  { /* Simple fields */
    /* change_sensitive	*/	XtInheritChangeSensitive
  },
  { /* text fields */
    /* empty            */      0
  },
  { /* ltext fields */
    /* empty            */      0
  }
};

WidgetClass XltextWidgetClass = (WidgetClass)&XltextClassRec;

/*  */
/**********************************************************************
 * Function: static void ClassInitialize()
 * 
 * Modifications:
 *      <list mods with name and date>
 */
static void ClassInitialize()
{
  XawInitializeWidgetSet();
  XltextClassRec.core_class.num_actions = xltextActionsTableCount;
  XltextWidgetClass->core_class.tm_table = _XlDefaultTextTranslations;
}

/*  */
/* ARGSUSED */
/**********************************************************************
 * Function: static void Initialize(Widget request, Widget neww)
 * 
 * Modifications:
 *      <list mods with name and date>
 */
static void Initialize(request, neww)
  Widget request, neww;
{
  ((XlTextWidget)neww)->xltext.change_cnt = 0;

  /* superclass Initialize can't set the following,
   * as it didn't know the source or sink when it was called */
  if (request->core.height == DEFAULT_TEXT_HEIGHT)
    neww->core.height = DEFAULT_TEXT_HEIGHT;
}

/*  */
/**********************************************************************
 * Function: static void CreateSourceSink(THREE PARAMETERS)
 * Parameters:
 *	Widget widget
 *	ArgList args
 *	Cardinal *num_args
 * 
 * Modifications:
 *      <list mods with name and date>
 */
static void CreateSourceSink(widget, args, num_args)
  Widget widget;
  ArgList args;
  Cardinal *num_args;
{
  XlTextWidget w = (XlTextWidget) widget;
  int i, lines;
  int tabs[TAB_COUNT], tab;
  Dimension width, maxwidth;
  XlTextSinkObject sink;
  XlTextSrcObject  src;
  
  w->text.source = XtCreateWidget( "textSource", XltextSrcObjectClass,
				   widget, args, *num_args );
  w->text.sink = XtCreateWidget( "textSink", XltextSinkObjectClass,
				 widget, args, *num_args );

  sink = (XlTextSinkObject)(w->text.sink);
  src  = (XlTextSrcObject)(w->text.source);

  for (i=0, tab=0 ; i < TAB_COUNT ; i++) 
    tabs[i] = (tab += 8);
  
  XawTextSinkSetTabs(w->text.sink, TAB_COUNT, tabs);

  /* 
   * Initialize XlText widget height and width according to 
   * its contents
   */

  width = maxwidth = w->text.margin.left;
  lines = 0;

  for (i=0; i<=src->xltext_src.length; i++) {
    if ((src->xltext_src.string[i] == '\n') ||
	(src->xltext_src.string[i] == '\0')) {
      lines++;
      if (width > maxwidth) {
	/* if a src line doesn't really fit into 1 line */
	maxwidth = width;
      }
      /* clean up row */
      width = 0;
    } else {
      width += CharWidth((Widget)sink, (int)width, 
			 (unsigned char)src->xltext_src.string[i]);
    }
  }

  maxwidth += w->text.margin.right;
#if 0
  maxwidth += 5 * CharWidth((Widget)sink,0,(unsigned char)'M');/* widest */
#endif
  if (w->core.width < maxwidth)
    w->core.width = maxwidth;
  
  w->core.height = VMargins(w) + XawTextSinkMaxHeight(w->text.sink, lines);

  XawTextDisableRedisplay(widget);
  XawTextEnableRedisplay(widget);

  /*
   *	TURN OFF CURSOR!
   */ 
  XawTextDisplayCaret((Widget)widget, FALSE);
  sink->xltext_sink.laststate = XawisOff;

}

/*  */
/**********************************************************************
 * Function: static void Destroy(Widget w)
 * 
 * Modifications:
 *      <list mods with name and date>
 */
static void Destroy(w)
  Widget w;
{
#if (XT_REVISION >= 5) && !defined(NO_TEXT_COPY_AREA) /* not in R4 */
  struct text_move *offset = ((XlTextWidget)w)->text.copy_area_offsets;
  struct text_move *free_this = NULL;

  while (offset) {
    free_this = offset;
    offset = offset->next;
    free((FREEPTR *)free_this);
  }
  ((XlTextWidget)w)->text.copy_area_offsets = NULL;
#endif

  XtDestroyWidget( ((XlTextWidget)w)->text.source);
  XtDestroyWidget( ((XlTextWidget)w)->text.sink );
}

/*  */
/**********************************************************************
 * Function: int XlTextNumLines(Widget widget)
 * 
 * Modifications:
 *      <list mods with name and date>
 */
int XlTextNumLines(widget)
  Widget widget;
{
  XlTextWidget w = (XlTextWidget) widget;
  int i;
  int lines = 0;
  XlTextSrcObject  src = (XlTextSrcObject)w->text.source;
  struct _Piece *piece;
  

  for (piece = src->xltext_src.first_piece;piece != NULL; piece=piece->next) {
    for (i=0; i<piece->used; i++)
      if ((piece->text[i] == '\n') || (piece->text[i] == '\0'))
        lines++;
  }
  return lines;
}

/*  */
/**********************************************************************
 * Function: static void Realize(THREE PARAMETERS)
 * Parameters:
 *	Widget w
 *	Mask valueMask
 *	XSetWindowAttributes *attributes
 * 
 * Modifications:
 *      <list mods with name and date>
 */
static void Realize(w, valueMask, attributes)
  Widget w;
  Mask *valueMask;
  XSetWindowAttributes *attributes;
{
  attributes->bit_gravity = 1;		/* NorthWestGravity */
  (*valueMask) |= CWBitGravity;		/* so it sets it */
  (*textClassRec.core_class.realize)(w, valueMask, attributes);
}
