/* 
 * Linkoping Intelligent Communication of Knowledge System (LINCKS)
 *      Copyright (C) 1993, 1994 Lin Padgham, Ralph Rnnquist
 *       Department of Computer and Information Sciences
 *		University of Linkoping, Sweden
 *		    581 83 Linkoping, Sweden
 *		       lincks@ida.liu.se
 *
 * These collective LINCKS programs are free software; you can 
 * redistribute them and/or modify them under the terms of the GNU
 * General Public License as published by the Free Software Foundation,
 * version 2 of the License.
 *
 * These programs are distributed in the hope that they will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the programs; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * MODULE NAME:		ltextP.h
 *
 * SCCSINFO:		@(#)ltextP.h	1.2 5/3/94
 *
 * ORIGINAL AUTHOR(S):	???
 *
 * MODIFICATIONS:
 *	<list mods with name and date>
 *
 * DESCRIPTION:
 *	Private header file for XlText Widget
 */
#ifndef _XlTextP_h
#define _XlTextP_h

#include "aimtypes.h"
#include "ltext.h"
#include <X11/Xaw/TextP.h>

extern XtActionsRec xltextActionsTable[];
extern Cardinal xltextActionsTableCount;

#define DEFAULT_XLTEXT_WIDTH 70

typedef struct {
  int empty1;
} XlTextClassPart;

typedef struct _XlTextClassRec {
  CoreClassPart	        core_class;
  SimpleClassPart	simple_class;
  TextClassPart	        text_class;
  XlTextClassPart	xltext_class;
} XlTextClassRec;

extern XlTextClassRec XltextClassRec;

typedef struct {
  /* resources */
  widget_info *reference; /* info node and reference structure */
  int	auto_save;	  /* how frequently to save changes */

  /* private state */
  int	change_cnt;	/* how much has changed in the text buffer */
} XlTextPart;

typedef struct _XlTextRec {
  CorePart	core;
  SimplePart	simple;
  TextPart	text;
  XlTextPart	xltext;
} XlTextRec;

#endif /* _XlText_P */
