/* 
 * Linkoping Intelligent Communication of Knowledge System (LINCKS)
 *      Copyright (C) 1993, 1994 Lin Padgham, Ralph Rnnquist
 *       Department of Computer and Information Sciences
 *		University of Linkoping, Sweden
 *		    581 83 Linkoping, Sweden
 *		       lincks@ida.liu.se
 *
 * These collective LINCKS programs are free software; you can 
 * redistribute them and/or modify them under the terms of the GNU
 * General Public License as published by the Free Software Foundation,
 * version 2 of the License.
 *
 * These programs are distributed in the hope that they will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the programs; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* 
 * MODULE NAME: 	uimpropagate.c
 *
 * SCCSINFO:		@(#)uim_propagate.c	1.7 5/17/94
 *
 * ORIGINAL AUTHOR(S):  David Partain, 12-Dec-1991
 *
 * MODIFICATIONS:
 *      1994-05-17 Martin Sjlin. Moved free_pqe_element into
 *                 aimpropagate since it is independent of this
 *                 module.
 *	<list mods with name and date>
 *
 * DESCRIPTION:
 *	This file contains UIM layer functions which have to do with
 *	propagation.
 *
 */

/******************************************************************
 * INCLUDES: (to get struct propagation_q_element)
 ******************************************************************/
#ifdef lint
#include <X11/IntrinsicP.h>
#endif
#include "config.h"	/* includes system dependent includes */
#include "aimtypes.h"

/******************************************************************
 * EXTERNALLY-CALLABLE ROUTINES FOUND IN THIS MODULE:
 ******************************************************************/
#include "f_uim_propagate.h"

/******************************************************************
 * EXTERNAL VARIABLES USED BY THIS MODULE:
 ******************************************************************/
/* for printing error messages in propagation routines */
extern int LL_uid;		/* liblincks.a */
extern int sys_nerr;		/* liblincks.a */
extern char *sys_errlist[];	/* liblincks.a */
extern int errno;		/* liblincks.a */

/******************************************************************
 * EXTERNAL FUNCTIONS USED BY THIS MODULE:
 ******************************************************************/
#include "f_xstuff.h"
#include "f_aimpropagate.h"		/* free_pqe_element */

/*  */
/**********************************************************************
 * Function: int propagation_queue_process(propagation_q_element *pqe_element)
 * 
 * This function makes the calls to makewidget(), changewidget() and
 * deletewidget() based upon the information that is in the propagation
 * queue that is passed to it.  No optimisation of the queue
 * is done within this function.  It is assumed that whatever
 * "intelligent" processing is desired will be done by calling
 * propagation_queue_optimise() or a similar function written specific to a
 * UIM.  This function blindly goes through a queue and calls the
 * appropriate functions.  It then frees all the memory associated with
 * the queue.
 * 
 * Arguments:
 * (1) pointer to a pqe_element whose queue we are going to process.
 * This MUST be the last element in the queue, pointed to by
 * reference_struct -> pqueue.tail.
 * 
 * Always returns SUCCESS at this point unless there are invalid
 * parameters or a corrupted queue.  Should that happen, fatal errors are
 * given.  Extensibility, however, indicates that we might at some point
 * wish to return FAIL where we are currently giving a fatal error.
 * 
 * This is a UIM function which will be a possible default for a UIM.
 * However, the UIM can choose to write its own queue processing routine.
 * 
 * The caller is responsible for null'ing pqueue.head and pqueue.tail  in
 * the reference structure with which this queue is associated.
 * 
 * Modifications:
 *	<list mods here with date and name>
 */
int propagation_queue_process(pqe_element)
  propagation_q_element *pqe_element;
{
  propagation_q_element *tmp_pqe_element = (propagation_q_element *) NULL;
  propagation_q_element *tmp_pqe_element2 = (propagation_q_element *) NULL;
  formentry *tmp_format_entry = (formentry *) NULL;
  int prev_format_level = 0;
  Widget last_created = (Widget) NULL;

  if (pqe_element == NULL) {
    fatal_error("propagation_queue_process: null parameter\n");
  }
  for (tmp_pqe_element = pqe_element;
       tmp_pqe_element != NULL;
       tmp_pqe_element = tmp_pqe_element -> pqe_next) {

    switch (tmp_pqe_element -> pqe_operation) {
      case PQE_OP_MAKEWIDGET:
 	/* deal with formats in there.*/
	prev_format_level = getarglevel();
        tmp_format_entry = tmp_pqe_element -> pqe_format;
	while (tmp_format_entry != (formentry *) NULL) {
	  pusharg(tmp_format_entry -> formid, tmp_format_entry -> formval);
	  tmp_format_entry = tmp_format_entry -> next;
	}
        /* params:  the infonode to associate with the */
	/* widget to be made and the previous widget */
	if (tmp_pqe_element->pqe_widget) {
          makewidget(tmp_pqe_element->pqe_infonode,
		     (Widget) tmp_pqe_element->pqe_widget);
	}
	else {
	  makewidget(tmp_pqe_element->pqe_infonode, 
		     (Widget) last_created);
	}
	last_created = tmp_pqe_element->pqe_infonode -> widp;
	/* return the format stack (in xstuff.c) to its previous state */
	popargs(prev_format_level);
        break;
      case PQE_OP_CHANGEWIDGET:
        changewidget(tmp_pqe_element -> pqe_infonode);
        break;
      case PQE_OP_REMOVEWIDGET:
        deletewidget((Widget) tmp_pqe_element -> pqe_widget);
        break;
      case PQE_OP_COMPLETED:
        /* do nothing.  might be used in the future to be able to
        process the queue in some way without physically removing
        the memory, but rather by marking the entry as completed. */
        break;
      default:
        fatal_error("propagation_queue_process: unknown operation\n");
        break;
    } /* switch */
  } /* for */

/* 
 * free up all the elements in the queue.  This is done by calls to a
 * function on each element because it might be useful to have this 
 * callable function elsewhere.
 */
  tmp_pqe_element = pqe_element;
  while (tmp_pqe_element != NULL) {
     tmp_pqe_element2 = tmp_pqe_element;
     tmp_pqe_element = tmp_pqe_element -> pqe_next;
     free_pqe_element(tmp_pqe_element2);
  } /* while */
  return SUCCESS;	/* all went well */
}

