/* 
 * Linkoping Intelligent Communication of Knowledge System (LINCKS)
 *      Copyright (C) 1993, 1994 Lin Padgham, Ralph Rnnquist
 *       Department of Computer and Information Sciences
 *		University of Linkoping, Sweden
 *		    581 83 Linkoping, Sweden
 *		       lincks@ida.liu.se
 *
 * These collective LINCKS programs are free software; you can 
 * redistribute them and/or modify them under the terms of the GNU
 * General Public License as published by the Free Software Foundation,
 * version 2 of the License.
 *
 * These programs are distributed in the hope that they will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the programs; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* 
 * MODULE NAME: 	xlincks_help.c
 *
 * SCCSINFO:		@(#)xlincks_help.c	1.6 5/3/94
 *
 * ORIGINAL AUTHOR(S):  David Partain, 1992-03-25
 *
 * MODIFICATIONS:
 *	<list mods with name and date>
 *
 * DESCRIPTION:
 *
 * This module has all the code for help facilities in xlincks.
 */

/*********************************************************************
 * INCLUDES:
 *********************************************************************/
#include "config.h"	/* includes system dependent includes */
#include "aimtypes.h"		/* to get POPUP_MESS_HELP */

/*********************************************************************
 * EXTERNALLY-AVAILABLE	DATA FOUND IN THIS MODULE:
 *********************************************************************/
/* none */

/*********************************************************************
 * EXTERNALLY-CALLABLE ROUTINES FOUND IN THIS MODULE:
 *********************************************************************/
#include "f_xlincks_help.h"

/*********************************************************************
 * EXTERNAL FUNCTIONS USED BY THIS MODULE:
 *********************************************************************/
#include "f_aimbuildref.h"
#include "f_blddisplay.h"
#include "f_xstuff.h"

/*********************************************************************
 * EXTERNAL DATA STRUCTURES USED BY THIS MODULE:
 *********************************************************************/
extern label sysroot;

/*********************************************************************
 * LOCAL DEFINES, STRUCTS, TYPEDEFS, ETC.:
 *********************************************************************/
/* none */

/*********************************************************************
 * INTERNAL FUNCTIONS USED BY THIS MODULE:
 *********************************************************************/
static int do_helpinDB P_(( char *button ));

/*********************************************************************
 * INTERNAL (STATIC) DATA: 
 *********************************************************************/
/*
 * A table associating button widget name with default help text.
 * The same names are used in aimcommand.c and xstuff.c.
 */

static struct {char *button, *helptext;} helptexttable[] = {
  { WSTOREWINDOW,
"Store any changes that have been \n\
made in this window into the database."},

  { WCLOSEWINDOW,
"Closes the window. If there are \n\
any changes, you are asked if \n\
you want to save them."},

  { WREFETCH,
"Refetch does just that.  Under \n\
normal circumstances, a composition is\n\
only retrieved from the database\n\
once.  That version is then used by\n\
the workspace from that point on.\n\
However, with this command, you can\n\
force a retrieval of the latest \n\
version of a composition."},

  { WPROMOTE,
"Given the capability of browsing \n\
through the history of both individual\n\
items as well as compositions, it\n\
makes sense that one should be able \n\
to go back to old versions.  That's\n\
what this is for.  After browsing\n\
through versions of compositions \n\
and objects, if you've come up with\n\
the way you want the composition\n\
to look, issuing this command will\n\
promote this version  to be the\n\
latest version and be made editable."},

  { WEXPORTWINDOW,
"Creates an external text file from \n\
the information displayed in this\n\
window.  This is done through inter-\n\
action with the menu created by this \n\
command.  You can either export the \n\
text as LaTeX or as straight text.  \n\
At present, these are the only \n\
possibilities."},

  { WDUPLICATE,
"Create a duplicate of the window."},

  { WSHOWGPD,
"This command button produces a \n\
display of the GPD used when producing\n\
the selected display. The command \n\
applies the generic presentation \n\
description called \"gpd\" to the\n\
object used as generic presentation\n\
in the selected window."},

  { WSHOWHISTORY,
"This command provides a history \n\
graph of the composition presented in\n\
the window.  The graph itself consists\n\
of a series of circled numbers.  The\n\
leftmost circle represents the object\n\
itself and the subsequent circles\n\
represent individual versions. The\n\
word \"Hidden\", if present, indicates\n\
that only a portion of the history is\n\
shown."},

  { WSHOWBT,
"Each composition is created using \n\
something called a binding table.\n\
This button will show the binding\n\
table used for this composition. \n\
NOTE:  unless you know what you're \n\
doing, don't use this button.\n\
Editing binding tables can have \n\
destructive effects!"},

  { WDUMPREFSTR,
"Put up a graphical representation \n\
of the underlying structure built\n\
from the database information and \n\
used in building the display for\n\
this window."},

  { WEXPAND,
"By clicking on this button, you \n\
bring up a menu which contains a list\n\
of GPD's to which you have access.\n\
You can then expand an item using\n\
an alternate GPD than the standard \n\
one by clicking first on the item\n\
you wish to expand and then on the \n\
name of the GPD that you wish to use." },

  { WCUTANDPASTE,
"Pops up a menu for use in structure\n\
editing." },

  { WITEMHISTORY,
"By choosing an item (by either clicking\n\
there or having the focus there) and\n\
using this command, you will see a \n\
graphical representation of the history\n\
of the database object of which this\n\
item is a part.  You can then click\n\
in the circles on the graph to make \n\
the version of that object appear in\n\
the composition." },

  { WUSERROOT,
"Should a user accidentally remove\n\
the window with his/her user root\n\
object (login window) or simply \n\
wish to have another copy, clicking\n\
on this button will rebuild it." },

  { WHELPWINDOW,
"Pops up the window which has the \n\
various bits of online documentation\n\
for xlincks." },

  { WADDLINK,
"This button allows you to crosslink\n\
(to share information).  Do as follows:\n\
First, click on the item you want to \n\
make a link TO (or link in, depending\n\
on how you want to express it), then\n\
click a second time on the item where\n\
you want to create the link, then \n\
touch the Add Link button with left \n\
or middle mouse button.  If you click\n\
with the left mouse button, the link\n\
will be placed after, if you click \n\
with the middle, it'll be placed before." },

  { WDBDUMP,
"The DBDump facility is used to dump \n\
a portion of the database to an external\n\
file parsable by t2lincks.  This enables\n\
you to move some portion of the database\n\
to another LINCKS database."},

  { WSTOREALL,
"When clicked upon, all changes that have\n\
been made in all open windows will be saved."},

  { WCLOSEALL,
"This button closes all windows that don't\n\
need to be saved and asks you whether you\n\
want to save the others."},

  { WLOGOUT,
"If there are unsaved changes to any \n\
windows, you will be asked if you wish\n\
to save them, after which a logout \n\
message is sent to the database and \n\
xlincks exits."},

  { WCLOSEAUX,
"Within xlincks there are three kinds\n\
of auxiliary windows which have no \n\
database objects in them.  These are \n\
the history graphs, the export menus, \n\
and the reference structure graphs.\n\
To remove all at once, use this command.\n\
If a window with which an auxiliary\n\
window is associated is closed, so is\n\
the auxiliary window."},

  {0,0}};

/*  */
/***********************************************************************
 * Function: static int do_helpinDB(char *button)
 *
 * Finds the appropriate help text within the database and returns 1.
 * Returns 0 if no help is found.
 *
 * Modifications:
 *	<list mods here with name and date>
 */
static int do_helpinDB(button)
     char *button;
{
  label helpfolder;
  label helptext;

  /* note: SUCCESS == 0 for liblincks */

  if (GLI_GETLINKITEM(&sysroot,"HELP","xlincks",1,&helpfolder))
    return 0;

  if (GLI_GETLINKITEM(&helpfolder,"BUTTON HELP",button,1,&helptext))
    return 0;

  blddisplay(buildref(&helptext,"text",(reference_structure *)NULL));

  return 1;
}

/*  */
/*ARGSUSED*/
/***********************************************************************
 * Function: void do_help_aim(char * topic);
 * 
 * Calls popup_message with the right string when a command button
 * is clicked on with the right mouse button.
 * 
 * The string chosen is based upon the name of the input string name
 *
 * Modifications:
 *	<list mods here with name and date>
 */
void do_help_aim(topic)
  char *topic;
{
  int i;

  if (do_helpinDB(topic))
    return;

  for( i=0; helptexttable[i].button; i++)
    if (strcmp(topic,helptexttable[i].button) == 0) {
      popup_message(POPUP_MESS_HELP,helptexttable[i].helptext);
      return;
    }
  
  short_error("%s%s.", "No help available for ", topic);
  return;
}
