.\" 
.\" Linkoping Intelligent Communication of Knowledge System (LINCKS)
.\"      Copyright (C) 1993, 1994 Lin Padgham, Ralph Rnnquist
.\"       Department of Computer and Information Sciences
.\"		University of Linkoping, Sweden
.\"		    581 83 Linkoping, Sweden
.\"		       lincks@ida.liu.se
.\"
.\" These collective LINCKS programs are free software; you can 
.\" redistribute them and/or modify them under the terms of the GNU
.\" General Public License as published by the Free Software Foundation,
.\" version 2 of the License.
.\"
.\" These programs are distributed in the hope that they will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with the programs; if not, write to the Free Software
.\" Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
.\"
.\" t2lincks man page
.\" author: David Partain
.\" version:  @(#)t2lincks.l	1.11 5/27/94
.\"
.TH t2lincks l "5/27/94" IISLAB "LINCKS System"

.SH NAME
t2lincks \- Load LINCKS database from a specially formatted text file.
.SH SYNOPSIS
.B t2lincks
[
.B \-h
]
[
.B \-c
]
[
.B \-v
]
[
.B \-u \fIusername\fR \-p \fIpassword\fR
]
[
.B \-f \fIt2lincks-file\fR
]
.B database\-dir
.SH DESCRIPTION
\fIt2lincks\fR reads a properly formatted file and loads information
into a LINCKS database. It is used as a bootstrap program by connecting
to the database and `compiling' the text file into the correct database
structure.  Most often it is used to load \fIt2lincks\fR created by the
\fIdbdump\fR program or by the dumping facility within \fIxlincks\fR.
It can also be used to load external text files into the database.
.SH OPTIONS
.TP
.B \-c
This option means that t2lincks will only parse the file to verify that
it's a valid \fIt2lincks\fR file but it will not store the objects in
the database.
.TP
.B \-h
This option prints out a usage and version message.
.TP
.B \-v
This option makes \fIt2lincks\fR very verbose.  Each line of the
\fIt2lincks\fR file is printed as it is processed.
.TP
.B \-u \fIusername\fR \-p \fIpassword\fR
These options allow you to give your username and password on the
command-line rather than logging in in the normal way.
.TP
.B \-f \fIt2lincks-file\fR
This options specifies which file to read for directives.  If no file is
given, stdin will be used.
.TP
.B database\-dir
This option must be present if the environment variable LINCKSDBDIR
is not set.  It specifies the directory holding the database files.  If
LINCKSDBDIR is set, this option will override it.
.SH T2LINCKS SYNTAX
The text file must be of a specific format.  That format is detailed
here.
.LP
Comments are started by a \# sign.
.LP
Strings within the \fIt2lincks\fR file are surrounded by double
quotes and can be broken then continued on the next line by having a
\\ at the end of the line.  Double quotes within the string must be
escaped with the same character.
.LP
The input file contains a description of a database contents in terms
of nodes with attributes and links. The language has the following
kinds of sentences:
.TP
.B \.object name """image string"""
This statement defines an object to be stored in the database.
`name' is a \fIt2lincks\fR internal name used to reference that
object, and the quoted `image string' will be assigned as the image of
the object.
.TP
.B \.binary name < """filename string"""
This statement defines an object to be stored in the database.
`name' is a \fIt2lincks\fR internal name used to reference that
object, and the contents of the quoted `filename string' will be assigned
as the image of the object.
.TP
.B \.binary name """uuencoded image string"""
This statement defines an object to be stored in the database.
`name' is a \fIt2lincks\fR internal name used to reference that
object, and the quoted `uuencoded image string' will be assigned
as the image of the object after conversion from uuencoded format.
Notice that the size of `uuencoded image string' is in practice
limited to around 100 lines (at 45 characters each).
.TP
.B \.set """name""" from """basename""" + """path"""
This statement is used to assign a node `name' to some pre-existent
node. The node is found starting at `basename' and following the link
path as stated by `path'. When \fIt2lincks\fR is started, the local
name "System Root" is known to be the system root node.  For example,
the statement 
.sp
 .set wizard from "System Root" + USERS:lincks:1
.sp
will assign the name `wizard' to the object found by starting at the
system root and following the first link in the link group USERS, field
lincks.  The \fIpath\fR
is one or more occurances of
GROUP:Field:position separated by +. As another example,
to set the name `ex' to
the node at XX:a:3 in the node at YY:b:2 in the system
root object, the following line may be included in the infile:
.sp
 .set ex from "System Root"+YY:B:2+XX:a:3
.sp
The name `%USER%' can be used in a path and will be replaced
with current username to make a generic t2lincks file. To
assign the name "gpdmap" for the current user (of t2lincks),
you write:
.sp
 .set gpdmap from "System Root" + USERS:%USER%:1 + SYSTEM:GPDmaplist:1
.sp
.TP
.B \.group """name""" """GROUP""" """Tag""" : """value"""
This statement assigns values of attributes in a node.  In node `name'
it assigns the value of attribute `GROUP:Tag' the value `value'.

For example, the following would set the attribute CONSTANT:Title in
node N002 to be
the string `hi there'.
.sp
  .group NOO2 "CONSTANT"
         "Title" : "hi there"
.sp
There can be as many assignments within one group as you wish, for
example:
.sp
  .group NOO2 "CONSTANT"
         "Title" : "hi there"
         "Location" : "Downstairs"
         "Duration" : "Four months"
.sp
which will set all these values in the CONSTANT group.  These are
processed in order, which means that a subsequent assignment of the same
attribute value in the same node will override any previous
assignments.
.TP
.B \.links """node1""" """GROUP""" """Tag""" = """node2"""
This statement assigns the values of link items in a node.  In `node1',
it creates a link `GROUP:Tag:1' to the node `node2'.  There can be
multiple, comma-separated node names after the `='.

For example, if you wish to assign a link in the system root object
called USERS:Past to a node called `N005', 
.sp
 .links "System Root" "USERS"
        "Past" = N005
.sp
would do this.  Again, "System Root" is pre-defined in \fIt2lincks\fR.

If you wish to link several nodes to this location, the statement would
look like:
.sp
 .links "System Root" "USERS"
        "Past" = N005, N006, N007
.sp

If you wish to assign several fields within the same link group, the
statement would look like:
.sp
 .links "System Root" "USERS"
        "Past" = N005, N006, N007
        "Present" = N008, N009
        "Prospective" = N010
.sp
which would create links in USERS:Past, USERS:Present, and
USERS:Prospective.
.sp
The nodes linked to may also be specified with the key word `current',
in which case a bound link is set to the (then) current version of the
indicated node. For example, to set a link from node N009 to the
cuurent version of node N010 under name `FOLDER:Item', you would
include the statement:
 .links N009 FOLDER Item = current N010
.TP
.B \.flush """node"""
This statement makes the current setting for the given node to be
stored to the database. Subsequent settings gives a new node version.
.LP
In addition to these sentences, the \fIt2lincks\fR program uses the
`standard meta language' of the parser.  Lines beginning with ``\#''
(number sign) are comments, and lines beginning with ``!'' (exclamation
mark) are meta language sentences.  One particularly useful
meta-command sentence is 
.sp
     !take filename
.sp
which includes `filename' at
\fIt2lincks\fR run time.  In-line comments are allowed \fIonly\fR in between
full target language sentences.
.SH ENVIRONMENT
.TP
.B \fILINCKSDBDIR\fR
specifies the default LINCKS database directory.
.SH SEE ALSO
dbdump(l), xlincks(1), lincks(l)
.SH DIAGNOSTICS
If \fIt2lincks\fR aborts, it will print out the last successful line
parsed.  Correct the offending line and rerun.  If run in verbose mode,
every line of the text file will be printed out.
.LP
Other diagnostics include:
.TP
.B NOPROMPT_LOGIN: login failure
Either the username or the password you gave on the command line
was incorrect for that database.
.TP
.B couldn't retrieve system root
The `system root' object is not available.  This likely means that the
database is corrupted.
.TP
.B Unintelligble input line
The line just read by \fIt2lincks\fR is not a valid statement.
.TP
.B Undefined object symbol: ...
A reference has been made to an undefined node (nodes must be defined
with either \.object or \.set before referenced).
.TP
.B Failed to follow ... - no such link
A \.set statement cannot be carried out because the indicated path is
incomplete in the database.
.TP
.B Couldn't create object ...
.TP
.B Couldn't set attribute: ...
.TP
.B Couldn't set link: ...
These errors usually occur only if t2lincks runs out of memory
or if there is a disturbance in the workspace-database communication.
.TP
.B Storing object ... in database...
Reported at end when nodes are stored in the database. This is not an
error. After having stored a node, t2lincks presents an operation
success code of (0) for ok and (1) for failure.
.TP
.B Flushing object... into database...
Reported when a node name is redefined in a \.set or \.object
sentence.  The previous node is then stored (when created or changed)
and subsequent references concern the new node.  This is not an error.
After having stored a node, t2lincks presents an operation success code
of (0) for ok and (1) for failure.
.TP
.B Reusing object ...
Reported when a node name is redefined in a \.set or \.object sentence,
and the previous object was unchanged. Subsequent references concern
the new node. This is not an error.
.TP
.B Failed to uudecode ...
Reported when the uudecoding process failed. This is an error.
.TP
.B Failed to open file ...
Reported when t2lincks could not open the specified file in a \.binary
directive. This is an error.
.TP
.B Failed to stat file ...
Reported when t2lincks could not stat the specified file in a \.binary
directive to get the size of the image. This is an error.
.TP
.B Failed when reading from ...
Reported when t2lincks could not read the full contents of the file
given in a \.binary directive. This is an error.
.SH BUGS
No known bugs.  Please report all bugs to lincks-bugs@ida.liu.se.
Please include a description of how you can reproduce the bug and the
output of either `dbx t2lincks core' or `gdb t2lincks core' if possible.
.SH COPYRIGHT
Copyright (C) 1993, 1994 Lin Padgham, Ralph Ronnquist
.LP
The collective LINCKS programs are free software; you can redistribute 
them and/or modify them under the terms of the GNU General Public
License as published by the Free Software Foundation, version 2.
.LP
The collective LINCKS programs are distributed in the hope that they
will be useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
the GNU General Public License for more details.
.LP
You should have received a copy of the GNU General Public License along
with the LINCKS system; see the file COPYING.  If not, write to the
Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
.SH AVAILABILITY
The most recently released version of the LINCKS system is always 
available for anonymous ftp from ftp.ida.liu.se (130.236.30.131) in
the directory pub/lincks.
