/* 
 * Linkoping Intelligent Communication of Knowledge System (LINCKS)
 *      Copyright (C) 1993, 1994 Lin Padgham, Ralph Rnnquist
 *       Department of Computer and Information Sciences
 *		University of Linkoping, Sweden
 *		    581 83 Linkoping, Sweden
 *		       lincks@ida.liu.se
 *
 * These collective LINCKS programs are free software; you can 
 * redistribute them and/or modify them under the terms of the GNU
 * General Public License as published by the Free Software Foundation,
 * version 2 of the License.
 *
 * These programs are distributed in the hope that they will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the programs; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
 * MODULE NAME: 	cutoffmain.c
 *
 * SCCSINFO:		@(#)cutoffmain.c	1.10 6/6/94
 *
 * ORIGINAL AUTHOR(S):  Tomas Volavka, 1988-04-04
 *
 * MODIFICATIONS:
 *	<list mods with name and date>
 *
 * DESCRIPTION:
 *  This file contains the definition of main and the function Cutoff0
 */
/*********************************************************************
 * INCLUDES:
 *********************************************************************/
#include "config.h"	/* includes system dependent includes */

#include <time.h>
#include <netdb.h>			/* for MAXHOSTNAMELEN */
#ifndef MAXHOSTNAMELEN			/* seems like SCO have here */
#include <sys/socket.h>
#endif /* n MAXHOSTNAMELEN */

#include "xconfig.h"
#include "cutoff.h"
#include "libshared.h"

/*********************************************************************
 * EXTERNALLY-CALLABLE ROUTINES FOUND IN THIS MODULE:
 *********************************************************************/
#include "f_cutoffmain.h"

/*********************************************************************
 * EXTERNALLY-AVAILABLE	DATA FOUND IN THIS MODULE:
 *********************************************************************/
long  global_num_idx;		/* number of indexes */
int   global_indexfd;
off_t global_idxlen;		/* length of the index file */
char lockfile[MAXPATHLEN];	/* name of lockfile */

/*********************************************************************
 * EXTERNAL FUNCTIONS USED BY THIS MODULE:
 *********************************************************************/
/* libc */
#if defined(sun) || defined(__sun__)
extern time_t time P_((time_t *tloc));
#endif

#include "f_files.h"
#include "f_stage1.h"
#include "f_stage2.h"
#include "f_stage3.h"
#include "f_misc.h"

/*********************************************************************
 * EXTERNAL DATA STRUCTURES USED BY THIS MODULE:
 *********************************************************************/
/* none */

/*********************************************************************
 * LOCAL DEFINES, STRUCTS, TYPEDEFS, ETC.:
 *********************************************************************/
#ifndef MAXHOSTNAMELEN
#define MAXHOSTNAMELEN 64
#endif /* MAXHOSTNAMELEN */


/*********************************************************************
 * INTERNAL FUNCTIONS USED BY THIS MODULE:
 *********************************************************************/
static int InitSignals P_(( void ));
static void PrintTime P_(( int which ));
static void print_version P_(( void ));

/*********************************************************************
 * INTERNAL (STATIC) DATA:
 *********************************************************************/
/* none */

/*  */
/**********************************************************************
 * Function: void main(int argc, char **argv)
 *
 * Modifications:
 *      <list mods with name and date>
 */
void main(argc, argv)		/* Cutoff */
  int argc;
  char **argv;
{
  char *dbdir;
  int lockfd;
  char filename[MAXPATHLEN];
  char host[MAXHOSTNAMELEN];

  print_version();

  if (argc == 2)
    dbdir = argv[1];
  else
    dbdir = ".";

  if (configuration(dbdir) == 0)
    fatal_error(FATAL_CONFIG, dbdir, (char *)NULL);

  /* Add hander to catch "kill" to remove locks */
  if ( InitSignals() == FAIL ) 
    fatal_error(FATAL_GEN, "main", "could not set up signals");
    
  /* setup line buffering */
#ifdef HAVE_SETLINEBUF
  (void)setlinebuf(stdout);
  (void)setlinebuf(stderr);
#else
  setvbuf(stdout, NULL, _IOLBF, 0);
  setvbuf(stderr, NULL, _IOLBF, 0);
#endif 	/* n HAVE_SETLINEBUF */
  PrintTime(START);

  /* open index file and acquire exclusive lock */
  if ((global_indexfd = open(INDEXFILE, O_RDWR)) < 0) 
    fatal_error(FATAL_GEN, "main", "could not open index file");

  (void) sprintf(lockfile, "%s/%s", DBDIR, INDEXLOCK);
  
  /* this can fail under nfs with a loaded server, but ... */
  if ((lockfd = open(lockfile, O_WRONLY|O_CREAT|O_EXCL, 0644)) < 0) 
    fatal_error(FATAL_GEN, "main", 
                "Could not create lockfile.  Check if\n\
 		a monitor or cutoff is already running");

  (void)gethostname(host, MAXHOSTNAMELEN);

  (void) sprintf( filename, "Cutoff@%s:%d\n", host, (int)getpid());
  if ( write( lockfd, filename, (IOSIZE_T)strlen(filename)) <= 0) 
    fatal_error(FATAL_GEN, "main", "Failed to write to lockfile");

  if ( close(lockfd) < 0 ) 
    fatal_error(FATAL_GEN, "main", "Failed to close lockfile");

  /* compute length of the index file */
  if ((global_idxlen = LengthOfFile(global_indexfd)) < 0)
    fatal_error(FATAL_GEN, "main", "index file length unavailable.");

  if (global_idxlen == 0)
    fatal_error(FATAL_GEN, "main", "empty index file");

  if (stage1() == FAIL)
    fatal_error(FATAL_GEN, "main, stage 1", "compacting of database failed");
  else if (stage2() == FAIL)
    fatal_error(FATAL_GEN, "main, stage 2", "compacting of database failed");
  else if (stage3() == FAIL)
    fatal_error(FATAL_GEN, "main, stage 3", "compacting of database failed");
  else
    (void)printf("Compacting of database is completed.");

  PrintTime(FINISH);
 
  (void) unlink( lockfile );
}

/*  */
/**********************************************************************
 * Function: static void PrintTime(int which)
 *
 * Print current date and time.
 *
 * Modifications:
 *      <list mods with name and date>
 */
static void PrintTime(which)
  int which;
{
  struct tm *localtime();
  time_t t;

  if (which == START)
    (void)printf("Start:");

  (void)time(&t);
  (void)printf("  %s\n", asctime(localtime(&t)));

  if (which == START)
    (void)printf("=======\n");
}

/*  */
/* ARGSUSED */
/**********************************************************************
 * Function: void Error(int error, char *string)
 *
 * this has to be there for packunpack.
 * Modifications:
 *      <list mods with name and date>
 */
void Error(error, string)
  int error;
  char *string;
{
  fatal_error(FATAL_MALLOC, "in packunpack.c", string);
}

/*  */
/**********************************************************************
 * Function: void fatal_error(int error, char *function, char *message)
 *
 * Modifications:
 *      <list mods with name and date>
 */
void fatal_error(error, function, message)
  int error;
  char *function;
  char *message;
{
  (void) unlink( lockfile );
  switch(error) {
  case FATAL_OPEN:
    (void)fprintf(stderr, "%s: failed to open %s\n", function, message);
    perror("open failed because");
    break;
  case FATAL_GEN:
    (void)fprintf(stderr, "%s: %s\n", function, message);
    break;
  case FATAL_CREATE:
    (void)fprintf(stderr, "%s: unable to create file %s\n", function, message);
    perror("create failed because");
    break;
  case FATAL_IO:
    (void)fprintf(stderr, "read or write failed in %s.\n", function);
    perror("read/write failure because");
    break;
  case FATAL_CLOSE:
    (void)fprintf(stderr, "close failed in %s.\n", function);
    perror("failure because");
    break;
  case FATAL_MALLOC:
    (void)fprintf(stderr, "Failed malloc of %s in %s.\n", message, function);
    perror("failure because");
    break;
  case FATAL_LSEEK:
    (void)fprintf(stderr, "lseek failed in %s.\n", function);
    perror("failure because");
    break;
  case FATAL_STAT:
    (void)fprintf(stderr, "fstat failed in %s.\n", function);
    perror("failure because");
    break;
  case FATAL_ILLEGALPERM:
    (void)fprintf(stderr, "%s in %s.\n", message, function);
    break;
  case FATAL_CONFIG:
    (void)fprintf(stderr, "Configuration failed for dbdir %s.\n", function);
    break;
  default:
    (void)fprintf(stderr, "unknown fatal error\n");
    break;
  }
  exit(-1);
}

/*  */
/**********************************************************************
 * Function: static int InitSignals()
 *
 * Modifications:
 *      <list mods with name and date>
 */
static int InitSignals()
{
  /* Register "clean-up" signals */
  if (Signal(SIGTERM, Handler) == BADSIG ) {
    (void)fprintf(stderr, "%s: %s\n",
			"InitSignals","Could not register signal SIGTERM.");
    return(FAIL);
  }
  if (Signal(SIGHUP, Handler) == BADSIG ) {
    (void)fprintf(stderr, "%s: %s\n",
			"InitSignals","Could not register signal SIGHUP.");
    return(FAIL);
  }
  if (Signal(SIGQUIT, Handler) == BADSIG ) {
    (void)fprintf(stderr, "%s: %s\n",
			"InitSignals","Could not register signal QUIT.");
    return(FAIL);
  }
#ifdef SIGLOST
  if (Signal(SIGLOST, Handler) == BADSIG ) {
    (void)fprintf(stderr, "%s: %s\n",
			"InitSignals","Could not register signal SIGLOST.");
    return(FAIL);
  }
#endif
  return(!FAIL);
}

/*  */
/* ARGSUSED */
/**********************************************************************
 * Function: RETSIGTYPE Handler(int sig)
 * 
 * Takes care of system signals and performs appropriate actions on them
 *
 * Modifications:
 *      <list mods with name and date>
 */
RETSIGTYPE Handler(sig)
  int sig;
{
    int savederrno = errno;
    switch (sig) {
      /* Remove any file locks before exiting */
#ifdef SIGLOST
      case SIGLOST:
#endif
      case SIGTERM:
      case SIGHUP:
      case SIGQUIT:
        (void) unlink( lockfile );
	exit(0);
	break;
      }
    errno = savederrno;
}

#define VERSION "1.3"
#define DATE "1994-06-01"
#define VERSION_INFO "\n"

/*  */
/**********************************************************************
 * Function: static void print_version()
 *
 * Modifications:
 *      <list mods with name and date>
 */
static void print_version()
{
  (void)fprintf(stdout, "\tcutoff version %s (%s)\n%s", VERSION, DATE,
                VERSION_INFO);

}
