/* 
 * Linkoping Intelligent Communication of Knowledge System (LINCKS)
 *      Copyright (C) 1993, 1994 Lin Padgham, Ralph Rnnquist
 *       Department of Computer and Information Sciences
 *		University of Linkoping, Sweden
 *		    581 83 Linkoping, Sweden
 *		       lincks@ida.liu.se
 *
 * These collective LINCKS programs are free software; you can 
 * redistribute them and/or modify them under the terms of the GNU
 * General Public License as published by the Free Software Foundation,
 * version 2 of the License.
 *
 * These programs are distributed in the hope that they will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the programs; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * MODULE NAME: 	stage1.c
 *
 * SCCSINFO:		@(#)stage1.c	1.7 5/3/94
 *
 * ORIGINAL AUTHOR(S):  Tomas Volavka, 1988-04-04
 *
 * MODIFICATIONS:
 *	<list mods with name and date>
 *
 * DESCRIPTION:
 *	This file contains stage one of the cutoff process.  it used
 *	to be in cutoff0.c, but now i've moved it into its own file
 *		- dlp
 */
/*********************************************************************
 * INCLUDES:
 *********************************************************************/
#include "config.h"	/* includes system dependent includes */
#include "xconfig.h"
#include "cutoff.h"
#include "monitor.h"

/*********************************************************************
 * EXTERNALLY-CALLABLE ROUTINES FOUND IN THIS MODULE:
 *********************************************************************/
#include "f_stage1.h"

/*********************************************************************
 * EXTERNALLY-AVAILABLE	DATA FOUND IN THIS MODULE:
 *********************************************************************/
/* none */

/*********************************************************************
 * EXTERNAL FUNCTIONS USED BY THIS MODULE:
 *********************************************************************/
#include "f_cutoffmain.h"

/*********************************************************************
 * EXTERNAL DATA STRUCTURES USED BY THIS MODULE:
 *********************************************************************/
/* cutoffmain.c */
extern off_t  global_idxlen;	/* length of the index file */
extern int global_indexfd;	/* index file descriptor */
extern long global_num_idx;	/* number of indices */
extern unsigned char *flags_mem;

/*********************************************************************
 * LOCAL DEFINES, STRUCTS, TYPEDEFS, ETC.:
 *********************************************************************/
/* none */

/*********************************************************************
 * INTERNAL FUNCTIONS USED BY THIS MODULE:
 *********************************************************************/
/* none */

/*********************************************************************
 * INTERNAL (STATIC) DATA:
 *********************************************************************/
static void init_flags P_(( long num_index ));

/*  */
/**********************************************************************
 * Function: static int stage1()
 *
 * copy all data base files into archive.
 *
 * Modifications:
 *      <list mods with name and date>
 */
int stage1()
{				/* init cutoff */
#ifdef DONE_BY_HAND
  FILE *molnamesfp;
  FILE *datnamesfp;
  char fname[MAXPATHLEN];
  /* copy index file to archive */
  (void)printf("%-30s ", INDEXFILE);
  (void)fflush(stdout);
  if (CopyFile(INDEXFILE) != SUCCESS) {
    fatal_error(FATAL_GEN, "stage1", "could not copy index file.");
    return FAIL;
  }
  (void)printf("==> %s%s\n", HEADER, INDEXFILE);

  /* open molecule names file */
  if ((molnamesfp = fopen(MOLNAMES, "r")) == NULL) {
    fatal_error(FATAL_GEN, "stage1", "could not open molnames file.");
    return FAIL;
  }
  /* read molecule names file - copy each molecule file into Archive */
  while (fscanf(molnamesfp, "%s\n", fname) != EOF) {
    (void)printf("%-30s ", fname);
    (void)fflush(stdout);
    if (CopyFile(fname) != SUCCESS) {
      fatal_error(FATAL_GEN, "stage1", "could not copy molfile.");
      return FAIL;
    }
    (void)printf("==> %s%s\n", HEADER, fname);
  }

  /* close molecule names file */
  (void)fclose(molnamesfp);

  /* open data file names file */
  if ((datnamesfp = fopen(DATANAMES, "r")) == NULL) {
    fatal_error(FATAL_GEN, "stage1", "could not open datnames file.");
    return FAIL;
  }
  /* read data file names file - copy each data file into Archive */
  while (fscanf(datnamesfp, "%s\n", fname) != EOF) {
    (void)printf("%-30s ", fname);
    (void)fflush(stdout);
    if (CopyFile(fname) != SUCCESS) {
      fatal_error(FATAL_GEN, "stage1", "could not copy datfile.");
      return FAIL;
    }
    (void)printf("==> %s%s\n", HEADER, fname);
  }

  /* close data file names file */
  (void)fclose(datnamesfp);
#endif /* DONE_BY_HAND */
  global_num_idx = (long)(global_idxlen / sizeof(INDEX));
  (void)printf("------------------------------------\n");
  (void)printf("Number of nodes in index file: %ld\n", global_num_idx);
  (void)printf("------------------------------------\n");

  init_flags(global_num_idx);
  return SUCCESS;
}

/*  */
/**********************************************************************
 * Function: void init_flags(long num_index)
 *
 * This function allocates a chunk of memory which will hold the flags.
 * Each unsigned char holds the flag for one index entry.
 *
 * Modifications:
 *      <list mods with name and date>
 */
static void init_flags(num_index)
  long num_index;
{
  flags_mem = (unsigned char *)NULL;       /* just in case */
  flags_mem = (unsigned char *)malloc(
			       (ALLOC_T)(num_index * sizeof(unsigned char)));
  
  if (!flags_mem)
    fatal_error(FATAL_MALLOC, "init_flags", "flags_mem");

  /* resets all the flags to 0's */
  (void)memset((char *)flags_mem, 0, (int)(num_index * sizeof(unsigned char)));
}
