.\" 
.\" Linkoping Intelligent Communication of Knowledge System (LINCKS)
.\"      Copyright (C) 1993, 1994 Lin Padgham, Ralph Rnnquist
.\"       Department of Computer and Information Sciences
.\"		University of Linkoping, Sweden
.\"		    581 83 Linkoping, Sweden
.\"		       lincks@ida.liu.se
.\"
.\" These collective LINCKS programs are free software; you can 
.\" redistribute them and/or modify them under the terms of the GNU
.\" General Public License as published by the Free Software Foundation,
.\" version 2 of the License.
.\"
.\" These programs are distributed in the hope that they will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with the programs; if not, write to the Free Software
.\" Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
.\"
.\" lincks man page
.\" author: David Partain
.\" version:  @(#)lincks.l	1.8 5/19/94
.\"
.TH lincks l "5/19/94" IISLAB "LINCKS System"

.SH NAME
lincks - control program for LINCKS (Linkoping Intelligent Communication
of Knowledge System)
.SH SYNOPSIS
.B lincks
[
.B \-d
]
[
.B \-h \fIhostname\fR
]
[
\-k | \-r | \-s
]
.B \fIdatabase-dir\fR
.SH DESCRIPTION
\fIlincks\fR is used to send kill or restart commands
to the \fImonitor\fR, and also to start/stop the entire LINCKS system. 
.SH OPTIONS
.TP
.B \-d
Run \fIlincks\fR in debug mode.
.TP
.B \-h \fIhostname\fR
Host on which the LINCKS system is running.
.TP
.B \-k
Kill the monitor, and thereby stop the LINCKS system.
.TP
.B \-r
Restart the monitor, thereby restarting the LINCKS system.
.TP
.B \-s
Start the LINCKS system.
.TP
.B \fIdatabase-dir\fR
The directory with the database files in it.  This argument is required.
.SH FILES
.TP
.B DBDIR/.lincksrc
Database Configuration File.
.TP
.B LOGDIR
Directory with logfiles for log and error messages.  This is defined in
the configuration file DBDIR/.lincksrc.
.SH SEE ALSO
dbroot(l), dbs(l), netserv(l), monitor(l)
.SH DIAGNOSTICS
.TP
.B Configuration failed: likely bad directory
The \fIdatabase-dir\fR you gave on the command-line is not a database.
.TP
.B RPC-call failed
RPC failed to talk correctly to the monitor.  It's likely you're not on
the machine where the server software is running.
.TP
.B Starting monitor
Initiating call to \fImonitor\fR.
.SH BUGS
No known bugs.  Please report all bugs to lincks-bugs@ida.liu.se.
Please include a description of how you can reproduce the bug and the
output of either `dbx lincks core' or `gdb lincks core' if possible.
.SH COPYRIGHT
Copyright (C) 1993, 1994 Lin Padgham, Ralph Ronnquist
.LP
The collective LINCKS programs are free software; you can redistribute 
them and/or modify them under the terms of the GNU General Public
License as published by the Free Software Foundation, version 2.
.LP
The collective LINCKS programs are distributed in the hope that they
will be useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
the GNU General Public License for more details.
.LP
You should have received a copy of the GNU General Public License along
with the LINCKS system; see the file COPYING.  If not, write to the
Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
.SH AVAILABILITY
The most recently released version of the LINCKS system is always 
available for anonymous ftp from ftp.ida.liu.se (130.236.30.131) in
the directory pub/lincks.
