/*-------------------------------------------------------------------------
 *
 * indexing.h--
 *    This include provides some definitions to support indexing 
 *    on system catalogs
 *
 *
 * Copyright (c) 1994, Regents of the University of California
 *
 * indexing.h,v 1.3 1995/02/12 02:55:28 andrew Exp
 *
 *-------------------------------------------------------------------------
 */
#ifndef INDEXING_H
#define INDEXING_H

#include "utils/rel.h"

/*
 * Some definitions for indices on pg_attribute
 */
#define Num_pg_attr_indices	3
#define Num_pg_proc_indices	3
#define Num_pg_type_indices	2
#define Num_pg_class_indices	2


/*
 * Names of indices on system catalogs
 */
extern Name AttributeNameIndex;
extern Name AttributeNumIndex;
extern Name ProcedureNameIndex;
extern Name ProcedureOidIndex;
extern Name ProcedureSrcIndex;
extern Name TypeNameIndex;
extern Name TypeOidIndex;
extern Name ClassNameIndex;
extern Name ClassOidIndex;

extern char *Name_pg_attr_indices[];
extern char *Name_pg_proc_indices[];
extern char *Name_pg_type_indices[];
extern char *Name_pg_class_indices[];

extern Name IndexedCatalogNames[];

/*
 * indexing.c prototypes 
 *
 * Functions for each index to perform the necessary scan on a cache miss.
 */
extern void CatalogOpenIndices(int nIndices, char *names[], Relation idescs[]);
extern void CatalogCloseIndices(int nIndices, Relation *idescs);
extern void CatalogIndexInsert(Relation *idescs,
			       int nIndices,
			       Relation heapRelation,
			       HeapTuple heapTuple);
extern bool CatalogHasIndex(char *catName, Oid catId);

extern HeapTuple AttributeNameIndexScan(Relation heapRelation,
					Oid relid,
					char *attname);

extern HeapTuple AttributeNumIndexScan(Relation heapRelation,
				       Oid relid,
				       AttrNumber attnum);
extern HeapTuple ProcedureOidIndexScan(Relation heapRelation, Oid procId);
extern HeapTuple ProcedureNameIndexScan(Relation heapRelation,
	char *procName, int nargs, Oid *argTypes);
extern HeapTuple ProcedureSrcIndexScan(Relation heapRelation, text *procSrc);
extern HeapTuple TypeOidIndexScan(Relation heapRelation, Oid typeId);
extern HeapTuple TypeNameIndexScan(Relation heapRelation, char *typeName);
extern HeapTuple ClassNameIndexScan(Relation heapRelation, char *relName);
extern HeapTuple ClassOidIndexScan(Relation heapRelation, Oid relId);


/*
 * What follows are lines processed by genbki.sh to create the statements
 * the bootstrap parser will turn into DefineIndex commands.
 *
 * The keyword is DECLARE_INDEX every thing after that is just like in a
 * normal specification of the 'define index' POSTQUEL command.
 */
DECLARE_INDEX(pg_attnameind on pg_attribute using btree (mkoidchar16(attrelid, attname) oidchar16_ops));
DECLARE_INDEX(pg_attnumind  on pg_attribute using btree (mkoidint2(attrelid, attnum) oidint2_ops));
DECLARE_INDEX(pg_attrelidind on pg_attribute using btree (attrelid oid_ops));

DECLARE_INDEX(pg_procidind on pg_proc using btree (Oid oid_ops));
DECLARE_INDEX(pg_procnameind on pg_proc using btree (proname char16_ops));
DECLARE_INDEX(pg_procsrcind on pg_proc using btree (prosrc text_ops));

DECLARE_INDEX(pg_typeidind on pg_type using btree (Oid oid_ops));
DECLARE_INDEX(pg_typenameind on pg_type using btree (typname char16_ops));

DECLARE_INDEX(pg_classnameind on pg_class using btree (relname char16_ops));
DECLARE_INDEX(pg_classoidind on pg_class using btree (Oid oid_ops));

/* now build indices in the initialization scripts */
BUILD_INDICES

#endif /* INDEXING_H */
