/*-------------------------------------------------------------------------
 *
 * auth.h--
 *    Definitions for network authentication routines
 *
 *
 * Copyright (c) 1994, Regents of the University of California
 *
 * auth.h,v 1.1.1.1 1994/11/07 05:19:32 andrew Exp
 *
 *-------------------------------------------------------------------------
 */
#ifndef AUTH_H
#define	AUTH_H

#include "c.h"
#include "libpq/pqcomm.h"

/*----------------------------------------------------------------
 * Common routines and definitions
 *----------------------------------------------------------------
 */

/* what we call "no authentication system" */
#define	UNAUTHNAME		"unauth"

/* what a frontend uses by default */
#if !defined(KRB4) && !defined(KRB5)
#define	DEFAULT_CLIENT_AUTHSVC	UNAUTHNAME
#else /* KRB4 || KRB5 */
#define	DEFAULT_CLIENT_AUTHSVC	"kerberos"
#endif /* KRB4 || KRB5 */

extern int fe_sendauth(MsgType msgtype, Port *port, char *hostname);
extern void fe_setauthsvc(char *name);
extern MsgType fe_getauthsvc();
extern char *fe_getauthname(void);
extern int be_recvauth(MsgType msgtype, Port *port, char *username);
extern void be_setauthsvc(char *name);
extern int be_getauthsvc(MsgType msgtype);

#define	PG_KRB4_VERSION	"PGVER4.1"	/* at most KRB_SENDAUTH_VLEN chars */
#define	PG_KRB5_VERSION	"PGVER5.1"

#endif /* AUTH_H */
