/*-------------------------------------------------------------------------
 *
 * main.c--
 *    Stub main() routine for the postgres backend.
 *
 * Copyright (c) 1994, Regents of the University of California
 *
 *
 * IDENTIFICATION
 *    /usr/local/devel/pglite/cvs/src/backend/main/main.c,v 1.3 1995/05/25 17:58:19 andrew Exp
 *
 *-------------------------------------------------------------------------
 */
#include <string.h>
#include "c.h"
#include "miscadmin.h"
#include "bootstrap/bootstrap.h"	/* for BootstrapMain() */
#include "tcop/tcopprot.h"		/* for PostgresMain() */
#include "port-protos.h"		/* for init_address_fixup() */

char *DataDir;


int
main(int argc, char *argv[])
{
    int len;
#if defined(NOFIXADE) || defined(NOPRINTADE)
    /*
     * Must be first so that the bootstrap code calls it, too.
     * (Only needed on some RISC architectures.)
     */
    init_address_fixup();
#endif /* NOFIXADE || NOPRINTADE */
    
    /* kai: have one executable for postgres and postmaster, not two! */
    len = strlen(argv[0]);
    if(len >= 10 && ! strcmp(argv[0] + len - 10, "postmaster"))
        exit(PostmasterMain(argc, argv));

    /* 
     * set up DataDir here; it's used by the bootstrap and regular systems 
     */
    DataDir = GetPGData();
    if (argc > 1 && strcmp(argv[1], "-boot") == 0)
	exit(BootstrapMain(argc, argv));
    else
	exit(PostgresMain(argc, argv));
}
