/*----------------------------------------------------------------------*
** File: rel.h
** 
** 
** Project:	PQL
** =====================================================================*
** Description:	Database Engine - Interface
**
**  Author:	Bjoern Lemke
**  E-Mail:	lemke@lf.net
**
** Copyright (c) 1994 Bjoern Lemke.
**----------------------------------------------------------------------*/

/* NBBY (types.h) should divide MAXATTS and BMOFFSET */

#define MAXATTS 32
#define BMOFFSET 8

/* redefine the bitmask size */
#define FD_SETSIZE MAXATTS + BMOFFSET 

#ifdef LINUX
#include <sys/time.h>
#endif
#ifdef AIX
#include <sys/select.h>
#endif AIX
#include <sys/types.h>
#include <gdbm.h>

#define ENGNAMELEN 100
#define LOCKPATH "/tmp/"
#define BMNAME "#Bitmap#"
#define LOCKSUF ".lock"
#define CTXSUF ".ctx"

enum DataTypes {
  T_LONG,
  T_CHAR,
  T_DOUBLE,
  T_FLOAT,
  T_TEXT,
  T_ARBINT,
  T_NONE, /* identifier for none casting */
  NVAL,    /* the NULL value indicator */
  NULLMAP /* reserved type, do not use */
};

enum AType {
  PKEY,
  ORDY,
  DROP,
  SEP
};


enum Mode {
  READ,
  WRITE
};

enum FetchAction {
  FIRST,
  NEXT
};

enum FetchStat {
  ENDOFTUP,
  MORETUP
};

typedef struct Relation {
  int num_pk; /* number of primary attributes */
  int pksize; /* size of the primary key */
  int num_f; /* number of attributes */
  int attsize; /* size of the attribute field */
  int type[MAXATTS];
  char name[MAXATTS][ENGNAMELEN];
  int start[MAXATTS];
  char relname[ENGNAMELEN];
  int maxidx;
  int atype[MAXATTS]; /* type of the attribute */
  GDBM_FILE relfd; /* the file descriptor */
  int lckfd;
  char ctxfile[ENGNAMELEN];
  int mode; /* transaction mode */
  unsigned level; /* modification level */
  datum nkey; /* remember to the next key */
  int *tastats;
  int tasize;
} Relation;


typedef struct AttList {
  int num_f; /* number of attributes */
  int type[MAXATTS];
  int size[MAXATTS];
  char name[MAXATTS][ENGNAMELEN];
  void *value[MAXATTS];
} AttList;

/*********************/
/* public prototypes */
/*********************/

/* relation operations */
int eng_tst(char *relname);
int eng_init(char *path, char *relname, AttList *pkey);
int eng_extend(char *path, AttList *atts);
int eng_shrink(char *path, char *attname);
int eng_reset(char *path);

/* transaction oriented begin/end operations */
Relation *eng_begin(char *path, int mode);
int eng_commit(Relation *rel);
int eng_abort(Relation *rel);

/* tuple operations */
int eng_fetch(Relation *rel, char *pkey, char *atts, int action);
int eng_add(Relation *rel, char *pkey, char *atts);
int eng_upd(Relation *rel, char *opkey, char *pkey, char *atts);
int eng_del(Relation *rel, char *pkey);













