/*----------------------------------------------------------------------*
** File: pql_create.c
** 
** 
** Project:	PQL
** =====================================================================*
** Description:	PQL (Subset II) - table handling
**
**  Author:	Bjoern Lemke
**  E-Mail:	lemke@lf.net
**
** Copyright (c) 1994 Bjoern Lemke.
**----------------------------------------------------------------------*/

/* include this first, FD_SETSIZE must be defined */
#include "eng.h"

#include <string.h>
#include <stdio.h>
#include "pql_tree.h"

/***********************/
/* imported operations */
/***********************/
extern char *getvar(char *var);

/*********************/
/* public prototypes */
/*********************/
int exec_create(CreateOp *create);
int exec_extend(ExtendOp *extend);
int exec_shrink(ShrinkOp *shrink);

/********************/
/* global variables */
/********************/
static char tpath[NAMELEN];

/*******************/
/* public routines */
/*******************/
int exec_create(CreateOp *create)
{
  int acount=0, pcount=0;
  char *pathvar=getvar(VN_DBPATH);
  AttList pkey, atts;
  ExtList *alist;
  Aspec *aspec;

  /* set up pkey and atts */
  alist=create->extlistptr;
  pkey.num_f=0; 
  atts.num_f=0;
  while (alist != NULL) {
    aspec=alist->aspecptr;
    
    if (aspec->attrsize == 0)
      if ((aspec->attrsize=getsizoftype(aspec->attrtype)) == -1)
	return(-1);

    switch (aspec->attrkey) {
    case PKEY:
      pkey.size[pkey.num_f]=aspec->attrsize;
      strcpy(pkey.name[pkey.num_f], aspec->attrname);
      pkey.type[pkey.num_f]=aspec->attrtype;
      pkey.num_f++;
      break;
    case ORDY:
      atts.size[atts.num_f]=aspec->attrsize;
      strcpy(atts.name[atts.num_f], aspec->attrname);
      atts.type[atts.num_f]=aspec->attrtype;
      atts.num_f++;
      break;
    }
    alist=alist->next;
  }
  strcpy(tpath, pathvar);
  strcat(tpath, create->tablename);
  if (eng_init(tpath, create->tablename, &pkey) == -1) {
    fprintf(stderr, "PQL-ERROR: cannot create table %s\n", create->tablename);
    return(-1);
  }
  if (eng_extend(tpath, &atts) == -1) {
    fprintf(stderr, "PQL-ERROR: cannot extend table %s\n", create->tablename);
    return(-1);
  }  
}

int exec_extend(ExtendOp *extend)
{
  char *pathvar=getvar(VN_DBPATH);
  AttList atts;
  ExtList *alist;
  Aspec *aspec;

  /* set up pkey and atts */
  alist=extend->extlistptr;
  atts.num_f=0;
  while (alist != NULL) {
    aspec=alist->aspecptr;

    if (aspec->attrsize == 0)
      if ((aspec->attrsize=getsizoftype(aspec->attrtype)) == -1)
	return(-1);

    switch (aspec->attrkey) {
    case PKEY:
      /* the primary key cannot be extended */
      fprintf(stderr, "PQL-ERROR: primary key cannot be extended\n");
      break;
    case ORDY:
      atts.size[atts.num_f]=aspec->attrsize;
      strcpy(atts.name[atts.num_f], aspec->attrname);
      atts.type[atts.num_f]=aspec->attrtype;
      atts.num_f++;
      break;
    }
    alist=alist->next;
  }
  strcpy(tpath, pathvar);
  strcat(tpath, extend->tablename);
  if (eng_extend(tpath, &atts) == -1) {
    fprintf(stderr, "PQL-ERROR: cannot extend table %s\n", extend->tablename);
    return(-1);
  }  
}

int exec_shrink(ShrinkOp *shrink)
{
  char *pathvar=getvar(VN_DBPATH);
  ShrinkList *slist;
  
  strcpy(tpath, pathvar);
  strcat(tpath, shrink->tablename);
  
  slist=shrink->shrinklistptr;
  
  while (slist != NULL) {
    if (eng_shrink(tpath, slist->attrname) == -1) {
      fprintf(stderr, "PQL-ERROR: cannot shrink table %s\n", 
	      shrink->tablename);
      return(-1);
    }
    slist=slist->next;
  }
}

int exec_reset(char *tablename) 
{
  char *pathvar=getvar(VN_DBPATH);

  strcpy(tpath, pathvar);
  strcat(tpath, tablename);

  if (eng_reset(tpath) == -1) {
    fprintf(stderr, "PQL-ERROR: cannot perform reset\n");
    return(-1);
  } 
}

int getsizoftype(int type)
{
  switch (type) {
  case T_FLOAT:
    return(sizeof(float));
  case T_LONG:
    return(sizeof(long));
  case T_DOUBLE:
    return(sizeof(double));
  default:
    fprintf(stderr, "PQL-ERROR: cannot get size of unknown type\n");
  }
}
