#ifndef lint
static char yysccsid[] = "@(#)yaccpar	1.8 (Berkeley) 01/20/90";
#endif
#define YYBYACC 1
#line 2 "pql_parse.y"
/*----------------------------------------------------------------------*
** File: pql.y
** 
** 
** Project:	PQL
** =====================================================================*
** Description:	PQL (Subset II) - parser
**
**  Author:	Bjoern Lemke
**  E-Mail:	lemke@lf.net
**
** Copyright (c) 1994 Bjoern Lemke.
**----------------------------------------------------------------------*/

/* include this first, FD_SETSIZE must be defined */
#include "eng.h"

#include <stdlib.h>
#include <stdio.h>

#include "pql_tree.h"

/***********************/
/* imported operations */
/***********************/
void setvar(char *var, char *value);
char *getvar(char *var);
void expvar(char *var);
void showvars();
extern int get_table(QueryOp *query, char *attr,
	      char *table, char *talias, int *depth);

/********************/
/* global variables */ 
/********************/
extern char histfile[];
extern int actkey;
extern int acttype;
extern char actcomp[];
extern char actname[];
extern int actintval;
extern float actfloatval;
extern double actdoubleval;
extern char actstrval[];
extern char actvar[];

static char tpath[NAMELEN];
static char *dbpath;
static char *varval;

QueryOp *queryjob;
InsertOp *insertjob;
UpdateOp *updatejob;
DeleteOp *deletejob;
CreateOp *createjob;
ExtendOp *extendjob;
ShrinkOp *shrinkjob;

struct Selection *actselection;
struct SelCond *actselcond[MAXLEVEL];
struct FromList *actfromlist;
struct TableSpec *acttablespec;
struct GroupCond *actgroupcond;
struct OrderCond *actordercond;
struct InsertOp *actinsertop;
struct InsertList *actinsertlist;
struct UpdateOp *actupdateop;
struct SetList *actsetlist;
struct Assignment *actassignment;
struct DeleteOp *actdeleteop;
struct ExtList *actextlist;
struct ShrinkList *actshrinklist;
struct Aspec *actaspec;

/* the following global variables are critical in case of subqueries */
/* so we declare for each query level one dedicated variable */
QueryOp *actqueryjob[MAXLEVEL];
struct Condition *actcondition[MAXLEVEL];
struct Condition *saved1condition[MAXLEVEL][MAXCOND], *saved2condition[MAXLEVEL];
struct Predicate *actpredicate[MAXLEVEL];

struct ExprList *actexprlist;
struct Expr *actexpr, *saved1expr[MAXEXPR], *saved2expr;
struct AttrSpecList *actattrspeclist, *tmpattrspeclist;
struct Function *actfunction;
struct FuncArg *actfuncarg;
struct AttrSpec *actattrspec;
struct ConstantList *actconstantlist, *tmpconstantlist;
struct Literal *actliteral;

int condcount=0;
int expcount=0;
int actrule; /* remember to the current rule */
int actdepth=0; /* query depth */
int actcast;
int attnum=0; /* number of scanned attributes */
int parsephase;
int i;
ATable attable[ATABLESIZE];

#line 104 "pql_parse.y"
typedef union {
   int intval;
   double floatval;
   char *strval;
   int subtok;
} YYSTYPE;
#line 114 "y.tab.c"
#define NAME 257
#define STRING 258
#define INTNUM 259
#define FLOATNUM 260
#define DOUBLENUM 261
#define OR 262
#define AND 263
#define NOT 264
#define COMPARISON 265
#define ALL 266
#define AFUNC 267
#define ANY 268
#define AS 269
#define ASC 270
#define AVG 271
#define BTYPE 272
#define BY 273
#define CHAR 274
#define COUNT 275
#define CREATE 276
#define DELETE 277
#define DESC 278
#define DISTINCT 279
#define ENV 280
#define EXIT 281
#define EXISTS 282
#define EXTEND 283
#define FROM 284
#define FTYPE 285
#define GROUP 286
#define GET 287
#define HAVING 288
#define IN 289
#define INSERT 290
#define INT 291
#define INTO 292
#define INVOKE 293
#define IS 294
#define KEY 295
#define LIKE 296
#define LENGTH 297
#define LIST 298
#define MAX 299
#define MIN 300
#define NULLVAL 301
#define ORDER 302
#define PRINT 303
#define REAL 304
#define RESET 305
#define SELECT 306
#define SET 307
#define SHRINK 308
#define SUM 309
#define STATS 310
#define TABEGIN 311
#define TACOMMIT 312
#define TAABORT 313
#define TO 314
#define UPDATE 315
#define VALUES 316
#define WHERE 317
#define YYERRCODE 256
short yylhs[] = {                                        -1,
    0,    0,    3,    1,    5,    1,    7,    1,    9,    1,
   11,    1,   13,    1,   15,    1,    1,    1,    1,    1,
    1,    1,    1,   16,    1,    1,    1,    1,    1,   18,
   20,    2,   17,   17,   21,   21,   22,   24,   22,   26,
   29,   31,   19,   25,   34,   25,   32,   33,   33,   35,
   36,   27,   27,   28,   39,   41,   28,   40,   40,   30,
   43,   45,   30,   44,   44,   46,   48,    4,   49,   47,
   51,   47,   52,   54,   56,    6,   55,   55,   58,   53,
   53,   57,   60,   62,    8,   61,   61,   63,   65,   10,
   66,   67,   12,   69,   64,   64,   68,   70,   70,   71,
   73,   14,   74,   72,   72,   76,   37,   37,   77,   37,
   78,   37,   37,   80,   75,   81,   82,   75,   83,   84,
   75,   85,   86,   75,   87,   88,   75,   89,   75,   90,
   75,   75,   91,   23,   23,   79,   79,   92,   79,   93,
   79,   94,   79,   95,   79,   79,   97,   42,   42,   99,
  100,   96,   98,   98,   98,   98,   38,  102,   38,  101,
  101,  103,   50,   50,   59,   59,   59,   59,   59,
};
short yylen[] = {                                         2,
    2,    1,    0,    3,    0,    3,    0,    3,    0,    3,
    0,    3,    0,    3,    0,    3,    3,    3,    3,    3,
    3,    3,    2,    0,    5,    3,    2,    3,    2,    0,
    0,    5,    1,    4,    2,    1,    1,    0,    2,    0,
    0,    0,    8,    2,    0,    5,    0,    2,    1,    1,
    1,    0,    2,    0,    0,    0,    6,    0,    2,    0,
    0,    0,    6,    1,    1,    0,    0,    6,    0,    2,
    0,    3,    0,    0,    0,    8,    0,    2,    0,    4,
    1,    3,    0,    0,    6,    0,    2,    0,    0,    6,
    0,    0,    6,    0,    4,    1,    3,    2,    1,    0,
    0,    6,    0,    4,    1,    0,    2,    2,    0,    4,
    0,    4,    3,    0,    4,    0,    0,    7,    0,    0,
    8,    0,    0,    8,    0,    0,    7,    0,    4,    0,
    5,    4,    0,    4,    1,    1,    1,    0,    4,    0,
    4,    0,    4,    0,    4,    1,    0,    4,    1,    0,
    0,    6,    1,    1,    1,    1,    2,    0,    5,    0,
    1,    0,    4,    1,    1,    1,    1,    1,    1,
};
short yydefred[] = {                                      0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   27,   23,    0,    0,   29,    0,    0,   24,    0,
    0,    0,    0,    1,   30,    0,    0,    0,   73,    0,
    0,    0,   88,    0,   91,    0,  100,    0,   26,   17,
   28,   22,    0,   18,   19,   20,   21,    0,    4,   66,
    6,    0,    8,   83,   10,    0,   12,    0,   14,    0,
   16,    0,   37,    0,    0,   31,   33,   36,    0,    0,
    0,    0,    0,    0,    0,   25,    0,   35,    0,  168,
  165,  166,  167,  153,  161,  155,  154,  169,  156,   39,
  137,  136,    0,  146,    0,    0,   67,   74,   84,   89,
   92,  101,    0,   40,   32,  138,  140,  142,  144,  133,
  150,    0,    0,    0,    0,    0,    0,    0,   34,   47,
    0,    0,    0,    0,    0,    0,  158,   71,   68,    0,
    0,   75,    0,    0,   85,    0,   90,    0,   93,    0,
  102,    0,    0,    0,    0,  143,  145,  134,    0,    0,
    0,   70,    0,    0,   79,    0,    0,    0,    0,    0,
   94,  103,    0,   41,   50,    0,    0,    0,  159,   72,
    0,   82,    0,   76,    0,  108,    0,  111,  109,    0,
    0,  107,    0,   99,    0,   97,    0,    0,    0,    0,
   45,   51,   48,  152,  162,    0,   80,  113,    0,    0,
  130,    0,    0,    0,   98,   95,  104,    0,   42,   47,
    0,    0,  110,    0,    0,    0,    0,  116,    0,  125,
    0,   55,    0,   46,  163,    0,  132,  119,  122,    0,
    0,    0,  129,    0,    0,   43,  131,    0,    0,  117,
  126,   56,   61,  120,  123,    0,    0,    0,    0,    0,
    0,  118,  127,    0,   57,    0,   62,  121,  124,    0,
  147,    0,    0,   64,   65,   63,  148,
};
short yydgoto[] = {                                      13,
   14,   36,   15,   38,   16,   40,   17,   42,   18,   44,
   19,   46,   20,   48,   21,   53,   76,   58,  115,   89,
   77,   78,  100,   79,  152,  130,  174,  219,  200,  246,
  233,  153,  176,  220,  177,  203,  168,  101,  244,  265,
  258,  267,  259,  276,  272,   80,  139,  123,  140,  180,
  161,   62,  142,  124,  184,  164,  143,  185,  102,   82,
  145,  125,   66,  147,  126,   68,  127,  148,  197,  196,
   70,  151,  128,  198,  192,  169,  210,  209,  103,  229,
  240,  256,  248,  260,  249,  261,  242,  257,  231,  224,
  135,  131,  132,  133,  134,  104,  273,  105,  136,  178,
  106,  160,  221,
};
short yysindex[] = {                                   -102,
  -38,  -11, -233, -222,   -2, -197, -183, -180, -176, -170,
 -160, -153,    0, -102, -201, -184, -208, -166, -164, -169,
 -193,    0,    0,   59,   61,    0,   62,   63,    0,   64,
   76,   77,   79,    0,    0,   80, -151,   83,    0,   86,
 -133,   96,    0,   97,    0,   98,    0,   99,    0,    0,
    0,    0, -105,    0,    0,    0,    0,   25,    0,    0,
    0,  -98,    0,    0,    0,  -89,    0,  -88,    0,  -87,
    0,  115,    0,  135,  134,    0,    0,    0,   94,  -80,
 -127,  -75,  -86, -130,  -79,    0,  -28,    0,  -85,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  120,    0,  147,  -57,    0,    0,    0,    0,
    0,    0,  161,    0,    0,    0,    0,    0,    0,    0,
    0,  158, -110,  -65, -104,  -83,  -83,  -42,    0,    0,
   94,   94,   94,   94,   94,   94,    0,    0,    0, -201,
 -100,    0,  172,  -35,    0,  -40,    0,  174,    0,  175,
    0,  -95,  -36,   56,   56,    0,    0,    0,  150,  -33,
 -188,    0, -188,  -94,    0,  -35,  -35, -163,   90, -239,
    0,    0,  -35,    0,    0,  176,  -31,  184,    0,    0,
  183,    0,  -35,    0,  -65,    0,  -22,    0,    0,  188,
  -62,    0,   -6,    0,  -25,    0,  -83,  -42, -163,  -51,
    0,    0,    0,    0,    0, -163,    0,    0,  -35,  -35,
    0,  -60,  -24,  197,    0,    0,    0,  -30,    0,    0,
 -188,  -10,    0, -201, -188,  199,  218,    0,   94,    0,
   94,    0,  -21,    0,    0,  219,    0,    0,    0, -201,
  150, -201,    0,  -65,   13,    0,    0, -201, -201,    0,
    0,    0,    0,    0,    0,  248,  262,   17,  -65,  269,
  270,    0,    0,  -35,    0,  271,    0,    0,    0, -163,
    0, -210,  -65,    0,    0,    0,    0,
};
short yyrindex[] = {                                   -181,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    1,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, -111,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, -111,    0,    0,    0,   57,    0,
    0,    0,    0,    0,    0,    0, -111,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    4,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  -32,    7,   57,  115,    0,    0,    0,    0,    0,
   57,   57,   57,   57,   57,   57,    0,    0,    0,    0,
    0,    0,  -53, -128,    0,    0,    0,  258,    0,  259,
    0,   -1,    0,  -15,   10,    0,    0,    0,  278,    0,
    0,    0,    0,  261,    0, -128, -128,  263,   57,    0,
    0,    0, -128,    0,    0,  -37,  -41,    0,    0,    0,
  264,    0, -128,    0,   57,    0,    0,    0,    0,    0,
   37,    0,    0,    0,    0,    0,    0,    0,    6,  -39,
    0,    0,    0,    0,    0,  265,    0,    0, -128, -128,
    0,    0,   70,   75,    0,    0,    0,    0,    0,    0,
    0,   -7,    0,    0,    0,    0,    0,    0,   57,    0,
   57,    0,   -3,    0,    0,    0,    0,    0,    0,    0,
   35,    0,    0,   57,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  -34,   57,    0,
    0,    0,    0, -128,    0, -195,    0,    0,    0,   -9,
    0,    0,   57,    0,    0,    0,    0,
};
short yygindex[] = {                                    311,
    0, -132,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  251,  268, -112,    0,  119,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, -124, -107,    0,    0,
    0,   67,    0,    0,    0,    0,    0,    0,    0,  123,
    0,    0,  160,    0,    0,    0,    0,    0,  -97,    0,
    0,    0,    0,  -96,    0,    0,    0,    0,    0,    0,
    0,  159,    0,    0,    0,    0,    0,    0,  -43,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,
};
#define YYTABLESIZE 403
short yytable[] = {                                      49,
    2,   54,   49,   44,  167,   81,   58,  162,  157,  157,
  157,  157,  157,   73,  157,  228,  141,   49,  208,   54,
   22,   44,  158,   24,   58,  139,  157,  139,  139,  139,
  149,   59,  194,  112,   25,  118,  116,   60,  117,   52,
  119,  186,  187,  139,  135,  195,   53,   23,  199,   59,
  141,  112,  141,  141,  141,   60,   26,   52,  206,  274,
   27,  191,  135,  181,   53,  182,   73,  275,  141,   90,
   91,   92,   93,   28,  149,  115,   29,  141,  137,  137,
   30,  137,  149,  137,  222,  223,   31,  154,  155,  156,
  157,  236,  159,  115,   11,    9,   32,  118,  188,  189,
  216,   13,  119,   33,   35,   37,   39,  250,    5,  251,
   41,   43,   98,   45,   47,  254,  255,   49,  243,   50,
   51,   52,   54,  181,    3,  193,   15,  237,  106,  106,
  106,  106,  106,    7,   55,   56,  252,   57,   59,  270,
   60,   61,  106,  106,   63,   38,   38,   38,   38,   38,
   64,  266,   72,  106,   65,   67,   69,   71,   81,   38,
   38,  118,  116,  120,  117,  266,  119,   83,   84,   85,
  106,  106,  106,   86,   87,   73,  107,    1,    2,  108,
  106,  109,  110,  111,    3,  241,  121,   38,   38,   38,
    4,  118,  116,  112,  117,    5,  119,   38,  114,  122,
    6,  129,    7,  137,    8,  138,   95,    9,   10,   11,
   12,  146,  144,  163,  150,  165,  170,  171,  172,  201,
  175,  173,  183,  179,  204,  202,  205,  211,  166,  157,
  157,  212,  157,  215,  218,  225,  230,  157,  238,  188,
  189,  226,  232,  227,   49,  157,  139,  139,   44,  139,
   75,  157,  189,  157,  112,  157,  157,  239,  213,  247,
   49,  157,   54,   81,   44,  135,  135,   58,  139,  157,
  139,  141,  141,  139,  141,   49,   11,    9,  112,   44,
  245,  157,  214,   13,   52,  253,  139,  135,  262,  135,
    5,   53,   59,  141,  112,  141,  115,  115,  141,   74,
   52,  137,  263,   75,  264,  135,    3,   53,   15,  268,
  269,  141,   69,  160,  271,    7,   96,  105,  151,   77,
  115,   87,  164,   78,   34,  137,  114,  114,  114,  114,
  114,  128,  128,  128,  128,  128,  115,  113,  234,  277,
  114,  114,   88,  235,  207,  128,  128,   90,   91,   92,
   93,   90,   91,   92,   93,    0,  217,    0,    0,    0,
   94,   95,    0,    0,   94,   95,    0,    0,  114,  114,
  114,  190,    0,  128,  128,  128,    0,    0,  114,    0,
    0,    0,    0,  128,    0,    0,    0,    0,   96,   97,
   98,    0,   96,   97,   98,    0,    0,    0,   99,    0,
    0,    0,   99,
};
short yycheck[] = {                                      41,
    0,   41,   44,   41,   40,   59,   41,  140,   41,   42,
   43,   44,   45,   42,   47,   40,  124,   59,   41,   59,
   59,   59,  135,  257,   59,   41,   59,   43,   44,   45,
  127,   41,  272,   41,  257,   42,   43,   41,   45,   41,
   47,  166,  167,   59,   41,  285,   41,   59,  173,   59,
   41,   59,   43,   44,   45,   59,   59,   59,  183,  270,
  258,  169,   59,  161,   59,  163,   42,  278,   59,  258,
  259,  260,  261,  257,  270,   41,  257,  185,   42,   43,
  257,   45,  278,   47,  209,  210,  257,  131,  132,  133,
  134,  224,  136,   59,  276,  277,  257,   42,  262,  263,
  197,  283,   47,  257,  306,  290,  315,  240,  290,  242,
  277,  276,  301,  283,  308,  248,  249,   59,  231,   59,
   59,   59,   59,  221,  306,  169,  308,  225,  257,  258,
  259,  260,  261,  315,   59,   59,  244,   59,   59,  264,
  292,   59,  271,  272,   59,  257,  258,  259,  260,  261,
  284,  259,  258,  282,   59,   59,   59,   59,  257,  271,
  272,   42,   43,   44,   45,  273,   47,  257,  257,  257,
  299,  300,  301,   59,   40,   42,  257,  280,  281,  307,
  309,  257,  269,  314,  287,  229,   40,  299,  300,  301,
  293,   42,   43,  273,   45,  298,   47,  309,  284,  257,
  303,   41,  305,   46,  307,  316,  272,  310,  311,  312,
  313,  295,  317,  314,  257,   44,  257,   44,   44,   44,
  257,  317,  317,  257,   41,  257,   44,   40,  264,  262,
  263,  294,  265,  259,  286,  296,   40,  270,   40,  262,
  263,  266,  273,  268,  286,  278,  262,  263,  286,  265,
  279,  284,  263,  286,  262,  288,  289,   40,  265,   41,
  302,  294,  302,  317,  302,  262,  263,  302,  284,  302,
  286,  262,  263,  289,  265,  317,  276,  277,  286,  317,
  302,  314,  289,  283,  286,  273,  302,  284,   41,  286,
  290,  286,  302,  284,  302,  286,  262,  263,  289,  275,
  302,  265,   41,  279,  288,  302,  306,  302,  308,   41,
   41,  302,  306,  257,   44,  315,   59,   59,   41,   59,
  286,   59,   59,   59,   14,  289,  257,  258,  259,  260,
  261,  257,  258,  259,  260,  261,  302,   87,  220,  273,
  271,  272,   75,  221,  185,  271,  272,  258,  259,  260,
  261,  258,  259,  260,  261,   -1,  198,   -1,   -1,   -1,
  271,  272,   -1,   -1,  271,  272,   -1,   -1,  299,  300,
  301,  282,   -1,  299,  300,  301,   -1,   -1,  309,   -1,
   -1,   -1,   -1,  309,   -1,   -1,   -1,   -1,  299,  300,
  301,   -1,  299,  300,  301,   -1,   -1,   -1,  309,   -1,
   -1,   -1,  309,
};
#define YYFINAL 13
#ifndef YYDEBUG
#define YYDEBUG 0
#endif
#define YYMAXTOKEN 317
#if YYDEBUG
char *yyname[] = {
"end-of-file",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,"'('","')'","'*'","'+'","','","'-'","'.'","'/'",0,0,0,0,0,0,0,0,0,0,
0,"';'",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,"NAME","STRING","INTNUM","FLOATNUM","DOUBLENUM","OR","AND","NOT","COMPARISON",
"ALL","AFUNC","ANY","AS","ASC","AVG","BTYPE","BY","CHAR","COUNT","CREATE",
"DELETE","DESC","DISTINCT","ENV","EXIT","EXISTS","EXTEND","FROM","FTYPE",
"GROUP","GET","HAVING","IN","INSERT","INT","INTO","INVOKE","IS","KEY","LIKE",
"LENGTH","LIST","MAX","MIN","NULLVAL","ORDER","PRINT","REAL","RESET","SELECT",
"SET","SHRINK","SUM","STATS","TABEGIN","TACOMMIT","TAABORT","TO","UPDATE",
"VALUES","WHERE",
};
char *yyrule[] = {
"$accept : pql",
"pql : pql_stat pql",
"pql : pql_stat",
"$$1 :",
"pql_stat : $$1 pql_query ';'",
"$$2 :",
"pql_stat : $$2 pql_insert ';'",
"$$3 :",
"pql_stat : $$3 pql_update ';'",
"$$4 :",
"pql_stat : $$4 pql_delete ';'",
"$$5 :",
"pql_stat : $$5 pql_create ';'",
"$$6 :",
"pql_stat : $$6 pql_extend ';'",
"$$7 :",
"pql_stat : $$7 pql_shrink ';'",
"pql_stat : INVOKE NAME ';'",
"pql_stat : STATS NAME ';'",
"pql_stat : TABEGIN NAME ';'",
"pql_stat : TACOMMIT NAME ';'",
"pql_stat : TAABORT NAME ';'",
"pql_stat : RESET NAME ';'",
"pql_stat : EXIT ';'",
"$$8 :",
"pql_stat : SET NAME $$8 STRING ';'",
"pql_stat : GET NAME ';'",
"pql_stat : ENV ';'",
"pql_stat : PRINT STRING ';'",
"pql_stat : LIST ';'",
"$$9 :",
"$$10 :",
"pql_query : SELECT $$9 selframe $$10 selcond",
"selframe : distinct_select",
"selframe : COUNT '(' distinct_select ')'",
"distinct_select : DISTINCT selection",
"distinct_select : selection",
"selection : '*'",
"$$11 :",
"selection : $$11 exprlist",
"$$12 :",
"$$13 :",
"$$14 :",
"selcond : FROM $$12 fromlist wherecond $$13 groupcond $$14 ordercond",
"fromlist : ms1 tablespec",
"$$15 :",
"fromlist : ms1 tablespec ',' $$15 fromlist",
"ms1 :",
"tablespec : tablename tablealias",
"tablespec : tablename",
"tablename : NAME",
"tablealias : NAME",
"wherecond :",
"wherecond : WHERE condition",
"groupcond :",
"$$16 :",
"$$17 :",
"groupcond : GROUP BY $$16 attrspec $$17 havingcond",
"havingcond :",
"havingcond : HAVING condition",
"ordercond :",
"$$18 :",
"$$19 :",
"ordercond : ORDER BY $$18 attrspeclist $$19 ordering",
"ordering : ASC",
"ordering : DESC",
"$$20 :",
"$$21 :",
"pql_insert : INSERT INTO $$20 NAME $$21 insertlist",
"$$22 :",
"insertlist : $$22 pql_query",
"$$23 :",
"insertlist : VALUES $$23 constantlist",
"$$24 :",
"$$25 :",
"$$26 :",
"pql_update : UPDATE $$24 NAME SET $$25 setlist $$26 setcondition",
"setcondition :",
"setcondition : WHERE condition",
"$$27 :",
"setlist : assignment ',' $$27 setlist",
"setlist : assignment",
"assignment : attrspec TO literal",
"$$28 :",
"$$29 :",
"pql_delete : DELETE FROM $$28 NAME $$29 deletecond",
"deletecond :",
"deletecond : WHERE condition",
"$$30 :",
"$$31 :",
"pql_create : CREATE $$30 NAME AS $$31 extlist",
"$$32 :",
"$$33 :",
"pql_extend : EXTEND $$32 NAME TO $$33 extlist",
"$$34 :",
"extlist : aspec ',' $$34 extlist",
"extlist : aspec",
"aspec : KEY NAME typespec",
"typespec : FTYPE INTNUM",
"typespec : BTYPE",
"$$35 :",
"$$36 :",
"pql_shrink : SHRINK $$35 NAME BY $$36 shrinklist",
"$$37 :",
"shrinklist : NAME ',' $$37 shrinklist",
"shrinklist : NAME",
"$$38 :",
"condition : $$38 predicate",
"condition : NOT condition",
"$$39 :",
"condition : condition AND $$39 condition",
"$$40 :",
"condition : condition OR $$40 condition",
"condition : '(' condition ')'",
"$$41 :",
"predicate : expr COMPARISON $$41 expr",
"$$42 :",
"$$43 :",
"predicate : expr COMPARISON '(' $$42 pql_query $$43 ')'",
"$$44 :",
"$$45 :",
"predicate : expr COMPARISON ALL '(' $$44 pql_query $$45 ')'",
"$$46 :",
"$$47 :",
"predicate : expr COMPARISON ANY '(' $$46 pql_query $$47 ')'",
"$$48 :",
"$$49 :",
"predicate : expr IN '(' $$48 pql_query $$49 ')'",
"$$50 :",
"predicate : expr IN $$50 exprlist",
"$$51 :",
"predicate : EXISTS '(' $$51 pql_query ')'",
"predicate : attrspec IS LIKE literal",
"$$52 :",
"exprlist : expr ',' $$52 exprlist",
"exprlist : expr",
"expr : literal",
"expr : attrspec",
"$$53 :",
"expr : expr '+' $$53 expr",
"$$54 :",
"expr : expr '-' $$54 expr",
"$$55 :",
"expr : expr '*' $$55 expr",
"$$56 :",
"expr : expr '/' $$56 expr",
"expr : function",
"$$57 :",
"attrspeclist : attrspec ',' $$57 attrspeclist",
"attrspeclist : attrspec",
"$$58 :",
"$$59 :",
"function : functype '(' $$58 expr $$59 ')'",
"functype : AVG",
"functype : MIN",
"functype : MAX",
"functype : SUM",
"attrspec : typecast NAME",
"$$60 :",
"attrspec : typecast NAME '.' $$60 NAME",
"typecast :",
"typecast : BTYPE",
"$$61 :",
"constantlist : literal ',' $$61 constantlist",
"constantlist : literal",
"literal : INTNUM",
"literal : FLOATNUM",
"literal : DOUBLENUM",
"literal : STRING",
"literal : NULLVAL",
};
#endif
#define yyclearin (yychar=(-1))
#define yyerrok (yyerrflag=0)
#ifdef YYSTACKSIZE
#ifndef YYMAXDEPTH
#define YYMAXDEPTH YYSTACKSIZE
#endif
#else
#ifdef YYMAXDEPTH
#define YYSTACKSIZE YYMAXDEPTH
#else
#define YYSTACKSIZE 500
#define YYMAXDEPTH 500
#endif
#endif
int yydebug;
int yynerrs;
int yyerrflag;
int yychar;
short *yyssp;
YYSTYPE *yyvsp;
YYSTYPE yyval;
YYSTYPE yylval;
short yyss[YYSTACKSIZE];
YYSTYPE yyvs[YYSTACKSIZE];
#define yystacksize YYSTACKSIZE
#line 1115 "pql_parse.y"

/* evaluate comparison */

int getcompid(char *compstr)
{ 
  if (compstr[0] == '=' && compstr[1] == '\0')
    return EQU;
  else if (compstr[0] == '<') {
    if (compstr[1] == '>')
      return NEQUAL;
    else if (compstr[1] == '=')
      return LEQUAL;
    else if (compstr[1] == '\0')
      return LESS;
    else return INVALID;
  }
  else if (compstr[0] == '>') {
    if (compstr[1] == '=')
      return MEQUAL;
    else if (compstr[1] == '\0')
      return MORE;
    else return INVALID;
  }
  else return INVALID;
}


void pql_cleanup() 
{
  /* cleanup after a pql operation */
  attnum=0;
  actdepth=0;
}
	
#line 673 "y.tab.c"
#define YYABORT goto yyabort
#define YYACCEPT goto yyaccept
#define YYERROR goto yyerrlab
int
yyparse()
{
    register int yym, yyn, yystate;
#if YYDEBUG
    register char *yys;
    extern char *getenv();

    if (yys = getenv("YYDEBUG"))
    {
        yyn = *yys;
        if (yyn >= '0' && yyn <= '9')
            yydebug = yyn - '0';
    }
#endif

    yynerrs = 0;
    yyerrflag = 0;
    yychar = (-1);

    yyssp = yyss;
    yyvsp = yyvs;
    *yyssp = yystate = 0;

yyloop:
    if (yyn = yydefred[yystate]) goto yyreduce;
    if (yychar < 0)
    {
        if ((yychar = yylex()) < 0) yychar = 0;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("yydebug: state %d, reading %d (%s)\n", yystate,
                    yychar, yys);
        }
#endif
    }
    if ((yyn = yysindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
#if YYDEBUG
        if (yydebug)
            printf("yydebug: state %d, shifting to state %d\n",
                    yystate, yytable[yyn]);
#endif
        if (yyssp >= yyss + yystacksize - 1)
        {
            goto yyoverflow;
        }
        *++yyssp = yystate = yytable[yyn];
        *++yyvsp = yylval;
        yychar = (-1);
        if (yyerrflag > 0)  --yyerrflag;
        goto yyloop;
    }
    if ((yyn = yyrindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
        yyn = yytable[yyn];
        goto yyreduce;
    }
    if (yyerrflag) goto yyinrecovery;
#ifdef lint
    goto yynewerror;
#endif
yynewerror:
    yyerror("syntax error");
#ifdef lint
    goto yyerrlab;
#endif
yyerrlab:
    ++yynerrs;
yyinrecovery:
    if (yyerrflag < 3)
    {
        yyerrflag = 3;
        for (;;)
        {
            if ((yyn = yysindex[*yyssp]) && (yyn += YYERRCODE) >= 0 &&
                    yyn <= YYTABLESIZE && yycheck[yyn] == YYERRCODE)
            {
#if YYDEBUG
                if (yydebug)
                    printf("yydebug: state %d, error recovery shifting\
 to state %d\n", *yyssp, yytable[yyn]);
#endif
                if (yyssp >= yyss + yystacksize - 1)
                {
                    goto yyoverflow;
                }
                *++yyssp = yystate = yytable[yyn];
                *++yyvsp = yylval;
                goto yyloop;
            }
            else
            {
#if YYDEBUG
                if (yydebug)
                    printf("yydebug: error recovery discarding state %d\n",
                            *yyssp);
#endif
                if (yyssp <= yyss) goto yyabort;
                --yyssp;
                --yyvsp;
            }
        }
    }
    else
    {
        if (yychar == 0) goto yyabort;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("yydebug: state %d, error recovery discards token %d (%s)\n",
                    yystate, yychar, yys);
        }
#endif
        yychar = (-1);
        goto yyloop;
    }
yyreduce:
#if YYDEBUG
    if (yydebug)
        printf("yydebug: state %d, reducing by rule %d (%s)\n",
                yystate, yyn, yyrule[yyn]);
#endif
    yym = yylen[yyn];
    yyval = yyvsp[1-yym];
    switch (yyn)
    {
case 3:
#line 151 "pql_parse.y"
{ queryjob=NULL; }
break;
case 4:
#line 152 "pql_parse.y"
{ 
  fprintf(stderr,"Executing PQL query ...\n");
  if (exec_query(queryjob) != -1) 
    fprintf(stderr, "PQL query job completed.\n");
  clean_query(queryjob);
  attnum=0; actdepth=0;						}
break;
case 5:
#line 158 "pql_parse.y"
{ insertjob=NULL; }
break;
case 6:
#line 159 "pql_parse.y"
{   
  fprintf(stderr,"Executing PQL insert ...\n");
  if (exec_insert(insertjob) != -1)  {
    fprintf(stderr, "PQL insert job completed.\n");
    clean_insert(insertjob); 		
  } else {
    clean_insert(insertjob);
    return(1);                                                   
  }                                                              }
break;
case 7:
#line 168 "pql_parse.y"
{ updatejob=NULL; }
break;
case 8:
#line 169 "pql_parse.y"
{ 
  fprintf(stderr, "Executing PQL update ...\n");
  if (exec_update(updatejob) != -1) {
    fprintf(stderr, "PQL update job completed.\n");
    clean_update(updatejob);	
  } else {
    clean_update(updatejob);
    return(1);                                                   
  }                                                              }
break;
case 9:
#line 178 "pql_parse.y"
{ deletejob=NULL; }
break;
case 10:
#line 179 "pql_parse.y"
{ 
  fprintf(stderr, "Executing PQL delete ...\n");
  if (exec_delete(deletejob) != -1) {
    fprintf(stderr, "PQL delete job completed.\n");
    clean_delete(deletejob);		
  } else {
    clean_delete(deletejob);
    return(1);
  }                                                              }
break;
case 11:
#line 188 "pql_parse.y"
{ createjob=NULL; }
break;
case 12:
#line 189 "pql_parse.y"
{ 
  fprintf(stderr, "Executing PQL create ...\n");
  if (exec_create(createjob) != -1)
    fprintf(stderr, "PQL create job completed.\n");
  clean_create(createjob);					}
break;
case 13:
#line 194 "pql_parse.y"
{ extendjob=NULL; }
break;
case 14:
#line 195 "pql_parse.y"
{ 
  fprintf(stderr, "Executing PQL extend ...\n");
  if (exec_extend(extendjob) != -1)
    fprintf(stderr, "PQL extend job completed.\n");
  clean_extend(extendjob);					}
break;
case 15:
#line 200 "pql_parse.y"
{ shrinkjob=NULL; }
break;
case 16:
#line 201 "pql_parse.y"
{ 
  fprintf(stderr, "Executing PQL shrink ...\n");
  if (exec_shrink(shrinkjob) != -1)
    fprintf(stderr, "PQL shrink job completed.\n");
  clean_shrink(shrinkjob);					}
break;
case 17:
#line 207 "pql_parse.y"
{ if (exec_invoke(actname) != -1) 
    fprintf(stderr, "PQL invoke job completed.\n"); 		}
break;
case 18:
#line 210 "pql_parse.y"
{ if (exec_stats(actname) != -1) 
    fprintf(stderr, "PQL stats job completed.\n"); 		}
break;
case 19:
#line 213 "pql_parse.y"
{ if (exec_begin(actname) != -1)
    fprintf(stderr, "PQL transaction started on %s\n", actname);   }
break;
case 20:
#line 216 "pql_parse.y"
{ if (exec_commit(actname) != -1)
    fprintf(stderr, "PQL transaction commited on %s\n", actname);  }
break;
case 21:
#line 219 "pql_parse.y"
{ if (exec_abort(actname) != -1)
    fprintf(stderr, "PQL transaction aborted on %s\n", actname);  }
break;
case 22:
#line 222 "pql_parse.y"
{ if (exec_reset(actname) != -1)
    fprintf(stderr, "PQL reset completed on %s\n", actname);       }
break;
case 23:
#line 225 "pql_parse.y"
{ if (write_history(histfile) != 0)
    perror("PQL-ERROR:");

  if (history_truncate_file(histfile, HISTLINES) != NULL)
    perror("PQL-ERROR:");

  fprintf(stderr, "PQL terminated.\n"); 
  exit(0); /* just in this case we force to leave */		}
break;
case 24:
#line 234 "pql_parse.y"
{ strcpy(actvar, actname) ; }
break;
case 25:
#line 236 "pql_parse.y"
{ setvar(actvar, actstrval);    				}
break;
case 26:
#line 238 "pql_parse.y"
{ if ((varval = getvar(actname)) != NULL)
    printf("%s is %s\n", actname, varval);			}
break;
case 27:
#line 241 "pql_parse.y"
{ showvars();  							}
break;
case 28:
#line 243 "pql_parse.y"
{ expvar(actstrval);
  printf("%s", actstrval);                                      }
break;
case 29:
#line 246 "pql_parse.y"
{ listtables();                                                 }
break;
case 30:
#line 253 "pql_parse.y"
{ if ((actqueryjob[actdepth]=(QueryOp*)malloc(sizeof(QueryOp))) == NULL) {
	perror("malloc");	
	exit(1);
  }
  actqueryjob[actdepth]->selectmode = NOSELMODE;
  actqueryjob[actdepth]->depth=actdepth;
  actqueryjob[actdepth]->sqbuf=NULL;

  /* set up root job */
  if (actdepth == 0) {
        queryjob=actqueryjob[actdepth];
	queryjob->prev=NULL;
  } else {
        actqueryjob[actdepth]->prev = actqueryjob[actdepth-1];
  }								
  if ((actqueryjob[actdepth]->selectionptr = 
  (Selection*)malloc(sizeof(Selection))) == NULL) {
	perror("malloc");
	exit(1);
  }
  actselection = actqueryjob[actdepth]->selectionptr; 	
  parsephase = SELECTION;					}
break;
case 31:
#line 275 "pql_parse.y"
{ if ((actqueryjob[actdepth]->selcondptr = 
  (SelCond*)malloc(sizeof(SelCond))) == NULL) {
	perror("malloc");
	exit(1);
  }
  actselcond[actdepth] = actqueryjob[actdepth]->selcondptr; 		
  parsephase = CONDITION;					}
break;
case 33:
#line 286 "pql_parse.y"
{ actqueryjob[actdepth]->countit=0;                             }
break;
case 34:
#line 288 "pql_parse.y"
{ actqueryjob[actdepth]->countit=1;                             }
break;
case 35:
#line 294 "pql_parse.y"
{ actqueryjob[actdepth]->distinct = 1; 				}
break;
case 36:
#line 296 "pql_parse.y"
{ actqueryjob[actdepth]->distinct = 0; 				}
break;
case 37:
#line 301 "pql_parse.y"
{ actselection->exprlistptr = NULL;
  actqueryjob[actdepth]->selectmode = STAR; 			}
break;
case 38:
#line 304 "pql_parse.y"
{ if ((actselection->exprlistptr = 
  (ExprList*)malloc(sizeof(ExprList))) == NULL) {
	perror("malloc");
	exit(1);
  }
  actexprlist = actselection->exprlistptr;		
  actqueryjob[actdepth]->selectmode = PROJECTION;		}
break;
case 40:
#line 316 "pql_parse.y"
{ if ((actselcond[actdepth]->fromlistptr = 
  (FromList*)malloc(sizeof(FromList))) == NULL) {
	perror("malloc");
	exit(1);
  }
  actfromlist = actselcond[actdepth]->fromlistptr;		}
break;
case 41:
#line 323 "pql_parse.y"
{ actselcond[actdepth]->wherecondptr=actcondition[actdepth];	}
break;
case 42:
#line 324 "pql_parse.y"
{ actselcond[actdepth]->groupcondptr=actgroupcond;		}
break;
case 43:
#line 325 "pql_parse.y"
{ actselcond[actdepth]->ordercondptr=actordercond;		}
break;
case 44:
#line 333 "pql_parse.y"
{ FromList *flcheck;

  /* check for ambigious tables */
  for (flcheck=actselcond[actdepth]->fromlistptr; 
       flcheck != actfromlist; 
       flcheck = flcheck->next) {
    if (!strcmp(actfromlist->tablespecptr->tablename, 
		flcheck->tablespecptr->tablename)
	&& !strcmp(actfromlist->tablespecptr->tablealias, 
		   flcheck->tablespecptr->tablealias)) {
      fprintf(stderr, "PQL-ERROR: ambigious table specification\n");
      return;
    }
  }                                                             }
break;
case 45:
#line 348 "pql_parse.y"
{ if ((actfromlist->next=
       (FromList*)malloc(sizeof(FromList))) == NULL) {
     perror("malloc");
     exit(1);
  }
  actfromlist = actfromlist->next;                              }
break;
case 47:
#line 357 "pql_parse.y"
{ if ((actfromlist->tablespecptr=
  (TableSpec*)malloc(sizeof(TableSpec))) == NULL) {
	perror("malloc");
	exit(1);
  }
  acttablespec=actfromlist->tablespecptr;		
  actfromlist->next=NULL;					}
break;
case 50:
#line 371 "pql_parse.y"
{     
  dbpath = getvar(VN_DBPATH);
  strcpy(tpath, dbpath);
  strcat(tpath, actname);
  if (!eng_tst(tpath)) {
    strcpy(acttablespec->tablename, actname);
    /* the default alias value is the name of the table */
    strcpy(acttablespec->tablealias, actname);
  } else {
      fprintf(stderr, "PQL-ERROR: cannot access relation %s\n",actname);
      return;
    } 								}
break;
case 51:
#line 386 "pql_parse.y"
{ 
  strcpy(acttablespec->tablealias, actname); 			}
break;
case 52:
#line 392 "pql_parse.y"
{ actcondition[actdepth] = NULL; }
break;
case 54:
#line 398 "pql_parse.y"
{ actgroupcond = NULL; }
break;
case 55:
#line 400 "pql_parse.y"
{ actqueryjob[actdepth]->selectmode = GROUPING;
  if ((actgroupcond = 	
  (GroupCond*)malloc(sizeof(GroupCond))) == NULL) {
	perror("malloc");
	exit(1);
      } 							}
break;
case 56:
#line 406 "pql_parse.y"
{ actgroupcond->attrspecptr=actattrspec;			}
break;
case 57:
#line 407 "pql_parse.y"
{ actgroupcond->havingcondptr=actcondition[actdepth];		}
break;
case 58:
#line 410 "pql_parse.y"
{ actcondition[actdepth] = NULL; }
break;
case 60:
#line 416 "pql_parse.y"
{ actordercond = NULL; }
break;
case 61:
#line 418 "pql_parse.y"
{ if ((actordercond = 
  (OrderCond*)malloc(sizeof(OrderCond))) == NULL) {
	perror("malloc");
	exit(1);
  }
  actattrspeclist = NULL;					}
break;
case 62:
#line 424 "pql_parse.y"
{ actordercond->attrspeclistptr = actattrspeclist;		}
break;
case 64:
#line 428 "pql_parse.y"
{ actordercond->order = ASC; }
break;
case 65:
#line 431 "pql_parse.y"
{ actordercond->order = DESC; }
break;
case 66:
#line 437 "pql_parse.y"
{ if ((insertjob=(InsertOp*)malloc(sizeof(InsertOp))) == NULL) {
	perror("malloc");	
	exit(1);

  }								}
break;
case 67:
#line 442 "pql_parse.y"
{ strcpy(insertjob->tablename, actname);			}
break;
case 68:
#line 443 "pql_parse.y"
{ insertjob->insertlistptr = actinsertlist;			}
break;
case 69:
#line 446 "pql_parse.y"
{ actdepth++; }
break;
case 70:
#line 447 "pql_parse.y"
{ actdepth--;
  if ((actinsertlist=
  (InsertList*)malloc(sizeof(InsertList))) == NULL) {
	perror("malloc");
	exit(1);
  }
  actinsertlist->queryopptr = actqueryjob[actdepth+1];
  actinsertlist->constantlistptr = NULL;
  actinsertlist->rule = 1;					}
break;
case 71:
#line 457 "pql_parse.y"
{ if ((actinsertlist=
  (InsertList*)malloc(sizeof(InsertList))) == NULL) {
	perror("malloc");
	exit(1);
  } 
  actinsertlist->queryopptr = NULL;
  actinsertlist->rule = 2;
  actconstantlist = NULL;					}
break;
case 72:
#line 465 "pql_parse.y"
{ actinsertlist->constantlistptr = actconstantlist;		}
break;
case 73:
#line 471 "pql_parse.y"
{ if ((updatejob=
  (UpdateOp*)malloc(sizeof(UpdateOp))) == NULL) {
	perror("mallloc");
	exit(1);
  }								}
break;
case 74:
#line 476 "pql_parse.y"
{ strcpy(updatejob->tablename, actname);		
  if ((updatejob->setlistptr=
  (SetList*)malloc(sizeof(SetList))) == NULL) {
	perror("malloc");
	exit(1);
  } 
  actsetlist = updatejob->setlistptr;				
  parsephase = ASSIGNMENT;					}
break;
case 75:
#line 484 "pql_parse.y"
{ parsephase = UPDATECOND;                                      }
break;
case 77:
#line 488 "pql_parse.y"
{  updatejob->conditionptr = NULL;				}
break;
case 78:
#line 491 "pql_parse.y"
{  updatejob->conditionptr = actcondition[actdepth];		}
break;
case 79:
#line 495 "pql_parse.y"
{ actsetlist->assignmentptr=actassignment;
  if ((actsetlist->next=
  (SetList*)malloc(sizeof(SetList))) == NULL) {
	perror("malloc");
	exit(1);
  }
  actsetlist=actsetlist->next;					}
break;
case 81:
#line 504 "pql_parse.y"
{ actsetlist->assignmentptr = actassignment;
  actsetlist->next = NULL;					}
break;
case 82:
#line 509 "pql_parse.y"
{ if ((actassignment=
  (Assignment*)malloc(sizeof(Assignment))) == NULL) {
	perror("malloc");
	exit(1);
  }
  actassignment->attrspecptr=actattrspec;
  actassignment->literalptr=actliteral;				}
break;
case 83:
#line 521 "pql_parse.y"
{ if ((deletejob=
  (DeleteOp*)malloc(sizeof(DeleteOp))) == NULL) {
	perror("malloc");
	exit(1);
  } 								}
break;
case 84:
#line 526 "pql_parse.y"
{ strcpy(deletejob->tablename, actname);			
  parsephase=DELCOND;						}
break;
case 86:
#line 531 "pql_parse.y"
{ deletejob->conditionptr = NULL;				}
break;
case 87:
#line 534 "pql_parse.y"
{ deletejob->conditionptr = actcondition[actdepth];		}
break;
case 88:
#line 539 "pql_parse.y"
{ if ((createjob=
  (CreateOp*)malloc(sizeof(CreateOp))) == NULL) {
	perror("malloc");
	exit(1);
  }								}
break;
case 89:
#line 544 "pql_parse.y"
{ strcpy(createjob->tablename, actname);		
  if ((createjob->extlistptr=
  (ExtList*)malloc(sizeof(ExtList))) == NULL) {
	perror("malloc");
	exit(1);
  } 
  actextlist = createjob->extlistptr;		      		}
break;
case 91:
#line 555 "pql_parse.y"
{ if ((extendjob=
  (ExtendOp*)malloc(sizeof(ExtendOp))) == NULL) {
	perror("malloc");
	exit(1);
  }								}
break;
case 92:
#line 560 "pql_parse.y"
{ strcpy(extendjob->tablename, actname);		
  if ((extendjob->extlistptr=
  (ExtList*)malloc(sizeof(ExtList))) == NULL) {
	perror("malloc");
	exit(1);
  } 
  actextlist = extendjob->extlistptr;		      		}
break;
case 94:
#line 570 "pql_parse.y"
{ actextlist->aspecptr=actaspec;
  if ((actextlist->next=
  (ExtList*)malloc(sizeof(ExtList))) == NULL) {
	perror("malloc");
	exit(1);
  }	
  actextlist=actextlist->next;	       				}
break;
case 96:
#line 579 "pql_parse.y"
{ actextlist->aspecptr = actaspec;
  actextlist->next = NULL;					}
break;
case 97:
#line 584 "pql_parse.y"
{ if ((actaspec=
  (Aspec*)malloc(sizeof(Aspec))) == NULL) {
	perror("malloc");
	exit(1);
  }
  actaspec->attrkey=actkey;
  strcpy(actaspec->attrname, actname);
  actaspec->attrtype = acttype;
  actaspec->attrsize = actintval;				}
break;
case 99:
#line 596 "pql_parse.y"
{ actintval=0; }
break;
case 100:
#line 600 "pql_parse.y"
{ if ((shrinkjob=
  (ShrinkOp*)malloc(sizeof(ShrinkOp))) == NULL) {
	perror("malloc");
	exit(1);
  }								}
break;
case 101:
#line 605 "pql_parse.y"
{ strcpy(shrinkjob->tablename, actname);		
  if ((shrinkjob->shrinklistptr=
  (ShrinkList*)malloc(sizeof(ShrinkList))) == NULL) {
	perror("malloc");
	exit(1);
  } 
  actshrinklist = shrinkjob->shrinklistptr;		      	}
break;
case 103:
#line 615 "pql_parse.y"
{ strcpy(actshrinklist->attrname,actname);
  if ((actshrinklist->next=
  (ShrinkList*)malloc(sizeof(ShrinkList))) == NULL) {
	perror("malloc");
	exit(1);
  }	
  actshrinklist=actshrinklist->next;  				}
break;
case 105:
#line 624 "pql_parse.y"
{ strcpy(actshrinklist->attrname, actname);
  actshrinklist->next = NULL;					}
break;
case 106:
#line 631 "pql_parse.y"
{ if ((actpredicate[actdepth]=
  (Predicate*)malloc(sizeof(Predicate))) == NULL) {
	perror("malloc");
	exit(1);
  } 								}
break;
case 107:
#line 636 "pql_parse.y"
{ if ((actcondition[actdepth]=
  (Condition*)malloc(sizeof(Condition))) == NULL) {
	perror("malloc");
	exit(1);	
  }
  actcondition[actdepth]->cond1ptr=NULL;
  actcondition[actdepth]->cond2ptr=NULL;	
  actcondition[actdepth]->predicateptr=actpredicate[actdepth];
  actcondition[actdepth]->negate=0;
  actcondition[actdepth]->rule=COND_PREDICATE;			}
break;
case 108:
#line 648 "pql_parse.y"
{ /* save built condition */
  saved2condition[actdepth]=actcondition[actdepth];
  if ((actcondition[actdepth]=
  (Condition*)malloc(sizeof(Condition))) == NULL) {
	perror("malloc");
	exit(1);	
  }
  actcondition[actdepth]->cond1ptr=saved2condition[actdepth];
  actcondition[actdepth]->cond2ptr=NULL;
  actcondition[actdepth]->predicateptr=NULL;
  actcondition[actdepth]->negate=0;
  actcondition[actdepth]->rule=COND_NOT;			}
break;
case 109:
#line 662 "pql_parse.y"
{ saved1condition[actdepth][condcount]=actcondition[actdepth]; 
  condcount++;		                                        }
break;
case 110:
#line 665 "pql_parse.y"
{ condcount--;
  saved2condition[actdepth]=actcondition[actdepth]; 			
  if ((actcondition[actdepth]=
  (Condition*)malloc(sizeof(Condition))) == NULL) {
	perror("malloc");
	exit(1);	
  }
  actcondition[actdepth]->cond1ptr=saved1condition[actdepth][condcount];
  actcondition[actdepth]->cond2ptr=saved2condition[actdepth];
  actcondition[actdepth]->predicateptr=NULL;
  actcondition[actdepth]->negate=0;
  actcondition[actdepth]->rule=COND_AND;			}
break;
case 111:
#line 679 "pql_parse.y"
{ saved1condition[actdepth][condcount]=actcondition[actdepth];	
  condcount++;                                                    }
break;
case 112:
#line 682 "pql_parse.y"
{ condcount--;
  saved2condition[actdepth]=actcondition[actdepth];		
  if ((actcondition[actdepth]=
  (Condition*)malloc(sizeof(Condition))) == NULL) {
	perror("malloc");
	exit(1);	
  }
  actcondition[actdepth]->cond1ptr=saved1condition[actdepth][condcount]; 
  actcondition[actdepth]->cond2ptr=saved2condition[actdepth];
  actcondition[actdepth]->predicateptr=NULL;
  actcondition[actdepth]->negate=0;
  actcondition[actdepth]->rule=COND_OR;				}
break;
case 114:
#line 701 "pql_parse.y"
{ actpredicate[actdepth]->expr1ptr=actexpr;
  actpredicate[actdepth]->comparison=getcompid(actcomp);	}
break;
case 115:
#line 703 "pql_parse.y"
{ actpredicate[actdepth]->expr2ptr=actexpr;			
  actpredicate[actdepth]->marked = UNMARKED;
  actpredicate[actdepth]->rule = PRED_EXPR;			}
break;
case 116:
#line 709 "pql_parse.y"
{ actpredicate[actdepth]->expr1ptr=actexpr;
  actpredicate[actdepth]->comparison=getcompid(actcomp);
  actdepth++;							}
break;
case 117:
#line 712 "pql_parse.y"
{ actdepth--; 		
  actpredicate[actdepth]->queryopptr=actqueryjob[actdepth+1];
  actpredicate[actdepth]->marked = 0;
  actpredicate[actdepth]->rule = PRED_QUERY;			}
break;
case 119:
#line 718 "pql_parse.y"
{ actpredicate[actdepth]->expr1ptr=actexpr;
  actpredicate[actdepth]->comparison=getcompid(actcomp);
  actdepth++;							}
break;
case 120:
#line 721 "pql_parse.y"
{ actdepth--;
  actpredicate[actdepth]->queryopptr=actqueryjob[actdepth+1];		
  actpredicate[actdepth]->marked = 0;
  actpredicate[actdepth]->rule = PRED_ALL_QUERY;		}
break;
case 122:
#line 727 "pql_parse.y"
{ actpredicate[actdepth]->expr1ptr=actexpr;
  actpredicate[actdepth]->comparison=getcompid(actcomp);
  actdepth++;							}
break;
case 123:
#line 730 "pql_parse.y"
{ actdepth--;
  actpredicate[actdepth]->queryopptr=actqueryjob[actdepth+1];		
  actpredicate[actdepth]->marked = 0;
  actpredicate[actdepth]->rule = PRED_ANY_QUERY;		}
break;
case 125:
#line 736 "pql_parse.y"
{ actpredicate[actdepth]->expr1ptr=actexpr;				
  actdepth++;							}
break;
case 126:
#line 738 "pql_parse.y"
{ actdepth--;
  actpredicate[actdepth]->queryopptr=actqueryjob[actdepth+1];	
  actpredicate[actdepth]->marked = 0;
  actpredicate[actdepth]->rule = PRED_IN_QUERY;			}
break;
case 128:
#line 744 "pql_parse.y"
{ actpredicate[actdepth]->expr1ptr=actexpr;				
  if ((actpredicate[actdepth]->exprlistptr=
  (ExprList*)malloc(sizeof(ExprList))) == NULL) {
 	perror("malloc");
	exit(1);
  }
  actexprlist=actpredicate[actdepth]->exprlistptr;		}
break;
case 129:
#line 751 "pql_parse.y"
{ actpredicate[actdepth]->marked = 0;
  actpredicate[actdepth]->rule = PRED_IN_ELIST;   		}
break;
case 130:
#line 754 "pql_parse.y"
{ actdepth++; }
break;
case 131:
#line 755 "pql_parse.y"
{ actdepth--;
  actpredicate[actdepth]->queryopptr=actqueryjob[actdepth+1];
  actpredicate[actdepth]->marked = 0;
  actpredicate[actdepth]->rule = PRED_EXISTS;			}
break;
case 132:
#line 761 "pql_parse.y"
{ actpredicate[actdepth]->attrspecptr=actattrspec;			
  actpredicate[actdepth]->literalptr=actliteral;
  actpredicate[actdepth]->marked = 0; 
  actpredicate[actdepth]->rule = PRED_LIKE;			}
break;
case 133:
#line 771 "pql_parse.y"
{ actexprlist->exprptr=actexpr;
 if ((actexprlist->next=
 (ExprList*)malloc(sizeof(ExprList))) == NULL) {
 	perror("malloc");
	exit(1);
  }
  actexprlist=actexprlist->next;				}
break;
case 135:
#line 780 "pql_parse.y"
{ actexprlist->exprptr = actexpr; 
  actexprlist->next = NULL;					}
break;
case 136:
#line 787 "pql_parse.y"
{ if ((actexpr=
  (Expr*)malloc(sizeof(Expr))) == NULL) {
	perror("malloc");
	exit(1);
  }
  actexpr->rule=EXPR_LIT;
  actexpr->literalptr=actliteral;				}
break;
case 137:
#line 796 "pql_parse.y"
{ if ((actexpr=
  (Expr*)malloc(sizeof(Expr))) == NULL) {
	perror("malloc");
	exit(1);
  }
  actexpr->rule=EXPR_ATTSPEC;
  actexpr->attrspecptr=actattrspec;				}
break;
case 138:
#line 806 "pql_parse.y"
{ saved1expr[expcount]=actexpr; 				
  expcount++;                                                  }
break;
case 139:
#line 809 "pql_parse.y"
{ expcount--;
  saved2expr=actexpr;
  if ((actexpr=
  (Expr*)malloc(sizeof(Expr))) == NULL) {
	perror("malloc");
	exit(1);
  }
  actexpr->expr1ptr=saved1expr[expcount];
  actexpr->expr2ptr=saved2expr;
  actexpr->rule = EXPR_PLUS;					}
break;
case 140:
#line 822 "pql_parse.y"
{ saved1expr[expcount]=actexpr;
  expcount++; 		         				}
break;
case 141:
#line 825 "pql_parse.y"
{ expcount--;
  saved2expr=actexpr;
  if ((actexpr=
  (Expr*)malloc(sizeof(Expr))) == NULL) {
	perror("malloc");
	exit(1);
  }
  actexpr->expr1ptr=saved1expr[expcount];
  actexpr->expr2ptr=saved2expr;
  actexpr->rule = EXPR_MINUS;					}
break;
case 142:
#line 837 "pql_parse.y"
{ saved1expr[expcount]=actexpr;
  expcount++; 		           				}
break;
case 143:
#line 840 "pql_parse.y"
{ expcount--;
  saved2expr=actexpr;
  if ((actexpr=
  (Expr*)malloc(sizeof(Expr))) == NULL) {
	perror("malloc");
	exit(1);
  }
  actexpr->expr1ptr=saved1expr[expcount];
  actexpr->expr2ptr=saved2expr;
  actexpr->rule = EXPR_MUL;					}
break;
case 144:
#line 852 "pql_parse.y"
{ saved1expr[expcount]=actexpr; 			
  expcount++;                                                 	}
break;
case 145:
#line 855 "pql_parse.y"
{ expcount--;
  saved2expr=actexpr;
  if ((actexpr=
  (Expr*)malloc(sizeof(Expr))) == NULL) {
	perror("malloc");
	exit(1);
  }
  actexpr->expr1ptr=saved1expr[expcount];
  actexpr->expr2ptr=saved2expr;
  actexpr->rule = EXPR_DIV;					}
break;
case 146:
#line 867 "pql_parse.y"
{ if ((actexpr=
  (Expr*)malloc(sizeof(Expr))) == NULL) {
	perror("malloc");
	exit(1);
  }
  if (actqueryjob[actdepth]->selectmode == PROJECTION)
	actqueryjob[actdepth]->selectmode = AGREGATION;
  actexpr->functionptr=actfunction;
  actexpr->rule = EXPR_FUNC;					}
break;
case 147:
#line 881 "pql_parse.y"
{ if (actattrspeclist == NULL) {
    if ((actattrspeclist=
    (AttrSpecList*)malloc(sizeof(AttrSpecList))) == NULL) {
	 	perror("malloc");
		exit(1);
    }
    actattrspeclist->attrspecptr = actattrspec;
    tmpattrspeclist = actattrspeclist;
  } else {
    if ((tmpattrspeclist->next=
    (AttrSpecList*)malloc(sizeof(AttrSpecList))) == NULL) {
 		perror("malloc");
		exit(1);
    }
    tmpattrspeclist->next->attrspecptr = actattrspec;	
    tmpattrspeclist = tmpattrspeclist->next;			
  }								}
break;
case 149:
#line 900 "pql_parse.y"
{ if (actattrspeclist == NULL) {
    if ((actattrspeclist=
    (AttrSpecList*)malloc(sizeof(AttrSpecList))) == NULL) {
	 	perror("malloc");
		exit(1);
    }
    actattrspeclist->attrspecptr = actattrspec;
    actattrspeclist->next = NULL;
  } else {
    if ((tmpattrspeclist->next=
    (AttrSpecList*)malloc(sizeof(AttrSpecList))) == NULL) {
 		perror("malloc");
		exit(1);
    }   
    tmpattrspeclist->next->attrspecptr = actattrspec;
    tmpattrspeclist->next->next = NULL;
  }							}
break;
case 150:
#line 922 "pql_parse.y"
{ 
  if ((actfunction=
  (Function*)malloc(sizeof(Function))) == NULL) {
	perror("malloc");
	exit(1);
  }
  actfunction->rule=actrule;					}
break;
case 151:
#line 929 "pql_parse.y"
{ actfunction->exprptr = actexpr;                               }
break;
case 153:
#line 934 "pql_parse.y"
{ actrule=FUNC_AVG; 						}
break;
case 154:
#line 936 "pql_parse.y"
{ actrule=FUNC_MIN; 						}
break;
case 155:
#line 938 "pql_parse.y"
{ actrule=FUNC_MAX; 						}
break;
case 156:
#line 940 "pql_parse.y"
{ actrule=FUNC_SUM; 						}
break;
case 157:
#line 946 "pql_parse.y"
{ if ((actattrspec=
  (AttrSpec*)malloc(sizeof(AttrSpec))) == NULL) {
 	perror("malloc");
	exit(1);
  }
  actattrspec->cast = actcast;

  /* make entry in global attribute table */
  attable[attnum].attrspec=actattrspec;
  attable[attnum].attrspec->access=NONE; 
  attable[attnum].phase=parsephase;
  attable[attnum].used=actdepth;

  if (parsephase == CONDITION) {
    /* find out the query depth of the given attribute */
    actattrspec->tablename[0] = '\0';
    if (get_table(actqueryjob[actdepth], 
	actname, 
	actattrspec->tablename, 
	actattrspec->talias, 
	&attable[attnum].depth) 
	!= 0) {
      fprintf(stderr, "PQL-ERROR: cannot get query depth for attribute %s\n", actname);
      return;
    }
  } else {
    attable[attnum].depth=actdepth;
    actattrspec->talias[0]='\0';					
    actattrspec->tablename[0]='\0';		
  }
  attnum++;
  if (attnum >= ATABLESIZE) {
    fprintf(stderr, "PQL-ERROR: Too many attributes - attribute table exceeded\n");
    return;
  }
  strcpy(actattrspec->attrname, actname);			}
break;
case 158:
#line 983 "pql_parse.y"
{ if ((actattrspec=
  (AttrSpec*)malloc(sizeof(AttrSpec))) == NULL) {
 	perror("malloc");
	exit(1);
  }
  actattrspec->cast = actcast;

  /* make entry in global attribute table */
  attable[attnum].attrspec=actattrspec;
  attable[attnum].attrspec->access=NONE; 
  attable[attnum].phase=parsephase;
  attable[attnum].used=actdepth;
 
  if (attnum >= ATABLESIZE) {
    fprintf(stderr, "PQL-ERROR: Too many atributes - attribute table exceeded\n");
    return;
  }
  actattrspec->talias[0]='\0';					
  strcpy(actattrspec->tablename, actname);			}
break;
case 159:
#line 1002 "pql_parse.y"
{ strcpy(actattrspec->attrname, actname);			
  if (parsephase == CONDITION) {
    /* find out the query depth of the given attribute */
    if (get_table(actqueryjob[actdepth], 
		  actname,
		  actattrspec->tablename, 
		  actattrspec->talias, 
		  &attable[attnum].depth) 
	!= 0) {
      fprintf(stderr, "PQL-ERROR: cannot get query depth for attribute %s\n", actname);
      return;
    }
  } else {
    attable[attnum].depth=actdepth;
  }
  attnum++;							}
break;
case 160:
#line 1022 "pql_parse.y"
{ actcast = T_NONE; }
break;
case 161:
#line 1024 "pql_parse.y"
{ actcast = acttype; }
break;
case 162:
#line 1030 "pql_parse.y"
{ if (actconstantlist == NULL) {
    if ((actconstantlist=
    (ConstantList*)malloc(sizeof(ConstantList))) == NULL) {
		perror("malloc");
		exit(1);
    }
    actconstantlist->literalptr=actliteral;
    tmpconstantlist = actconstantlist;
  } else {
    if ((tmpconstantlist->next=
    (ConstantList*)malloc(sizeof(ConstantList))) == NULL) {
		perror("malloc");
		exit(1);
    }
    tmpconstantlist->next->literalptr = actliteral;
    tmpconstantlist = tmpconstantlist->next;
  }								}
break;
case 164:
#line 1049 "pql_parse.y"
{ if (actconstantlist == NULL) {
    if ((actconstantlist=
    (ConstantList*)malloc(sizeof(ConstantList))) == NULL) {
		perror("malloc");
		exit(1);
    }
    actconstantlist->literalptr = actliteral;
    actconstantlist->next = NULL;
  } else {
    if ((tmpconstantlist->next=
    (ConstantList*)malloc(sizeof(ConstantList))) == NULL) {
		perror("malloc");
		exit(1);
    }
    tmpconstantlist->next->literalptr = actliteral;
    tmpconstantlist->next->next = NULL;
  }								}
break;
case 165:
#line 1071 "pql_parse.y"
{ if ((actliteral= 
  (Literal*)malloc(sizeof(Literal))) == NULL) {
	perror("malloc");
	exit(1);
   }
   actliteral->rule=T_LONG;
   actliteral->intval=actintval;				}
break;
case 166:
#line 1080 "pql_parse.y"
{ if ((actliteral= 
  (Literal*)malloc(sizeof(Literal))) == NULL) {
	perror("malloc");
	exit(1);
   }
   actliteral->rule=T_FLOAT;
   actliteral->floatval=actfloatval;				}
break;
case 167:
#line 1088 "pql_parse.y"
{ if ((actliteral= 
  (Literal*)malloc(sizeof(Literal))) == NULL) {
	perror("malloc");
	exit(1);
   }
   actliteral->rule=T_DOUBLE;
   actliteral->doubleval=actdoubleval;				}
break;
case 168:
#line 1096 "pql_parse.y"
{ if ((actliteral= 
  (Literal*)malloc(sizeof(Literal))) == NULL) {
	perror("malloc");
	exit(1);
   }
   actliteral->rule=T_CHAR;
   strcpy(actliteral->strval, actstrval);			}
break;
case 169:
#line 1105 "pql_parse.y"
{ if ((actliteral= 
  (Literal*)malloc(sizeof(Literal))) == NULL) {
	perror("malloc");
	exit(1);
   }
   actliteral->rule=NVAL;					}
break;
#line 1935 "y.tab.c"
    }
    yyssp -= yym;
    yystate = *yyssp;
    yyvsp -= yym;
    yym = yylhs[yyn];
    if (yystate == 0 && yym == 0)
    {
#if YYDEBUG
        if (yydebug)
            printf("yydebug: after reduction, shifting from state 0 to\
 state %d\n", YYFINAL);
#endif
        yystate = YYFINAL;
        *++yyssp = YYFINAL;
        *++yyvsp = yyval;
        if (yychar < 0)
        {
            if ((yychar = yylex()) < 0) yychar = 0;
#if YYDEBUG
            if (yydebug)
            {
                yys = 0;
                if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
                if (!yys) yys = "illegal-symbol";
                printf("yydebug: state %d, reading %d (%s)\n",
                        YYFINAL, yychar, yys);
            }
#endif
        }
        if (yychar == 0) goto yyaccept;
        goto yyloop;
    }
    if ((yyn = yygindex[yym]) && (yyn += yystate) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yystate)
        yystate = yytable[yyn];
    else
        yystate = yydgoto[yym];
#if YYDEBUG
    if (yydebug)
        printf("yydebug: after reduction, shifting from state %d \
to state %d\n", *yyssp, yystate);
#endif
    if (yyssp >= yyss + yystacksize - 1)
    {
        goto yyoverflow;
    }
    *++yyssp = yystate;
    *++yyvsp = yyval;
    goto yyloop;
yyoverflow:
    yyerror("yacc stack overflow");
yyabort:
    return (1);
yyaccept:
    return (0);
}
