%{

/* qddb/Lib/LibQddb/EntryParse.y 
 * Bison/yacc grammar file for the Qddb Entry parser for the presentation form 
 * of a tuple.
 *
 * Copyright (C) 1993, 1994 Herrin Software Development, Inc.
 * All rights reserved.
 *
 * This file is part of Qddb.
 *
 * Qddb is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License Version 2
 * as published by the Free Software Foundation.
 *
 * Qddb is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Qddb; see the file LICENSE.  If not, write to:
 *
 *	Herrin Software Development, Inc. 
 *	R&D Division
 *	41 South Highland Ave. 
 *	Prestonsburg, KY 41653 
 */

#include "Qddb.h"

/* Define yyparse() to be EntryParse() so that multiple parsers can
 * occupy the same executable.
 */
#define yyparse	EntryParse
#define yylex   Qddblex

int yylex();

static Schema		*CurrentSchema;
static InCoreEntry	*CurrentEntries = NULL;
static unsigned int	CurrentEntriesLength;

void Qddb_EntryParse_Set(schema)
    Schema		*schema;
{
    CurrentSchema = schema;
}

InCoreEntry *Qddb_EntryParse_Get()
{
    return CurrentEntries;
}

static unsigned int	CurrentAttribute = 0;
static unsigned int	CurrentAncestors[MAXIMUM_NUMBER_OF_SCHEMA_LEVELS];
static unsigned int	CurrentInstances[MAXIMUM_NUMBER_OF_SCHEMA_LEVELS];
static unsigned int	CurrentLevel = 1;
%}

%pure_parser
%expect 1

%token STRING CSTRING
%token ALIAS VERBOSENAME
%token LPAREN RPAREN ASTERIK COMMA DOUBLEQUOTE SINGLEQUOTE EQUALS
%token BLANKLINE NUMBER TYPE DEFAULTVALUE

%type <String>		STRING CSTRING
%type <Integer>		UniqueSequenceNumber Identifier IdentifierLparen

%union {
    char	*String;
    double	Real;
    int		Integer;
};


%%

FileOfEntries:
    WholeEntry {
    };

WholeEntry:
    UniqueSequenceNumber Entry {
	CurrentEntriesLength = CurrentAttribute;
        CurrentEntries = (InCoreEntry *)Realloc(CurrentEntries, sizeof(InCoreEntry)*(CurrentAttribute+2));
	CurrentEntries[CurrentAttribute].SequenceNumber = 0;
	CurrentEntries[CurrentAttribute+1].SequenceNumber = 0;
	CurrentAttribute = 0;
    };

Entry:
    /* return a TEMPLATE */
    Record {
    } |
    Record Entry {
    };

Record:
    /* return an INSTANCE */
    IndividualRecord {
    } |
    IndividualRecord Record {
    };

IndividualRecord:
    /* return a TEMPLATE */
    Identifier {
    } |
    IdentifierLparen Record RPAREN {
        CurrentInstances[CurrentLevel] = 0;
	CurrentLevel--;
    };

IdentifierLparen:
    Identifier LPAREN {
	CurrentLevel++;
        CurrentInstances[CurrentLevel] = 0;
	CurrentAttribute--;
    };

Identifier:
    STRING {
	SchemaNode	*ThisAttribute;
	int		AttrNo, FindAttribute();
	int		i;

    	/* return an INSTANCE */
	AttrNo = FindAttribute($1);
	if (AttrNo < 0) {
	    qddb_errmsg = Malloc(BUFSIZ);
	    qddb_errno = QDDB_ERRNO_PARSE_ERROR;
	    sprintf(qddb_errmsg, "Attribute named '%s' is either misplaced or it is not \
an attribute name in Schema\n", $1);
	    YYERROR;
	}

	ThisAttribute = CurrentSchema->Entries+AttrNo;
        CurrentEntries = 
            (InCoreEntry *)Realloc(CurrentEntries, sizeof(InCoreEntry)*(CurrentAttribute+2));
	CurrentEntries[CurrentAttribute].BytesOfData = 0;
	CurrentEntries[CurrentAttribute].AttributeNumber = AttrNo;
	$$ = ThisAttribute->Number;
        if (CurrentAncestors[CurrentLevel] != ThisAttribute->Number ||
	    CurrentInstances[CurrentLevel] == 0) {
	    CurrentInstances[CurrentLevel] = 1;
	    CurrentAncestors[CurrentLevel] = ThisAttribute->Number;
	} else {
            CurrentInstances[CurrentLevel]++;
	}
	for (i = 0; i < CurrentLevel; i++) {
	    CurrentEntries[CurrentAttribute].Instance[i] = CurrentInstances[i+1];
	}
	CurrentAttribute++;
#ifdef DEBUG
fprintf(stderr, "Recognized %s is same as %s\n", 
ThisAttribute->Name, CurrentSchema->Entries[ThisAttribute->Number].Name);
#endif
    } |
    STRING EQUALS CSTRING {
	SchemaNode	*ThisAttribute;
	int		AttrNo, FindAttribute();
	int		i;

    	/* The grammar contains an anomaly here.  Constructs of
    	 * the form:
    	 *	string (
    	 *		string1 = "hello" (
    	 *			string 2 = "hi"
    	 *		)
    	 *	);
    	 * do not make any sense, but the grammar is so much 
    	 * simpler due to the allowance of this construct that
    	 * I deem it easier to check for correctness in the
    	 * action of the grammar, rather than the grammar 
    	 * itself.  The error message will be the same, it will
    	 * be produced by the C code associated with the action
    	 * instead of the parser itself.
    	 * 
    	 * Correct syntax is as follows:
    	 * 	string (
    	 *		string1 (
    	 *			string2 = "something"
    	 *			string3 = "something"
    	 *		)
    	 *		string4 = "something else"
    	 *	);
    	 */
#ifdef DEBUG
fprintf(stderr, "found one!\n");
#endif
	 AttrNo = FindAttribute($1);
	 if (AttrNo < 0) {
	     qddb_errmsg = Malloc(BUFSIZ);
	     qddb_errno = QDDB_ERRNO_PARSE_ERROR;
	     sprintf(qddb_errmsg, "Attribute named '%s' is either misplaced or it is not \
an attribute name in Schema", $1);
	     YYERROR;
	 }
         ThisAttribute = CurrentSchema->Entries+AttrNo;
         CurrentEntries = 
            (InCoreEntry *)Realloc(CurrentEntries, sizeof(InCoreEntry)*(CurrentAttribute+2));
	 CurrentEntries[CurrentAttribute].AttributeNumber = AttrNo;
	 CurrentEntries[CurrentAttribute].Data = $3;
	 CurrentEntries[CurrentAttribute].Marked = Inapplicable;
	 CurrentEntries[CurrentAttribute].BytesOfData = strlen($3);
	 CurrentEntries[CurrentAttribute].SequenceNumber = CurrentEntries[0].SequenceNumber;
	 $$ = ThisAttribute->Number;
	 if (CurrentAncestors[CurrentLevel] != ThisAttribute->Number ||
	     CurrentInstances[CurrentLevel] == 0) {
	     CurrentInstances[CurrentLevel] = 1;
	     CurrentAncestors[CurrentLevel] = ThisAttribute->Number;
	 } else {
             CurrentInstances[CurrentLevel]++;
	 }
         for (i = 0; i < CurrentLevel; i++) {
	     CurrentEntries[CurrentAttribute].Instance[i] = CurrentInstances[i+1];
	 }
         CurrentAttribute++;
    };

UniqueSequenceNumber:
    NUMBER EQUALS CSTRING {
	CurrentEntries = (InCoreEntry *)Calloc(sizeof(InCoreEntry)*2);
	CurrentEntriesLength = 0;
	CurrentAttribute = 0;
	CurrentEntries[0].SequenceNumber = atoi($3);
	CurrentEntries[0].BytesOfData = 0;
	CurrentEntries[0].AttributeNumber = 0;
        CurrentEntries[1].SequenceNumber = 0;
    };

%%

int FindAttribute(string)
    char		*string;
{
    unsigned int	i, j;

    for (i = 1; i <= CurrentSchema->NumberOfAttributes; i++) {
	if (strcmp(string, CurrentSchema->Entries[i].Name) == 0) {
	    /* this is a possibility.. */
	    if (CurrentLevel != CurrentSchema->Entries[i].Level) {
#ifdef DEBUG
fprintf(stderr, "same name, different levels #1 %d != %d\n", CurrentLevel,
	CurrentSchema->Entries[i].Level);
#endif
		continue;
	    }
	    /* Check out the ancestors */
	    if (CurrentSchema->Entries[i].Level != CurrentLevel)
		continue;
	    for (j = 1; j < CurrentLevel; j++) {
		if (CurrentSchema->Entries[i].AncestorNumber[j] != CurrentAncestors[j]) {
#ifdef DEBUG
fprintf(stderr, "%d %d\n", CurrentSchema->Entries[i].AncestorNumber[j], CurrentAncestors[j]);
fprintf(stderr, "Bad Ancestors\n");
#endif
		    break;
		}

	    }
	    if (j != CurrentLevel) {
#ifdef DEBUG
fprintf(stderr, "same name, different levels #2\n");
#endif
		continue;
	    }
#ifdef DEBUG
fprintf(stderr, "found %s == %s\n", CurrentSchema->Entries[i].Name,
string);
#endif
	    return i;
	}
    }
    return -1;
}

void ResetEntryParser()
{
    int yywrap();

    CurrentEntries = NULL;
    CurrentAttribute = 0;
    CurrentLevel = 1;
    CurrentInstances[0] = 0;
    CurrentInstances[1] = 0;
    CurrentAncestors[0] = 0;
    CurrentAncestors[1] = 0;
    yywrap();
}
