
set fx_font_config(charter,slant) {italic roman}
set fx_font_config(charter,weight) {bold medium}
set fx_font_config(charter,size) {tiny small medium large huge}
set fx_font_config(courier,slant) {italic oblique roman}
set fx_font_config(courier,weight) {bold medium}
set fx_font_config(courier,size) {tiny small medium large huge}
set fx_font_config(fixed,slant) {roman}
set fx_font_config(fixed,weight) {bold medium}
set fx_font_config(fixed,size) {tiny small medium}
set fx_font_config(helvetica,slant) {oblique roman}
set fx_font_config(helvetica,weight) {bold medium}
set fx_font_config(helvetica,size) {tiny small medium large huge}
set fx_font_config(lucida,slant) {italic roman}
set fx_font_config(lucida,weight) {bold medium}
set fx_font_config(lucida,size) {tiny small medium large huge}
set {fx_font_config(lucidabright,slant)} {italic roman}
set {fx_font_config(lucidabright,weight)} {demibold medium}
set {fx_font_config(lucidabright,size)} {tiny small medium large huge}
set {fx_font_config(lucidatypewriter,slant)} {roman}
set {fx_font_config(lucidatypewriter,weight)} {bold medium}
set {fx_font_config(lucidatypewriter,size)} {tiny small medium large huge}
set {fx_font_config(new century schoolbook,slant)} {italic roman}
set {fx_font_config(new century schoolbook,weight)} {bold medium}
set {fx_font_config(new century schoolbook,size)} {tiny small medium large huge}
set fx_font_config(times,slant) {italic roman}
set fx_font_config(times,weight) {bold medium}
set fx_font_config(times,size) {tiny small medium large huge}
set fx_font_config(utopia,slant) {italic roman}
set fx_font_config(utopia,weight) {bold medium}
set fx_font_config(utopia,size) {tiny small medium large huge}
set fx_font_config(Listbox,avail_families) {courier fixed}

proc Fx:ChangeAllFonts {{w .}} {
    set class [winfo class $w]
    set font [option get $w font $class]
    if {[string compare $class Menu] == 0} {
	catch [list $w configure -font $font]
	set last [$w index last]
	if {[string compare $last none] == 0} {
	    return
	}
	for {set i 0} {$i <= $last} {incr i} {
	    catch [list $w entryconfigure $i -font $font]
	}
	return
    }
    foreach i [winfo children $w] {
	set font [option get $i font $class]
	catch [list $i configure -font $font]
	Fx:ChangeAllFonts $i
    }
}

proc Fx:ConfigureFonts {} {
    global fx_resources fx_tmpfont fx_font fx_classes fx_tmpfont_radiobutton fx_config fx_font_config

    if {[winfo exists .config_fonts]} {
	if {[info exists fx_config(geom,config_fonts)]} {
	    wm geometry .config_fonts $fx_config(geom,config_fonts)
	}
	wm withdraw .config_fonts
	wm deiconify .config_fonts
	return
    }
    catch "unset fx_tmpfont"
    toplevel .config_fonts
    wm title .config_fonts "Font Configuration"
    if {[info exists fx_config(geom,config_fonts)]} {
	set l [split $fx_config(geom,config_fonts) +]
	wm geometry .config_fonts +[lindex $l 1]+[lindex $l 2]
    }
    set cf .config_fonts
    label $cf.l10 -text "This is the current selected font"
    pack $cf.l10 -side bottom -expand on -fill x
    frame $cf.f4
    pack $cf.f4 -side bottom -expand on -fill both
    button $cf.f4.ok -text Ok -command [list Fx:SaveFontConfig $cf]
    pack $cf.f4.ok -side left -padx 30m -pady 10m -ipadx 20m -ipady 2m
    button $cf.f4.cancel -text Cancel -command [list Fx:CancelFontConfig $cf ]
    pack $cf.f4.cancel -side right -padx 30m -pady 10m -ipadx 20m -ipady 2m
    frame $cf.f
    pack $cf.f -side left -expand on -fill both -padx 4m 
    label $cf.f.l -text "Widget Class" -fg blue
    pack $cf.f.l -side top -expand on -fill x
    set x 0
    set fx_tmpfont(classes) {}
    foreach i $fx_classes {
	set class $i
	lappend fx_tmpfont(classes) $class
	if {[info exists fx_font($class)]} {
	    set fx_tmpfont($class,font) $fx_font($class)
	} else {
	    set fx_tmpfont($class,font) [option get . font $class]
	}
	radiobutton $cf.f.r$x -text $class -variable fx_tmpfont(widget) -anchor w -value $class
	pack $cf.f.r$x -side top -expand on -fill both
	incr x
    }
    frame $cf.f2 
    pack $cf.f2 -side left -expand on -fill both -padx 4m
    label $cf.f2.l -text "Font Family" -fg blue
    pack $cf.f2.l -side top -expand on -fill x
    set x 0
    foreach i $fx_font_config(families) {
	radiobutton $cf.f2.r$x -text $i -variable fx_tmpfont(family) -anchor w -value $i -state disabled
	pack $cf.f2.r$x -side top -expand on -fill both
	set fx_tmpfont_radiobutton(family,$i) $cf.f2.r$x
	incr x
    }
    frame $cf.f3
    pack $cf.f3 -side left -expand on -fill both -padx 4m
    label $cf.f3.l -text "Font Slant" -fg blue
    pack $cf.f3.l -side top -expand on -fill x
    set x 0
    foreach i $fx_font_config(slants) {
	radiobutton $cf.f3.r$x -text $i -variable fx_tmpfont(slant) -anchor w -value [string index $i 0] \
	    -state disabled
	pack $cf.f3.r$x -side top -expand on -fill both
	set fx_tmpfont_radiobutton(slant,$i) $cf.f3.r$x
	incr x
    }
    label $cf.f3.l2 -text "Font Weight" -fg blue
    pack $cf.f3.l2 -side top -expand on -fill x
    foreach i $fx_font_config(weights) {
	radiobutton $cf.f3.r$x -text $i -variable fx_tmpfont(weight) -anchor w -value $i \
	    -state disabled
	pack $cf.f3.r$x -side top -expand on -fill both
	set fx_tmpfont_radiobutton(weight,$i) $cf.f3.r$x
	incr x
    }
    label $cf.f3.l3 -text "Font Size" -fg blue
    pack $cf.f3.l3 -side top -expand on -fill x
    set s $fx_font_config(sizes)
    set j 0
    foreach i $fx_font_config(sizenames) {
	radiobutton $cf.f3.r$x -text $i -variable fx_tmpfont(size) -anchor w -value [lindex $s $j] \
	    -state disabled
	pack $cf.f3.r$x -side top -expand on -fill both
	set fx_tmpfont_radiobutton(size,$i) $cf.f3.r$x
	incr x
	incr j
    }
    trace variable fx_tmpfont w Fx:TraceFonts
    bind $cf <Configure> Fx:ConfigFontWindow
    tkwait window $cf
    if {[info exists fx_tmpfont(cancelled)]} {
	set retval 0
    } else {
	set retval 1
    }
    catch "unset fx_tmpfont"
    return $retval
}

proc Fx:CancelFontConfig {w} {
    global fx_tmpfont
    set fx_tmpfont(cancelled) 1
    destroy $w
}

proc Fx:ConfigFontWindow {} {
    global fx_config
    set fx_config(geom,config_fonts) [wm geometry .config_fonts]
}

proc Fx:TraceFonts {n1 n2 op} {
    global fx_tmpfont fx_tmpfont_radiobutton fx_font_config

    switch $n2 {
	size -
	weight - 
	slant {
	    Fx:PutFontDefault
	}
	family {
	    foreach i $fx_font_config(slants) {
		$fx_tmpfont_radiobutton(slant,$i) configure -state disabled
	    }
	    foreach i $fx_font_config(weights) {
		$fx_tmpfont_radiobutton(weight,$i) configure -state disabled
	    }
	    foreach i $fx_font_config(sizenames) {
		$fx_tmpfont_radiobutton(size,$i) configure -state disabled
	    }
	    set fx_tmpfont(slant) {}
	    set fx_tmpfont(weight) {}
	    set fx_tmpfont(size) {}
	    Fx:SetupFont $fx_tmpfont(family)
	    Fx:PutFontDefault
	}
	widget {
	    foreach i [array names fx_tmpfont_radiobutton] {
		$fx_tmpfont_radiobutton($i) configure -state disabled
	    }
	    Fx:GetFontDefault
	}
    }
}

proc Fx:SaveFontConfig {w} {
    global fx_tmpfont fx_font fx_classes

    foreach i $fx_classes {
	option add *$i.font $fx_tmpfont($i,font)
	set fx_font($i) $fx_tmpfont($i,font)
    }
    destroy $w
    update idletasks
    Fx:ChangeAllFonts
}

proc Fx:PutFontDefault {} {
    global fx_tmpfont

    set widg $fx_tmpfont(widget)
    set tmpfont [format "-*-%s-%s-%s-*-*-*-%s-*-*-*-*-*-*" \
		     $fx_tmpfont(family) $fx_tmpfont(weight) $fx_tmpfont(slant) $fx_tmpfont(size)]
    if {[catch [list .config_fonts.l10 configure -font $tmpfont]] != 0} {
	.config_fonts.l10 configure -text "NO SUCH FONT!!!  TRY AGAIN!!!"
	return
    } else {
	.config_fonts.l10 configure -text "This is the current selected font"
    }
    set fx_tmpfont($widg,font) $tmpfont
}

proc Fx:SetupFont {font} {
    global fx_tmpfont_radiobutton fx_font_config

    set x 0
    foreach j $fx_font_config($font,slant) {
	$fx_tmpfont_radiobutton(slant,$j) configure -state normal
	if {$x == 0} {
	    $fx_tmpfont_radiobutton(slant,$j) select
	    set x 1
	}
    }
    set x 0
    foreach j $fx_font_config($font,weight) {
	$fx_tmpfont_radiobutton(weight,$j) configure -state normal
	if {$x == 0} {
	    $fx_tmpfont_radiobutton(weight,$j) select
	    set x 1
	}
    }
    set x 0
    set y 0
    set s $fx_font_config(sizenames)
    foreach j $fx_font_config($font,size) {
	$fx_tmpfont_radiobutton(size,[lindex $s $y]) configure -state normal
	if {$x == 0} {
	    $fx_tmpfont_radiobutton(size,[lindex $s $y]) select
	    set x 1
	}
	incr y
    }
}

proc Fx:SetFontDefaultProperty {property} {
    global fx_tmpfont fx_font_config

    if {[info exists fx_font_config($widg,$property)]} {
	if {[lsearch $fx_font_config($widg,${property}) $fx_font_config(default_$property)] != -1} {
	    set fx_tmpfont($property) $fx_font_config(default_$property)
	} else {
	    if {[string compare size $property] == 0} {
		set x [lsearch -exact $fx_font_config($widg,$property) small]
		if {$x == -1} {set x 0}
		set fx_tmpfont($property) [lindex $fx_font_config($widg,$property) $x]
	    } else {
		set fx_tmpfont($property) [lindex $fx_font_config($widg,$property) 0]
	    }
	}
    } else  {
	set fx_tmpfont($property) $fx_font_config(default_$property)
    }
    if {[string compare size $property] == 0} {
	set s $fx_font_config(sizenames)
	set fx_tmpfont(size) [lindex $s [lsearch -exact $fx_font_config(sizes) $fx_tmpfont(size)]]
    }
}

proc Fx:GetFontDefault {} {
    global fx_tmpfont fx_tmpfont_radiobutton fx_font_config

    set widg $fx_tmpfont(widget)
    if {[info exists fx_font_config($widg,avail_families)]} {
	foreach i $fx_font_config($widg,avail_families) {
	    $fx_tmpfont_radiobutton(family,$i) configure -state normal	
	}
    } else {
	foreach i $fx_font_config(families) {
	    $fx_tmpfont_radiobutton(family,$i) configure -state normal
	}
    }
    if {[string compare $fx_tmpfont($widg,font) ""] == 0} {
	foreach i {size slant family weight} {
	    Fx:SetFontDefaultProperty $i
	}
    } else {
	set res [split [string range $fx_tmpfont($widg,font) 1 end] -]
	set fx_tmpfont(family) [lindex $res 1]
	if {[llength $fx_tmpfont(family)] == 0 || [string compare $fx_tmpfont(family) "*"] == 0} {
	    Fx:SetFontDefaultProperty family
	}
	set fx_tmpfont(weight) [lindex $res 2]
	if {[llength $fx_tmpfont(weight)] == 0 || [string compare $fx_tmpfont(weight) "*"] == 0} {
	    Fx:SetFontDefaultProperty weight
	}
	set fx_tmpfont(slant) [lindex $res 3]
	if {[llength $fx_tmpfont(slant)] == 0 || [string compare $fx_tmpfont(slant) "*"] == 0} {
	    Fx:SetFontDefaultProperty slant
	}
	set fx_tmpfont(size) [lindex $res 7]
	if {[llength $fx_tmpfont(size)] == 0 || [string compare $fx_tmpfont(size) "*"] == 0} {
	    Fx:SetFontDefaultProperty size
	}
    }
}
