proc gp_AboutBox {} {
    global gv_qddb_lib_dir gv_qddb_version

    if {[winfo exists .aboutBox]} {
	wm withdraw .aboutBox
	wm deiconify .aboutBox
	update idletasks
        return
    }
    toplevel .aboutBox
    wm title .aboutBox "About Qddb"
    wm geometry .aboutBox +70+0

    set x .aboutBox.buttons
    frame $x
    pack $x -side bottom -fill x
    button $x.ok -text "Ok" -command "destroy .aboutBox"
    pack $x.ok -fill x

    if {[string compare "[info commands pinfo]" ""] == 0} {
	label .aboutBox.qddb -bitmap @$gv_qddb_lib_dir/pixmaps/qddb.xbm
    } else {
	label .aboutBox.qddb -bitmap @$gv_qddb_lib_dir/pixmaps/qddb.xpm
    }
    pack .aboutBox.qddb -side top

    message .aboutBox.version -justify center -aspect 400 \
        -text "Quick and Dirty DataBase\nVersion ${gv_qddb_version}\n"
    pack .aboutBox.version -side top

    message .aboutBox.copyright -justify center -aspect 400 \
	-text "Copyright(c) 1993, 1994\nHerrin Software Development, Inc.\nAll rights reserved.\n" 
    pack .aboutBox.copyright -side top

    message .aboutBox.license -justify left -aspect 250 \
	-text "Qddb is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License Version 2 as published by the Free Software Foundation.  Qddb is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.  You should have received a copy of the GNU General Public License along with Qddb; see the file LICENSE.  If not, write to:\n\n    Herrin Software Development, Inc.\n    R&D Division\n    41 South Highland Ave.\n    Prestonsburg, KY  41653"
pack .aboutBox.license -side top

    message .aboutBox.subscription -justify left -aspect 250 \
	-text "Qddb subscriptions may be purchased for a yearly rate of \$75. Subscriptions include a printed manual, a diskette containing the software and numerous examples, and a newsletter for each new release of the software (up to 4/year).  Send your mailing address and check or money order(U.S. funds only please) payable to:\n\n    Herrin Software Development, Inc.\n    Qddb Subscriptions\n    41 South Highland Ave.\n    Prestonsburg, KY  41653\n\nProfits from subscriptions fund further Qddb development.  HSD also builds custom Qddb applications for a one-time consulting fee."
    pack .aboutBox.subscription -side top

}

