
proc gp_newinst {name} {
    global gv_view gv_tuple_changed gv_mode_variable gv_status_variable
    global gv_config gv_entryname gv_schema

    if {[string compare $gv_mode_variable "Search Mode"] == 0} {
        set gv_status_variable {You can't add instances in "Search Mode"}
        return
    }
    set newinst [qddb_instance new $gv_view $name]
    if {[info exists gv_config(conf,unsorted,$name)] && \
	    [string compare $gv_config(conf,unsorted,$name) "on"] == 0} {
	gp_selinst $name {Select the place to insert} tack_new
	set tmpinst [qddb_instance current $gv_view $name]
	qddb_instance move $gv_view $name $newinst $tmpinst
        set newinst $tmpinst
    }
    qddb_instance switch $gv_view $name $newinst
    focus $gv_entryname([lindex [qddb_schema leaves $gv_schema $name] 0])
    set gv_tuple_changed 1
}

proc gp_buildinst {name} {
    global gv_view

    set namelist [split $name "."]
    set len [llength $namelist]
    incr len -1
    set buildinst ""
    for {set i 0} {$i < $len} {incr i} {
        if {$i == 0} {
            set attr [lindex $namelist 0]
        } else {
            set attr [join [lrange $namelist 0 $i] "."]
        }
        set cur [qddb_instance current $gv_view $attr]
        if {[string compare $buildinst ""] != 0} {
            set buildinst [join [list $buildinst $cur] "."]
        } else {
            set buildinst $cur
        }
    }
    return [join [list $name $buildinst] ","]
}

proc gp_delinst {name} {
    global gv_view gv_mode_variable gv_status_variable

    if {[string compare $gv_mode_variable "Search Mode"] != 0} {
	set cur [qddb_instance current $gv_view $name]
	set max [qddb_instance maxnum $gv_view $name]
	if {$max > 1 || ![qddb_instance isempty $gv_view $name $cur]} {
	    qddb_instance remove $gv_view $name $cur
	} else {
	    set gv_status_variable "No instance to delete."
	}
    } else {
	set gv_status_variable "You can't delete an instance in \"Search Mode\""
    }
}

proc gp_selinst {name {instruct "Select an instance to view."} {tack "tack"}} {
    global gv_schema gv_tuple gv_mode_variable gv_status_variable gv_default_font
    global gv_tuple_changed gv_config gv_attr_vnames gv_config

    if {![info exists gv_config(conf,$name)]} {
        foreach i [lrange [qddb_schema leaves $gv_schema $name] 0 4] {
            lappend gv_config(conf,$name) ${i}:10
            lappend gv_config(conf,,$name) ${i}
        }
    } else {
        if {![info exists gv_config(conf,,$name)]} {
            foreach i $gv_config(conf,$name) {
                set l [split $i ":"]
                lappend gv_config(conf,,$name) [lindex $l 0]
            }
        }
    }
    if {[string compare $gv_mode_variable "Search Mode"] == 0} {
        set gv_status_variable {You must be in "Add Mode" or "Change Mode" to review instances}
        return
    }
    set old_changed $gv_tuple_changed
    set inst [gp_buildinst $name]
    if {![info exists gv_config(conf,unsorted,$name)]} {
	set gv_config(conf,unsorted,$name) off
    }
    if {[string compare $gv_config(conf,unsorted,$name) "on"] != 0} {
	if {[info exists gv_config(conf,sort,$name)]} {
	    if {![info exists gv_config(conf,ascendsort,$name)]} {
		set gv_config(conf,ascendsort,$name) $gv_config(conf,sort,$name)
	    }
	    set newrows [qddb_rows all -instance $inst \
			     -sortby $gv_config(conf,sort,$name) \
			     -ascending $gv_config(conf,ascendsort,$name) \
			     -attrs $gv_config(conf,,$name) \
			     -print $gv_config(conf,$name) $gv_tuple]
	} else {
	    if {![info exists gv_config(conf,ascendsort,$name)]} {
		set gv_config(conf,ascendsort,$name) $gv_config(conf,,$name)
	    }
	    set newrows [qddb_rows all -instance $inst \
			     -sortby $gv_config(conf,,$name) \
			     -ascending $gv_config(conf,ascendsort,$name) \
			     -attrs $gv_config(conf,,$name) \
			     -print $gv_config(conf,$name) $gv_tuple]
	}
    } else {
	    set newrows [qddb_rows all -instance $inst \
			     -attrs $gv_config(conf,,$name) \
			     -print $gv_config(conf,$name) $gv_tuple]
    }
    if {[info exists gv_config(conf,print,$name)]} {
        foreach i $newrows {
	    regsub -all "\n" [qddb_rows getval $gv_config(conf,print,$name) [lindex $i 0]] " " a
            lappend res $a
        }
        foreach i $gv_config(conf,print,$name) {
            lappend headers $gv_attr_vnames($i)
        }
        foreach i $gv_config(conf,print,$name) {
            set j [lsearch -glob $gv_config(conf,$name) "${i}*"]
            set sx [split [lindex $gv_config(conf,$name) $j] ":"]
            if {[llength $sx] > 1} {
                lappend widths [lindex $sx 1]
            } else {
                lappend widths 10
            }
        }
    } else {
        foreach i $newrows {
	    regsub -all "\n" [qddb_rows getval $gv_config(conf,,$name) [lindex $i 0]] " " a
            lappend res $a
        }
        foreach i $gv_config(conf,,$name) {
            lappend headers $gv_attr_vnames($i)
        }
        foreach i $gv_config(conf,$name) {
            set sx [split $i ":"]
            if {[llength $sx] > 1} {
                lappend widths [lindex $sx 1]
            } else {
                lappend widths 10
            }
        }
    }
    if {[llength $res] == 0} {
        set gv_status_variable "No instances found"
        return
    }
    if {![info exists headers]} {
	set gv_status_variable "No attributes selected for viewing"
	return
    }
    gp_disable .top
    catch [list destroy .s]
    if {![info exists gv_config(instgeom,$name)]} {
        set gv_config(instgeom,$name) +[expr [winfo width .] / 2]+[expr [winfo height .] / 2]
    }
    toplevel .s
    set gm [split $gv_config(instgeom,$name) "+"]
    wm geometry .s "+[lindex $gm 1]+[lindex $gm 2]"
    if {[info exists gv_attr_vnames($name)]} {
        wm title .s "\"$gv_attr_vnames($name)\" Instances"
    } else {
        wm title .s "\"$name\" Instances"
    }
    frame .s.f0
    pack .s.f0 -side top -expand on -fill x
    set x .s.f0
    menubutton $x.close -text "Close" -relief raised -bd 2  \
        -font "$gv_default_font" -underline 0
    pack $x.close -side left -anchor w
    checkbutton $x.tack -variable gv_config($tack,$name) -font $gv_default_font \
	-text Pin
    pack $x.tack -side left -anchor e
    menubutton $x.print -text "Print" -relief raised -bd 2  \
        -font "$gv_default_font" -underline 0
    pack $x.print -side right -anchor e

    if {[string compare [tk colormodel .] "monochrome"] == 0} {
        label .s.l -text $instruct -font $gv_default_font -relief raised
    } else {
        label .s.l -text $instruct -font $gv_default_font -fg red -relief raised
    }
    pack .s.l -side top -expand on -fill x

    set x .s
    frame $x.f
    pack $x.f -side top -expand on -fill both
    if {![info exists gv_config(conf,boxheight,$name)]} {
	set gv_config(conf,boxheight,$name) 10
    }
    set boxes [gp_def_listbox $x.f $headers $widths $gv_config(conf,boxheight,$name)]
    set numunits 0
    foreach i $res {
	incr numunits
        gp_append_listbox $x.f $i $widths
    }
    set wwid [wm geometry .s]
    set wwid [split [lindex [split $wwid "+"] 0] "x"]
    set wht  [lindex $wwid 1]
    set wwid [lindex $wwid 0]
    set numboxes 0
    set oldfocus [focus]
    grab .s
    foreach i $boxes {
	$i configure -geometry [lindex $widths $numboxes]x[gp_max $numunits $wht]
	incr numboxes
        bind $i <ButtonRelease-1> +[list gp_switchinst $newrows $name .s $x.f.f0.l0]
        bind $i <Return> [list gp_switchinst $newrows $name .s $x.f.f0.l0]
        $i select from 0
    }
    wm geometry .s ${wwid}x[gp_min $numunits ${wht}]
    focus $x.f.f0.l0
    gp_bind_menubutton .s.f0.close c $boxes "
        set gv_config(instgeom,$name) \[winfo geometry .s\]
        catch {destroy .s}
        update
        catch {tkwait window .s}
    "
    gp_bind_menubutton .s.f0.print p $boxes [list gp_print_boxes $headers $widths $res]
    wm minsize .s $wwid 1
    wm maxsize .s $wwid $numunits
    update idletasks
    bind .s <Configure> "
	set gv_config(conf,boxheight,$name) \
	    [lindex [split [lindex [split [wm geometry .s] +] 0] x] 1]
    "
    tkwait window .s
    focus $oldfocus
    grab release .s
    gp_enable .top
    update
    set gv_tuple_changed $old_changed
}

proc gp_switchinst {rows name w box} {
    global gv_view gv_tuple_changed gv_config

    set old_changed $gv_tuple_changed
    set cur [$box curselection]
    if {[info exists gv_config(tack,$name)] && $gv_config(tack,$name) == 0} {
        set gv_config(instgeom,$name) [winfo geometry $w]
        catch "destroy $w"
        update
        catch "tkwait $w"
    }
    set rowdesc [lindex [lindex $rows $cur] 0]
    qddb_view set $gv_view $rowdesc
    set gv_tuple_changed $old_changed
}    
