
/* qddb/Utils/gendbase.c
 *
 * Copyright (C) 1993, 1994 Herrin Software Development, Inc.
 * All rights reserved.
 *
 * This file is part of Qddb.
 *
 * Qddb is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License Version 2
 * as published by the Free Software Foundation.
 *
 * Qddb is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Qddb; see the file LICENSE.  If not, write to:
 *
 *	Herrin Software Development, Inc. 
 *	R&D Division
 *	41 South Highland Ave. 
 *	Prestonsburg, KY 41653 
 */

#include <stdio.h>
#include <sys/file.h>

char Buffer[250000];
char *Words[25000];
int  dictfd, dictsize, wordindex, i, j;
char *GetWord();

main()
{

    if ((dictfd=open("/usr/dict/words", O_RDONLY)) == -1) {
	perror("open");
	exit(1);
    }
    dictsize = SizeOfFile(dictfd);
    Read(dictfd, Buffer, dictsize);
    Words[0] = Buffer;
    for (i = 0, wordindex = 0; i < dictsize; i++) {
	if (Buffer[i] == '\n') {
	    if (i < dictsize-1) {
		wordindex++;
		Buffer[i] = '\0';
		Words[wordindex] =  &Buffer[i+1];
	    }
	}
    }
    wordindex++;
    srandom(time(0));
    printf("\n");
    for (i = 0; i < 10000; i++) {
	/* make a 8 attribute tuple with 4 words per attribute */
	printf("%%0 V %d\n", i);
	for (j = 0; j < 8; j++) {
	    printf("%%%d.1 %s %s %s %s\n", j+1, GetWord(),
		   GetWord(), GetWord(), GetWord());
	}	
	putchar('\n');
    }
    exit(0);
}

char *GetWord()
{
    return Words[random() % wordindex];
}
