
/* qddb/Utils/qconv.c
 * Convert readable qddb style records into the internal style qddb format. 
 *
 * Copyright (C) 1993, 1994 Herrin Software Development, Inc.
 * All rights reserved.
 *
 * This file is part of Qddb.
 *
 * Qddb is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License Version 2
 * as published by the Free Software Foundation.
 *
 * Qddb is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Qddb; see the file LICENSE.  If not, write to:
 *
 *	Herrin Software Development, Inc. 
 *	R&D Division
 *	41 South Highland Ave. 
 *	Prestonsburg, KY 41653 
 */

#include "Qddb.h"

main(argc, argv)
	int		argc;
	char		*argv[];
{
	FILE		*fp, *fopen();
	Schema		*ts;
	extern Schema	*CurrentSchema;
	Entry		entry;
	FILE		*fopen();
	int		i;
	InCoreEntry	*MyEntry, *CurrentInCoreEntryFile;

 	if (argc < 3)
		PANIC("Usage: qconv Infile Outfile");
	if (argc >= 3) {
		int	fd;

		fprintf(stdout, "Reading Schema....\n");
		CurrentSchemaName = "Schema";
		fp = fopen("Schema", "r");
		if (fp == NULL)
			PANIC("Cannot open Schema");
		fd = dup(fileno(stdin));
		fclose(stdin);
		dup(fileno(fp));
		fdopen(fileno(stdin), "r");
		SchemaParse();
		PrintSchema(CurrentSchema);
		fclose(stdin);
		dup(fd);
		fdopen(fileno(stdin), "r");
	}
	Qddb_Init();
	entry = (char **)Malloc(sizeof(char *)*20);
	for (i = 0; i < 20; i++) 
		entry[i] = Malloc(BUFSIZ);
	fprintf(stdout, "Converting readable to internal format\n");
	ConvertReadableToInternal(argv[1]);
	{ Entry	Extern=NULL;
	  int			i, fd;
	  
	  fd = Open(argv[2], O_WRONLY|O_CREAT, 0644);
	  if (fd == -1)
		  PANIC("cannot open output file");
	  fprintf(stderr, "Converting internal to external format\n");
	  for (i = 1; i <= CurrentInCoreFile[0].Number; i++) {
		Entry	tmp;
#ifdef DEBUG
fprintf(stderr, "Current number = %d\n", i);
fflush(stderr);
#endif

		Extern = NULL;
		CurrentInCoreFile[i].Children->SequenceNumber =
			CurrentInCoreFile[i].SequenceNumber;
		  ConvertInternalToExternal(CurrentInCoreFile[i].Children, 
					    &Extern);
		  WriteEntry(fd, Extern);
		  Write(fd, "\n", 1);
		  tmp = Extern;
		  while (*Extern != NULL)
			free(*Extern++);
		free(tmp);
	  }
#ifdef notdef
	  while (Extern != NULL && *Extern != NULL) {
		  printf("->%s\n", *Extern);
		  fflush(stderr);
		  Extern++;
	  }
#endif
        }
	exit(0);
}

PrintSchema(MySchema)
	Schema		*MySchema;
{
	Schema		*csp = MySchema;
	SchemaNode	*cnsp;
	int		i;

	for (i = 0; i < csp->NumberOfAttributes; i++)
		PrintSchemaNode(csp->Entries[i], 0);
}

PrintSchemaNode(MyNode, IndentLevel)
	SchemaNode	*MyNode;
	int		IndentLevel;
{
	int		i;
	char		*Tabs();

	printf("%s(name=%s,alias=%s,verbose=%s,asterik=%s)\n", Tabs(IndentLevel++), MyNode->Name, MyNode->Alias, MyNode->VerboseName,
	       MyNode->AsteriskPresent == True? "true":"false");
	if (MyNode->Children != NULL)
		PrintSchemaNode(MyNode->Children, IndentLevel);
	if (MyNode->Siblings != NULL)
		PrintSchemaNode(MyNode->Siblings, IndentLevel-1);
}


char *Tabs(Number)
	int		Number;
{
	int		i;
	static char	buf[BUFSIZ];
	
	if (Number == 0)
		return NULL;
	strcpy(buf, "\t");
	for (i = 1; i < Number; i++)
		strcat(buf, "\t");
	return buf;
}
	
PrintEntry(ThisEntry)
	InCoreEntry	*ThisEntry;
{
	int		i,j;
	static int	level = 0;
	char		tabs[1024];

	if (ThisEntry == NULL)
		return;
#ifdef DEBUG
	printf("ThisEntry[0].Number = %d\n", ThisEntry[0].Number);
#endif
	for (i = 1; i <= ThisEntry[0].Number; i++)
		if (ThisEntry[i].Name != NULL) {
			tabs[0] = '\0';
			for (j = 0; j < level; j++)
				strcat(tabs, "\t");
			printf("%s%s", tabs, ThisEntry[i].Name);
			fflush(stderr);
			if (ThisEntry[i].Buf != NULL)
				printf("=\"%s\"\n", ThisEntry[i].Buf);
			else
				printf("\n");
			fflush(stderr);
			if (ThisEntry[i].Children != NULL) {
#ifdef DEBUG
				printf("Children not NULL\n");
#endif
				level++;
				printf("%s(\n",tabs);
				fflush(stderr);
				PrintEntry(ThisEntry[i].Children);
				printf("%s)\n",tabs);
				level--;
			}
		} else {
			printf("else encountered\n");
		}
	return;
}








