
/* qddb/Utils/qdel.c
 *
 * Copyright (C) 1993, 1994 Herrin Software Development, Inc.
 * All rights reserved.
 *
 * This file is part of Qddb.
 *
 * Qddb is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License Version 2
 * as published by the Free Software Foundation.
 *
 * Qddb is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Qddb; see the file LICENSE.  If not, write to:
 *
 *	Herrin Software Development, Inc. 
 *	R&D Division
 *	41 South Highland Ave. 
 *	Prestonsburg, KY 41653 
 */

#include "Qddb.h"

void Usage()
{
    fprintf(stderr, "Usage: qdel RelationDirectory UniqueId\n");
    fprintf(stderr, "       qdel RelationDirectory -nr lownum|begin hinum|end [attr]\n");
    fprintf(stderr, "       qdel RelationDirectory -sr lowstr|begin histr|end [attr]\n");
    fprintf(stderr, "       qdel RelationDirectory -dr lowdate|begin hidate|end [attr]\n");
    fprintf(stderr, "       qdel RelationDirectory -n num [attr]\n");
    fprintf(stderr, "       qdel RelationDirectory -s str [attr]\n");
    fprintf(stderr, "       qdel RelationDirectory -r regexp [attr]\n");
    fprintf(stderr, "       qdel RelationDirectory -d date [attr]\n");
    fprintf(stderr, "NOTE: Dates are currently accepted only in the form MM/DD/YY.\n");
    fprintf(stderr, "      If you need more complicated deletion mechanisms, use qddb_wish.\n");
    fflush(stderr);
    exit(1);
}

void main(argc, argv)
    int			argc;
    char		*argv[];
{
    char		Relation[MAXFILENAMELEN], *rel, *attr = NULL;
    Schema		*schema;

    if (argc < 3 || argc > 6)
	Usage();
    Qddb_Init();
    rel = Qddb_FindRelation(argv[1]);
    strcpy(Relation, rel);
    schema = Qddb_InitSchema(Relation);
    if (schema == NULL) {
	if (qddb_errmsg != NULL) {
	    fprintf(stderr, "%s", qddb_errmsg);
	} else {
	    fprintf(stderr, "Unknown error '%d' while reading schema\n", qddb_errno);
	}
	fflush(stderr);
	exit(1);
    }
    if (isdigit(argv[2][0]))
	DeleteEntryByNumber(schema, (unsigned int)atoi(argv[2]));
    else if (argv[2][0] == '-') {
	Qddb_SearchArg	search_arg;
	KeyList		*list;
	size_t		n;

	/* Well, it was late one stormy night.... */
	if (argv[2][1] == 'n') {
	    if (argv[2][2] == 'r') {
		/* -nr (numeric range) */
		if (argc < 5 || argc > 6)
		    Usage();
		search_arg.Type = NUMERICRANGE;
		if (strcmp(argv[3], "begin") == 0) {
		    search_arg.LowerExists = False;
		} else {
		    search_arg.LowerExists = True;
		    search_arg.LowerNum = strtod(argv[3], NULL);
		}
		if (strcmp(argv[4], "end") == 0) {
		    search_arg.UpperExists = False;
		} else {
		    search_arg.UpperExists = True;
		    search_arg.UpperNum = strtod(argv[4], NULL);
		}
	    } else if (strlen(argv[2]) == 2) {
		/* -n (number) */
		if (argc < 4 || argc > 5)
		    Usage();
		search_arg.Type = NUMERIC;
		search_arg.Number = strtod(argv[3], NULL);
	    } else 
		Usage();
	} else if (argv[2][1] == 's') {
	    if (argv[2][2] == 'r') {
		/* -sr (string range) */
		if (argc < 5 || argc > 6)
		    Usage();
		search_arg.Type = ALPHARANGE;
		if (strcmp(argv[3], "begin") == 0) {
		    search_arg.LowerExists = False;
		} else {
		    search_arg.LowerExists = True;
		    search_arg.LowerStr = argv[3];
		}
		if (strcmp(argv[4], "end") == 0) {
		    search_arg.UpperExists = False;
		} else {
		    search_arg.UpperExists = True;
		    search_arg.UpperStr = argv[4];
		}
	    } else if (argv[2][2] == '\0') {
		/* -s (string) */
		if (argc < 4 || argc > 5)
		    Usage();
		search_arg.Type = ALPHA;
		search_arg.Alpha = argv[3];
	    } else
		Usage();
	} else if (argv[2][1] == 'r') {
	    /* -r (regular expression) */
	    if (argc != 4)
		Usage();
	    search_arg.Type = REGEXP_V8;
	    search_arg.Alpha = argv[3];
	} else if (argv[2][1] == 'd') {
	    if (argv[2][2] == 'r') {
		/* -dr (date range) */
		if (argc < 5 || argc > 6)
		    Usage();
		search_arg.Type = NUMERICRANGE;
		if (strcmp(argv[3], "begin") == 0) {
		    search_arg.LowerExists = False;
		} else {
		    search_arg.LowerExists = True;
		    search_arg.LowerNum = strtod(Qddb_DateStringToTime(argv[3]), NULL);
		}
		if (strcmp(argv[4], "end") == 0) {
		    search_arg.UpperExists = False;
		} else {
		    search_arg.UpperExists = True;
		    search_arg.UpperNum = strtod(Qddb_DateStringToTime(argv[4]), NULL);
		}
	    } else if (argv[2][2] == '\0') {
		/* -d (date) */
		if (argc < 4 || argc > 5)
		    Usage();
		search_arg.Type = ALPHA;
		search_arg.Alpha = Qddb_DateStringToTime(argv[3]);
	    } else
		Usage();
	} else
	    Usage();
	switch (strlen(argv[2])) {
	case 2:
	    if (argc == 5)
		attr = argv[4];
	    break;
	case 3:
	    if (argc == 6)
		attr = argv[5];
	    break;
	default:
	    Usage();
	}
	list = Qddb_Search(schema, &search_arg, &n, -1);
	if (attr != NULL)
	    list = Qddb_KeyListProcess(schema, list, attr,
				       QDDB_KEYLIST_PROC_PRUNE, 
				       QDDB_KEYLIST_FLAG_PRUNEBYATTR);
	list = Qddb_KeyListProcess(schema, list, NULL,
				   QDDB_KEYLIST_PROC_NULLOP, 
				   QDDB_KEYLIST_FLAG_DELDUP_SAMEENTRY);
	while (list != NULL) {
	    DeleteEntryByKeyList(schema, list);
	    list = list->next;
	}
    } else
	Usage();
    exit(0);
}
