
/* qddb/Utils/qstall.c
 *
 * Copyright (C) 1993, 1994 Herrin Software Development, Inc.
 * All rights reserved.
 *
 * This file is part of Qddb.
 *
 * Qddb is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License Version 2
 * as published by the Free Software Foundation.
 *
 * Qddb is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Qddb; see the file LICENSE.  If not, write to:
 *
 *	Herrin Software Development, Inc. 
 *	R&D Division
 *	41 South Highland Ave. 
 *	Prestonsburg, KY 41653 
 */

#include "Qddb.h"

static int CheckAgesAndSizes(ch)
    char	*ch;
{
    char	f1[MAXPATHLEN], f2[MAXPATHLEN];
    struct stat	s1, s2;

    strcpy(f1,ch);
    strcat(f1,"/Database");
    strcpy(f2,ch);
    strcat(f2,"/Database.key");
    if (stat(f1, &s1) == -1 || s1.st_size == 0)
	return -1;
    if (stat(f2, &s2) == -1 || s2.st_size == 0)
	return -1;
    if (s1.st_mtime > s2.st_mtime)
	return -1;
    return 0;
}

void main(argc, argv)
    int		argc;
    char	*argv[];
{
    char	RelationFN[MAXFILENAMELEN], HashFN[MAXFILENAMELEN], *rel;
    Schema	*ts;
    int		hash_fd, waitforlock = 0;

    if (argc < 2 || argc > 3) {
	fprintf(stderr, "Usage: %s [-wait] Relation\n", argv[0]);
	exit(1);
    }
    qddb_stabilizing = 1;
    Qddb_Init();
    if (strcmp(argv[1], "-wait") == 0) {
	waitforlock = 1;
	rel = Qddb_FindRelation(argv[2]);
    } else {
	rel = Qddb_FindRelation(argv[1]);
    }
    if (rel == NULL) {
	fprintf(stderr, "Cannot find relation, please set QDDBDIRS");
	exit(1);
    }
    strcpy(RelationFN, rel);
    ts = Qddb_InitSchema(RelationFN);
    if (ts == NULL) {
	if (qddb_errmsg != NULL) {
	    fprintf(stderr, "%s", qddb_errmsg);
	} else {
	    fprintf(stderr, "Unknown error '%d' while reading schema\n", qddb_errno);
	}
	fflush(stderr);
	exit(1);
    }
    strcpy(HashFN, rel);
    strcat(HashFN, "/HashTable");
    hash_fd = Open(HashFN, O_RDWR, 0);
    if (hash_fd == -1) {
	fprintf(stderr, "Cannot open %s for writing\n", HashFN);
	exit(1);
    }
    Close(ts->hashtable_fd);
    ts->hashtable_fd = hash_fd;
#if defined(RECORDLOCKING)
    if (waitforlock) {
	while (LockSection(hash_fd, F_WRLCK, (off_t)0, (off_t)0, True) == -1) {
	    perror("qstall: (error while waiting):");
	    sleep(1);
	}
    } else {
	if (LockSection(hash_fd, F_WRLCK, (off_t)0, (off_t)0, False) == -1) {
	    fprintf(stderr, "%s: Relation \"%s\" in use\n", argv[0], argv[1]);
	    exit(1);
	}
    }
#endif
    if (CheckAgesAndSizes(RelationFN) == -1) {
	Qddb_MakeKeys(ts);
    }
    Qddb_BuildDatabase(ts);
    Qddb_MakeKeys(ts);
    Qddb_MakeIndex(ts);
#if defined(DEBUG_MALLOC)
    malloc_shutdown();
#endif
    exit(0);
}
