#
# Bindings for Commandeth
#

set Bindings(Cmd) {
  {Print  	 	{th_cmd_exec_prompt %W "Print Command:" Print}}
  {Mail   		{th_cmd_exec_prompt %W "Mail Command:" Mail}}
  {Use_Input  	 	{th_checkbutton_variable Cmd,Input,%W}}
  {Use_Output  		{th_checkbutton_variable Cmd,Output,%W}}
  {Wish_Command  	{th_cmd_wish_prompt %W}}
  {Exec_Command  	{th_cmd_exec_prompt %W}}
}


# th_bind.tcl needs this to set up the Function menu and Key label.
set Local_Bindings {Print Mail Use_Input Use_Output Wish_Command Exec_Command
  OK Cancel}


set TH_Bindings_Help {
Command Functions

There are two types of command execution possible, wish and exec commands, plus
a few exec commands.

The command Meta-Control-w brings up a prompt for a wish command. Once
confirmed, the command is executed as a wish command at the global level, and
output is handled accordingly: If no errors occurred, the widget can be inserted
into (ie it is not disabled), and output to the widget is turned on (see below
for details), the output (if any) is inserted into the widget. If there is
output, but the output for the widget is not specified, or an error occurred,
the output is placed in a Tk error dialog box.

A variation on the wish-command is the exec-command. The command Meta-Control-e
brings up a prompt for a command which, once confirmed, gets passed to Tcl's
exec command (see the exec(n) manpage for details of exec's syntax). The exec
command takes syntax much like a normal shell, it allows pipelines, stream
redirection, and background processing.

By prepending the command with a |, one indicates that the selected region of
text in the widget (or all the text if none is selected) should be fed in to the
standard input. Similarly, appending a | to the command indicates that output is
to be added to the widget at the location of the cursor. If a | is appended to
the command, then stdout and stderr get piped out to the widget at the insert
cursor. The wish command does not take standard input, but you can direct output
to the widget by appending a | to the command.

There are two menu options that assist in the syntax of wish and exec commands.
They control when I/O can occur between the widget and wish/exec commands. The
"Get Input" option is similar to prepending exec commands with a |, it sends the
contents of the widget, or the selected region, to the exec command's standard
input. And the "Send Output" option is similar to appending exec and wish
commands with a |, it sends the output of the wish or exec command back to the
widget at the insert cursor. Thus these checkbuttons replace the artificial
syntax of prepending or appending wish and exec commands with |'s.

Cmd:	Wish:	Meta-Control-w
 	Exec:	Meta-Control-e

There are several commands which merely pass predefined commands to
exec-command. The print command, Meta-Control-p, is an example of a command that
uses input from the text. If a region is selected in the text, that region alone
is printed. If no text is selected, the text in its entirity is printed. The
other possible command is Meta-Control-a, which mails the selected, or entire
body of text to an address to be specified on the prompt.

Cmd:	Print:	Meta-Control-p
	Mail:	Meta-Control-a
}


