#
# Bindings for Completh
#

set Bindings(Completion) {
  {Complete_Word 	{if {![th_[winfo class %W]_complete_multiple %W %COMP]} {catch {th_[winfo class %W]_self_insert %W %A}}}}
  {Show_Completions 	{th_[winfo class %W]_completion_dialog %W}}
}

# th_bind.tcl needs this to set up the Function menu and Key label.
set Local_Bindings {Complete_Word Show_Completions}


set TH_Bindings_Help {
Completion Functions

The bindings here are very simple. Pressing Tab in a widget will attempt to
complete the text immediately before the cursor. For most routines, the program 
will beep if no completion is possible or ambiguous completions exist. For
others, the program will still beep if no completion is possible, but if
multiple completions are possible, each one is brought up in turn. When more
than one completion is possible, then one can press Control-Tab to see the
possible completions. This is presented as a dialog window with a listbox, so
you can select "OK" by pressing the <1> or <Return> key. Or you can select a
completion by double-clicking on that particular list entry, which gets used as
the chosen completion, and placed in the widget.

Complete String:	Tab
Possible Completions:	Control-Tab
}


