#
# Bindings for Fileth
#

set Bindings(File,Read) {
  {Read_File 		{th_read_file %W}}
  {Read_File_Prompt	{th_read_file_prompt %W}}
  {Insert_File 		{th_insert_file %W}}
}
set Bindings(File,Write) {
  {Save_File 		{th_save_file %W}}
  {Save_File_Prompt	{th_save_file_prompt %W}}
}
set Bindings(File,Pipe) {
  {Use_Pipe 		{th_checkbutton_variable Pipe}}
}
set Bindings(File,Mtime) {
  {Check_Mtime 		{th_check_mtime %W}}
}


# th_bind.tcl needs this to set up the Function menu and Key label.
set Local_Bindings {Read_File Read_File_Prompt Save_File Save_File_Prompt
	Insert_File Check_Mtime Use_Pipe OK Cancel}


set TH_Bindings_Help {
File Functions

These are simple commands to provide I/O access to files. When this module is
loaded, a widget's contents can be saved to a file, or read from a file (for
text and entry widgets only). Generally the format used depends on the widget.
Text and entry widgets store their complete text output out to the file, adding
a newline at the end if necessary. Listboxes put each of their items on a single
line, so that the file contains each element of the listbox in order. Canvases
make use of Tk's canvas postscript command.

To save the current file, use Meta-s. Meta-s will not prompt for a filename if
one is already associated with the widget (through a previous save or read), and
it is writable. If you want to specify a filename, use Meta-S.

Meta-R reads in a new file, specified by the user. Meta-r is similar, but it
'reverts' to the old file, it reads the old file without prompting (of course,
if the current buffer is modified, it will require confirmation.) Both Meta-r
and Meta-R erase the old contents of the text buffer.

To read a file without destroying the text contents, use Meta-Control-i. It
inserts the contents of the (to-be) specified file before the insert cursor. If
edith's code is known to the application, then this insert operation can be
undone.

			Prompt
File:	save:	Meta-s	Meta-S
	read:	Meta-R	Meta-r
	insert:		Meta-Control-i

In addition to normal files, you can specify a command pipeline for input or
output, as accepted by Tcl's open command (see the manpage on open(n) for
details on open's syntax). To use a pipeline for I/O, simply enter the command,
prepending it with a |. Specifying a command pipeline for writing will send the
entirety of the text widget to the pipeline; specifying a command pipeline for
reading will enter the output of the pipeline into the text widget. Any errors
generated from the pipeline will appear in a Tk error window. (Keep in mind that
many commands like diff send their output to stderr, so they will generate an
error message, even if the command does the Right Thing.). If you want the error
message to get inserted into the text widget along with the output (such as in a
terminal), append a "|& cat" to your command, which will merely pipe stdout and
stderr of your original command through cat.

All of these options are available from the File menu. The File menu also
contains a checkbutton entries to cover the artificial syntax of pipe I/O. If
the 'Use a Pipe' checkbutton is on, the file is assumed to be a pipe to be
written to or read from. 
}

