#
# Bindings for Elsbeth
#

set Bindings(Elsbeth) {
  {Switch_Buffer 	{elsbeth_switch_buffer %W}}
  {All_Shown	 	{elsbeth_focus_all %W}}
  {All_Windows 	 	{elsbeth_focus_all %W 1}}
  {Show_X 		{elsbeth_goto_file X}}
  {Help 		{elsbeth_help}}
  {Make 		{elsbeth_make %W}}
  {Move_Below_Last      {elsbeth_move_below_last %W}}
  {Gradual_Output 	{th_checkbutton_variable Gradual}}
  {Visit_File 	 	{elsbeth_visit_file %W}}
  {Quit 		{elsbeth_destroy_text %W}}
  {Add_Para_Module 	{elsbeth_add_module paragrath %W}}
  {Add_Tcl_Module  	{elsbeth_add_module tclth %W}}
  {Add_C_Module  	{elsbeth_add_module cth %W}}
  {Add_Lisp_Module  	{elsbeth_add_module lispth %W}}
  {Add_HTML_Module  	{elsbeth_add_module htmlth %W}}
  {Add_Error_Module  	{elsbeth_add_module errorth %W}}
}

set Bindings(Elsbeth,Misc) {Focus_Entries
	{if {[catch {focus [th_next_widget %W Entry]}]} {focus %W}}}
set Bindings(Elsbeth,Entry) {Focus_Entries
	{if {[catch {focus [th_next_widget %W]}]} {focus [th_previous_widget %W %C]}}}


# th_bind.tcl needs this to set up the Function menu and Key label.
set Local_Bindings {Focus_Entries Gradual_Output Switch_Buffer All_Shown
	All_Windows Visit_File Help Show_X Make Quit Move_Below_Last
	Add_Para_Module Add_Tcl_Module Add_C_Module
	Add_Lisp_Module	Add_HTML_Module Add_Error_Module}


set TH_Bindings_Help {
General Elsbeth Functions

Elsbeth adds a few functions to the functions available in the hypertools.
Generally these functions deal with the multiple windows of text it brings up,
since this is a particularly idiosyncratic feature of Elsbeth.

You can, of course, focus between text widgets using Control-n and Control-p,
as focuth supplies those bindings. You can also switch between a text widget
and it's auxiliary entry widgets using Escape. You can also specify a buffer to
focus to using Meta-Control-b, just enter the window title of the window to
focus to.

Focus: Entries: Escape
Focus: Specify: Meta-Control-b

Elsbeth also allows you to add new windows on files and remove them as well.
Pressing Meta-Control-v 'visits' a file; that is, it brings up a new window on
a file, or if Elsbeth is already examining that file, focuses on the window
containing that file. And you can remove a window by pressing Meta-q on a
window to quit viewing that window. Elsbeth quits when all windows are closed.

File: 	Visit: 	Meta-Control-v
	Quit:	Meta-q.

There are three commands that visit a file, that is, they open a new window on
a file, or find an old one and focus on that. The Meta-Control-x function
brings up a window on the X selection; this is useful for viewing a file in two
separate windows. The Meta-Control-m function provides a simple 'make' utility,
it allows you to view the output of a make command. You can alter the make
command to do something like 'make install' and it will remember your changes,
and bring up a window on your make command. Finally pressing Meta-Control-h
brings up a window on Elsbeth's help file, (which includes this text).

Visit X:	Meta-Control-x
Make: 		Meta-Control-m
Help: 		Meta-Control-h

Since Els allows files to be read in gradually, Elsbeth adds a menu checkbutton
to support greadual reading. You can use it either by turning on the
checkbutton, or appending a & to your pipe commands (gradual reading does not
work with files). You can interrupt gradual reading with Control-g.

Elsbeth also provides several handy file routines not supported by fileth (due
to the nature of Els). First of all, it will complain if you try to edit the
same file in two windows, and you can change the contents of one window, or
close either one. Elsbeth also updates the title and icon name of each window
with the file it is currently viewing.

There is also one window command, you can move one window below another. Using
this command several times, you can stack multiple text windows nicely together
on your screen. The Meta-m key puts the current window immediately below
another shown window (if there is one).
Move below: 	Meta-m

Elsbeth also provides a function to send keybindings to all the elsbeth windows
in the current interpreter, or just all the shown ones, so pressing a single
key in one window executes the appropriate function in each elsbeth window
(Keep in mind that each window may have a different function associated to a
key, for example, sending Control-A might might go to the beginning of a
procedure, paragraph, or HTML anchor, depending on what is displayed in the
window. There are two bindings to this 'all' function: Meta-k, which elects to
send the next key to all windows that are not currently iconified, and Meta-K
which sends the next key to all windows. When Meta-k or Meta-K is pressed, an
entry marked "All" is pressed to indicate the next key is going to many
windows. Once the key is pressed, the 'all' mode terminates.

All:		Meta-K
	Shown:	Meta-k

Pressing Meta-k while already in 'All' mode causes 'All' mode to become
permanent, in which case every keybinding is sent to each window, until the
next occurrence of Meta-k. Some example sequences are: "Meta-K Meta-s" saves
every window's contents, "Meta-k Meta-<" goes to the beginning of each window's
contents, "Meta-k Meta-I" iconifies each deiconified window, "Meta-k Meta-k C-s
foo" brings up the next instance of "foo" in every shown window, and "Meta-K
Meta-q" causes each window to quit, thereby closing down that elsbeth
interpreter.

During All mode the cursor will stay in the All entry, however the old focus
will be remembered, and keybindings will be sent to the old focus, as well as
any other windows involved. If the cursor should fall out of the All entry,
then keys will not execute in all windows, however, pressing Escape will bring
the cursor back into the All entry and things should work properly.

You can have more than one window in All mode, however any keybinding executed
in All mode destroys All mode for each window except the one the keybinding
originated in.

Elsbeth adds completion bindings for the entries appropriately. Most entries
can complete Tcl commands, variables, or files, as well as give the results of
Tcl commands, variables, and glob patterns. Generally, the entry will do
completion based on its purpose, for example, the file entry completes a full
filename, and the search entry completes a word in the text. The text also
completes a word in itself.

Elsbeth also extends the marks added by marketh. It remembers all marks made to
a file, and will include those marks the next time you view that file. It does
this by storing all the marks in the file $HOME/.th/elsbeth.marks. If you use
marks heavily, you should periodically clean out this file. One way would be to
bring up all the files with marks you want preserved, and then delete
elsbeth.marks, and then quit elsbeth, which will then re-create elsbeth.marks
with the preserved marks. Elsbeth will only save marks if the $HOME/.th
directory exists.

Finally Elsbeth also adds a menu called "Modules". This shows some optional
modules that aren't loaded upon startup, but can be added later. The module is
the name of the hypertool that would teach the bindings. For example paragrath
indicates the paragrath hypertool which teaches bindings about paragraph
manipulation.

One can also load a module during startup. To give the newest window the
paragraph bindings, for instance, one could issue the command: (The -c option
is interpreted by els to execute the following Tcl command.)
elsbeth -c "elsbeth_add_module paragrath" ...

Some modules may be loaded automatically upon startup due to the file name. For
example, the paragrath module will be added automatically on any filename with
the ending ".txt". The modules are described below:
}


