#
# Bindings for Parenth
#

set Bindings(Paren) {
  {Goto_Exp_Left 	{th_Misc_paren_prompt %W th_Misc_goto_left_exp %W}}
  {Goto_Exp_Right 	{th_Misc_paren_prompt %W th_Misc_goto_right_exp %W}}
  {Select_Exp 	 	{th_Misc_paren_prompt %W th_Misc_select_exp %W}}
  {Delete_Exp_Backward  {th_Misc_paren_prompt %W th_Misc_delete_left_exp %W}}
  {Delete_Exp_Forward  	{th_Misc_paren_prompt %W th_Misc_delete_right_exp %W}}
  {Kill_Exp 		{th_Misc_paren_prompt %W th_Misc_kill_exp %W}}
  {Exp_Paren  		{th_Misc_paren_reeval %W}}
  {Exp_Bracket 		{th_Misc_paren_reeval %W}}
  {Exp_Brace  		{th_Misc_paren_reeval %W}}
  {Exp_Angle  		{th_Misc_paren_reeval %W}}
  {Check_Paren 		{th_Misc_check_exp %W $TH(Paren,Paren)}}
  {Check_Bracket	{th_Misc_check_exp %W $TH(Paren,Bracket)}}
  {Check_Brace 		{th_Misc_check_exp %W $TH(Paren,Brace)}}
  {Check_Angle 		{th_Misc_check_exp %W $TH(Paren,Angle)}}
}

# th_bind.tcl needs this to set up the Function menu and Key label.
set Local_Bindings {Goto_Exp_Left Goto_Exp_Right Select_Exp Delete_Exp_Backward
 	Delete_Exp_Forward Kill_Exp Exp_Paren Exp_Bracket Exp_Brace Exp_Angle
	Check_Paren Check_Bracket Check_Brace Check_Angle}

set TH_Bindings_Help {
Paren Functions

These functions help you balance your parentheses, square brackets, angle
brackets, and braces. (We will refer to these sets as parens.) When you hit a
close paren (that is, a closed parentheses, bracket, brace, or the greater-than
sign), the program checks for the existance of a matching open paren, ignoring
any intermediate close/open paren pairs in-between. The program will point out
the matching open paren, or flash a message if none exists. It also can check to
see if a lone open or close paren exists of a different type. For example, the
sequence "([)]" has matching open and close brackets and parentheses, but they
interlock, which is usually not the desired effect (for example, it is not good
C syntax). The program will warn you of situations like this. One can check for
an open paren merely by hitting a close paren key, which also inserts the close
paren key, or one can use the "Check" submenu under the "Extras" menu, and check
one of parentheses, brackets, braces, or angle brackets, without inserting the
appropriate closed paren.

Sometimes you want checking disabled for some kind of paren. For example, for
most C and Tcl code, you will not want angle bracket checking, since these also
double as greater-than and less-than signs, and they do not balance each other.
They do balance each other, and serve as delimiters, in HTML files, though.
Under the Expressions submenu under the Expressions menu is a list of
checkbuttons signifying which parens are checked and which arent. IF, for
example, angle brackets are not checked under the Espressions menu, then no
checking is done for matching open and close angle-brackets, and lone ones are
not reported.

One can select the innermost paren expression that contains the cursor with
Meta-J. Meta-A moves to the beginning of the innermost expression, and Meta-E
the end. If only one set of parens is checked, that set is automatically used.
If more than one set is chosen (such as parenthesess, square brackets, and
braces), the program will prompt you to enter the delimiter being checked, and
here you can enter a closed or open parenthesis, bracket, or brace to indicate
that set of parens.

				 Meta-
Expression:	Traversal:	 A + E
		Select:		   J

Meta-D deletes from the cursor to the end of the expression, and Meta-H deletes
from cursor to beginning of the expression. Neither can be yanked, but both are
undoable. Finally, Meta-U kills the current expression, and it can be yanked,
though not undone. As in the above functions, these prompt for which paren set
to use if more than one is checked.

				 Meta-
Expression:	Delete:		 H + D
		Kill:		   U
}


