#
# Bindings for Searcheth
#

set Bindings(Search) {
  {Search_Forward 	{th_Misc_search %W forward string}}
  {Search_Backward 	{th_Misc_search %W backward string}}
  {Search_Forward_Glob 	{th_Misc_search %W forward glob}}
  {Search_Backward_Glob	{th_Misc_search %W backward glob}}
  {Search_Forward_Regexp {th_Misc_search %W forward regexp}}
  {Search_Backward_Regexp {th_Misc_search %W backward regexp}}
  {Toggle_Case_Sensitivity {th_checkbutton_variable Search,Case,%W}}
  {Toggle_Incremental_Search {th_toggle_incremental_search %W}}
}


# th_bind.tcl needs this to set up the Function menu and Key label.
set Local_Bindings {Search_Forward Search_Backward Search_Forward_Glob
    Search_Backward_Glob Search_Forward_Regexp Search_Backward_Regexp
    Toggle_Case_Sensitivity Toggle_Incremental_Search OK Cancel}


set TH_Bindings_Help {
Search Functions

These functions allow you to perform searches for strings, regular expressions,
or glob patterns in text, listbox, or entry widgets. It provides an incremental
search option, as well as case sensitivity on or off, and can search forward or
backward through the text, starting from the cursor.

To search forward for a string, enter Control-s. Control-r is similar, except it
searches backwards for a string. For glob patterns, use Control-S and Control-R,
and for regular expressions, use Meta-Control-S and Meta-Control-R. The Find key
can be used to perform the same functions.

	Forward                          Reverse
String: Control-s      Find              Control-r      Shift-Find
Glob: 	Control-S      Meta-Find         Control-R      Shift-Meta-Find
Regexp: Meta-Control-s Control-Meta-Find Meta-Control-r Shift-Control-Meta-Find

Once the search entry is open, you can enter a search string (or glob pattern or
regular expression). To actually execute the search while in the entry, press
Control-s or Control-r to search backward. You can continue searching forward or
backward as many times as you want. If a search fails, trying another search in
the same direction will start from the beginning of the text (or the end for
reverse searching). You can exit searching using Return or Control-g.

Search:	Again:	Forward:	Control-s Find
		Reverse:	Control-r Shift-Find
	Exit:			Return    Control-g

Normally, searching is case sensitive, but you can alter this using
Meta-Control-c. Searches performed after that convert the search text to
lowercase before searching. Pressing Meta-Control-c renders searches case
sensitive again.

Normally a search doesn't occur until you press Control-s or Control-r in the
search entry. However, you can make searching incremental by pressing
Meta-Control-n during a search. Henceforth, every keystroke you make in the
entry widget will perpetuate a search. This is very useful for entering search
strings correctly.

Toggle Case Sensitivity:   Meta-Control-c
Toggle Incremental Search: Meta-Control-n

For text widgets, there is one last function. In a text widget, Any text that
was matched to the search string gets highlighted, but only after it's been the
search tag. If you press Meta-Control-h in the search entry, then all future
matches (in the direction you are searching) get highlighted. All matches stay
highlighted until you exit the search function.
Highlight Searches: 	   Meta-Control-h

If you are using the replace features, then two more functions are added to the
search entry. They are Control-c and Control-C, and both serve to set up the
replace facility. They do this by adding a 'replace' entry, in which you specify
the string to change to. The replace entry takes the same bindings as the search
entry, but Control-c and Control-C are different. In the replace entry, pressing
Control-c changes the currently found match of the search string with the
replacement string (if there is a match), and finds the next occurrence of the
search string. You can alternate Control-c and Control-s to change or skip
successive search strings. Finally, you can use Control-C to replace every
future occurrence of the search string with the replacement string. Control-C
also closes the replacement features, as do Control-g and Return.

Replace: One: 		   Control-c
Replace: All:		   Control-C
}


