#!/afs/ece/usr/tcl/bin/wish -f
#
# Shared mail routines

proc tag_section {w heading tag} {
  global body_start
  set start [string first "$heading:" [$w get 1.0 "1.0 lineend"]]
  if {($start != 0)} {
    set start [string first "\n$heading:" [$w get 1.0 $body_start]]
    if {($start < 0)} {return}
    incr start
  }
  set startindex [$w index "1.0 +$start chars"]
  set end [string first ": " [$w get "$startindex lineend" $body_start]]
  if {($end == -1)} {
    set endindex [$w index "$startindex lineend"]
  } else {set endindex [$w index "$startindex lineend +$end chars linestart"]
  }

  $w tag add $tag $startindex $endindex
  $w tag add important $startindex $endindex
  $w tag add protect $startindex "$startindex + [string length $heading] \
           chars + 1 chars"
}

proc add_section_tags {w} {
  global section_tags body_start
  set body [string first "\n\n" [$w get 1.0 end]]
  if {($body == -1)} {set body_start end
  } else {set body_start [$w index "1.0 +$body chars"]}
  foreach tag $section_tags {tag_section $w $tag $tag}
}

set mail_dir "$env(HOME)/Mail"

set section_tags {}

set section_tags [lappend $section_tags To From Date Subject Cc cc]
after 200 {
$w tag configure To -foreground LightGoldenrod
$w tag configure CC -foreground LightGoldenrod
$w tag configure Cc -foreground LightGoldenrod
$w tag configure cc -foreground LightGoldenrod
$w tag configure From -foreground PaleGreen
$w tag configure Date -foreground Cyan
$w tag configure Subject -foreground pink
}


