# Basic routimes for Teacher Hypertools

set TH_Copyright {Teacher Hypertools: Copyright (c) 1994  David Svoboda}


# Returns value of variable, looking up env_var as an environment variable,
# using default if var and env(env_var) don't exist.
proc setenv {var env_var {default ""}} {
  if {[info globals $var] == ""} {
    global $var env
    if {[catch {set $var $env($env_var)}]} {
      set $var $default
  }}
  return $var
}

proc source_local_files {} {
  global env
  set name [lindex [wm title .] 0]
  if {[file exists $env(HOME)/.th/$name]} {
    source $env(HOME)/.th/$name
  }
  if {[file exists ".$name"]} {
    source ".$name"
}}

# The location of TH's library. (You could instead set your TH_DIR
# environment variable)
setenv TH_Dir TH_DIR "[file dirname [info script]]/.."

source_local_files

# The location of XF (for some of its template procedures)
setenv XF_Dir XF_DIR "/afs/ece/usr/tcl/xf2.3"

# Which set of bindings to use?
setenv TH_Bindings_Set TH_BINDINGS "th"

source $TH_Dir/aux/teach_widgets.tcl

# Help text.
set TH_Help "" ; append TH_Help {
Help Button

Wlll, you're seeing what it does. :) The menubutton was created using taggeth;
it is useful for going to any header in the help file. Or you can go to the
selected text, if any is selected. Hit the OK button above this widget to exit
Help.


Quit Button

Quits the program. Can be used anytime, even while you are teaching things to
other widgets.


The output Text

This space is filled with either:
1. Error message from invalid command.
2. Informative output from query-type command, like "pack info"
3. Complete command executed if successful. (This is the command that was
   executed in the remote interpreter.)


Source Menu

This menu simply provides three ways to transmit code to remote programs; unless
you are interested in somehow adding said code to the program, you need not
worry about this menu. On some hypertools, which don't teach code (such as
configureth), this menu may not exist. It has three options:

Include file: This merely teaches the program the code necessary to do this
hypertool's functions; it teaches the program nothing about where this code came
from. This is the default.

Source Command: Instead of giving the remote program the code, give the prgram
the necessary 'source' commands needed to load the code itself.

Add to auto_path: Instead of giving the remote program some files to load or
some code, add the directory of the code to the program's auto_path variable.
This will automatically load the procedures the program needs whenever it
invokes them.


Configuration Files

Before starting up, this program calls the local file of the same name as this
program itself, preceded by a '.', if this file exists. (In other words, if this
program were called 'foo', it would source '.foo'.) It then looks for a file in
$HOME/.th by the same name as the program. (So in our aforementioned example, it
would search for $HOME/.th/foo). This way you can customize any aspect of these
programs you so choose.


Command-line Arguments

This hypertool fills its widgets with the command-line arguments, generally in
order of top-to-bottom, and left-to-right. So if the top widget is an entry, the
first argument to the program will override the default value for that entry.
Generally entries accept strings for arguments, scales prefer numbers, and
checkbuttons prefer values of 1 (for on) and 0 (for off).


} $TH_Copyright {

Permission to use, copy, modify, and distribute this software is hereby granted,
provided that the above copyright line appears at least once in source code
taught by Teacher Hypertools, and in documentation relating to said code.
However, permission is not granted to modify the copyright insertion code.

This basically means: if a Teacher Hypertool sticks a copyright message in code
it teaches, and you copy that code to a file, leave the copyright message in.
And include it in your documentation. If it doesn't stick a copyright in code,
don't worry about it. Go ahead and fiddle around with the Teacher Hypertool
source code, and improve it (and drop me a line if you do, I'd be interested),
but don't change the code that inserts copyright notices.


Disclaimer

I don't see how its possible, but if this software crashes your system, destroys
your hard disk, posts to alt.flame asking for mail-bombs, etc. etc, I didn't do
it, man. :)


Author

David Svoboda
(svoboda@ece.cmu.edu)
}

# Grabs widget so buttonpresses to other widgets get caught by this program.
# If already grabbed, releases grab.
proc toggle_grab {} {
  if {[grab current] == ""} {
    grab -global .buttons
    . config -cursor cross
    return
  }

  grab release .buttons
  . config -cursor ""
  bind all <Any-Motion> ""
  global Teach_Active ; set Teach_Active 0
}


# Given x and y, and b (button#) from a buttonpress event, fills widget_var and
# app_var and class_var with the topmost widget, application, and class in which
# the button was pressed. (See program comments for how widget group is selectd)
proc which_widget {x y b app_var widget_var} {
  upvar $app_var app $widget_var widget
  set widget ""
  foreach app [winfo interps] {
    if {[catch {send $app winfo containing $x $y} widget]} {continue}
    if {($widget != "") && [send $app winfo ismapped $widget]} { break }
    set widget ""
  }
  if {($app == [winfo name .]) && ($widget == ".buttons.teach")} { return 0 }
  if {($widget == "") || ([string index $widget 0] != ".")} { return 0 }

  while {$b != 1} {
    incr b -1
    set widget [send $app winfo parent $widget]
  }
  return 1
}

# Execute cmd in application, puts output or error in Output. If no output, puts
# cmd in Output. (All successful configure or option cmds yield no output)
proc do_cmd {app cmd {clear_text 1}} {
  global Output
  if {![catch {send $app $cmd} Output]} {
    if {($Output == "") || ([lindex $cmd 0] == "set")} {
      set Output $cmd
  }}
  show_output $clear_text
}

proc show_output {{clear_text 1}} {
   global Output
  .output configure -state normal
  if $clear_text {.output delete 1.0 end}
  .output insert end $Output
  .output configure -state disabled
}

proc clear_output {} {
  .output configure -state normal
  .output delete 1.0 end
  .output configure -state disabled
}  

# Returns the contents of file
proc return_source {file} {
  set f [open $file "r"]
  set result [read $f]
  close $f
  return $result
}

# Returns code app needs to know, code is the contents of file.
# If proc is nonempty, and app knows proc, it is assumed app knows code.
proc code_to_teach_app {app file {proc ""}} {
  global TH_Dir

  if {$proc != ""} {
    if {[send $app info proc $proc] != ""} {return ""}}
  if {[send $app lsearch \$auto_path "/*th/lib"] >= 0} {return ""}

  global TH_Copyright
  set result ""
  if {[catch {send $app set TH(Copyright)}]} {
    set result "set TH(Copyright) \{$TH_Copyright\}\n"
  }

  global Source_Type
  switch $Source_Type {
    "Include" {return [append result [return_source $file]]
    } "Source" {return "source $file\n"
    } "Autopath" {return "set auto_path \"$TH_Dir/lib \$auto_path\"\n"
}}}

proc include_files {app args} {
  global TH_Dir
  foreach arg $args {
    do_cmd $app [code_to_teach_app $app "$TH_Dir/lib/[lindex $arg 0]" \
	[lindex $arg 1]] 0
}}

proc get_th_fullpath {} {
  global TH_Dir
  if {[string match "/*" $TH_Dir]} {return}
  set pwd [pwd]
  cd $TH_Dir
  set TH_Dir [pwd]
  cd $pwd
  return
}

# Set up main window.
wm minsize . 1 1
set iconname [lindex [wm title .] 0]
get_th_fullpath
set title [string toupper [string index $iconname 0]]
append title [string range $iconname 1 end]
wm title . $title
wm iconname . $iconname
set auto_path "$TH_Dir/lib $auto_path"

if {![catch "frame .buttons"]} {
  pack .buttons -side bottom -in . -fill x -expand no
  checkbutton .buttons.teach -text "Teach" -command {toggle_grab} -variable Teach_Active
  pack .buttons.teach -side left -expand yes -fill x
  button .buttons.help -text "Help" -command show_help
  pack .buttons.help -side left -expand yes -fill x
  button .buttons.quit -text "Quit" -command exit
  pack .buttons.quit -side left -expand yes -fill x
  text .output -state disabled -height 3 -width 40 -wrap char
  pack .output -side bottom -expand yes -fill both
}

if {![catch "menubutton .buttons.source"]} {
  .buttons.source configure -menu .buttons.source.m -text "Source"
  menu .buttons.source.m
  pack .buttons.source -side right
  set Source_Type "Include"
  .buttons.source.m add radiobutton -label "Include file" \
    -variable Source_Type -value Include
  .buttons.source.m add radiobutton -label "Source Command" \
    -variable Source_Type -value Source -command get_th_fullpath
  .buttons.source.m add radiobutton -label "Add to auto_path" \
    -variable Source_Type -value Autopath -command get_th_fullpath
}


