#
# Standard module for teaching codebindings. (Most hypertools will use this
# some will use other models.
#

source "[file dirname [info script]]/../aux/bind.tcl"

# Help text.
set TH_Teach_Bind_Help "" ; append TH_Teach_Bind_Help {
The Teach Checkbutton

This button allows you to teach a remote widget to use the keybindings taught in
this hypertool, or to use the menus provided by this hypertool. AFter clicking
on this button, you click on a remote widget in any Tk application, and this
program teaches that widget how to manage the window containing it. After
teachinng a remote widget, you can teach other widgets until you click outside
any Tk application, or click again on the Teach button.

If you press Button-1 over a widget, that widget receives window keybindings so
you can manage that widget's window from the keyboard. No other widgets are
affected.

If you hold doen Shift while pressing Button-1, then the class containing that
widget receives the keybindings. This means all widgets in the application with
the same class (such as Listbox) will now be able to manage their windows
including any new widgets that get created.

If you press Button-2 over a widget, a menu is created over the widget that
contains the window functions for that widget. No keyboard bindings are added to
the widget.

You can teach both keys and menus to a widget. If you wish to do this, it is
recommended you teach the widget keys first (Button 1) before the menus (Button
2). If a widget has the appropriate keybindings when you teach it menus, it
adds appropriate menu accelerators (the keybinding involved), otherwise it
leaves them empty.

If you press Button-3 over a widget, no bindings or menu gets added, but the
application is taught the code used by this tool. Since this is automatically
done to any application that doesn't know the code, but needs to execute a
resizing function, you will normally not have to use this feature.

} $TH_Bind_Help

# Execute command remotely.
proc execute_remote_command {app widget cmd} {
  clear_output
  foreach binding [widget_bindings $app $widget] {
    if {[lindex $binding 0] == $cmd} {
      teach_code $app $widget
      do_cmd $app [regexp_replace [lindex $binding 1] %W $widget] 0
      return
  }}
  th_beep
}

# Teach an app our bindings
proc teach_codebindings {x y b class_flag} {
  if {![which_widget $x $y 1 app widget]} {toggle_grab ; th_beep ; return}
  global Teach_Active
  if $Teach_Active {
    set bindings [widget_bindings $app $widget]
    if {$bindings == ""} {th_beep ; return}
    clear_output
    teach_code $app $widget
    switch $b {
      1 {if $class_flag {set w [send $app winfo class $widget]
         } else {set w $widget}
        teach_keybindings $w $bindings $app
    } 2 {teach_menubindings $widget $bindings $app
    }}
    return
}}


# These bindings only should take effect during a global grab.
bind all <Any-Button>			"teach_codebindings %X %Y %b 0"
bind all <Any-Shift-Button>		"teach_codebindings %X %Y %b 1"

