#
# Module for file I/O for Misc. widgets
#

# Prompts user for a file to write to, before saving file.
proc th_save_file_prompt {w} {
  th_file_prompt $w "th_write_file $w" "File to Save:"
}

# Saves file w/o prompting, prompts user only if necessary
proc th_save_file {w} {
  global TH
  if {[catch "set TH(File,Last,$w)"]} {set TH(File,Last,$w) ""}
  if {([catch "set TH(File,$w)"] || ($TH(File,$w) == ""))} {
    th_save_file_prompt $w
  } elseif {([string first "|" $TH(File,$w)] >= 0) && ($TH(File,Last,$w) != "w")} {
    th_save_file_prompt $w
  } elseif {!([string first "|" $TH(File,$w)] >= 0) &&
      (![file exists $TH(File,$w)] || ![file writable $TH(File,$w)])} {
    th_save_file_prompt $w
  } else {
    th_write_file $w
}}

# Writes contents of w out to TH(File,%W)
proc th_write_file {w} {
  global TH auto_index
  if {[catch "set TH(Pipe,Enabled)"]} {set TH(Pipe,Enabled) 0}
  if {($TH(Pipe) || ([string first "|" $TH(File,$w)] >= 0)) && !$TH(Pipe,Enabled)} {
    error "Pipe writing (to $TH(File,$w)) is not allowed in this application."
  }
  if {([set index [string first "|" $TH(File,$w)]] >= 0)} {
    cd [string range $TH(File,$w) 0 [expr $index - 2]]
    set file [open [string range $TH(File,$w) $index end] w]
  } elseif $TH(Pipe) {
    cd [file dirname $TH(File,$w)]
    set file [open [file tail $TH(File,$w)] w]
  } else {  set file [open $TH(File,$w) w]}

  th_[winfo class $w]_write_file $w $file
  close $file
  catch {set TH(Mtime,$w) [file mtime $TH(File,$w)]}
  set TH(Modified,$w) 0
  if {([info procs th_kill_undos] != "") || \
     ([lsearch [array names auto_index] th_kill_undos] >= 0)} {
    th_kill_undos $w}
  th_file_update_widgets $w
  set TH(File,Last,$w) "w"
}


# Prompts user for a new file to read.
proc th_read_file_prompt {w} {
  th_confirm_save $w "th_file_prompt $w \"th_load_file $w\" {File to Read:}"
}

# Reads (reverts to) current file w/o prompt, unless necessary.
proc th_read_file {w} {
  global TH
  if {[catch "set TH(File,Last,$w)"]} {set TH(File,Last,$w) ""}
  if {([catch "set TH(File,$w)"] || ($TH(File,$w) == ""))} {
    th_read_file_prompt $w
  } elseif {([string first "|" $TH(File,$w)] >= 0) && ($TH(File,Last,$w) != "r")} {
    th_read_file_prompt $w
  } elseif {!([string first "|" $TH(File,$w)] >= 0) &&
      (![file exists $TH(File,$w)] || ![file readable $TH(File,$w)])} {
    th_read_file_prompt $w
  } else {
    th_confirm_save $w "th_load_file $w"
}}

# Inserts contents of prompted file into w, in usual editing fashion.
proc th_insert_file {w} {
  global TH
  if {!([catch "set TH(File,$w)"] || ($TH(File,$w) == ""))} {
    set TH(File,Old,$w) $TH(File,$w)}
  th_file_prompt $w "th_load_file $w 1" {File to Insert:}
}

# Loads w with contents of TH(File,$w)
# if insert_flag is given, then insert, otherwise load.
proc th_load_file {w {insert_flag 0}} {
  global TH auto_index
  if {[catch "set TH(Pipe)"]} {set TH(Pipe) 0}
  if {[catch "set TH(Pipe,Enabled)"]} {set TH(Pipe,Enabled) 0}
  if {($TH(Pipe) || ([string first "|" $TH(File,$w)] >= 0)) && !$TH(Pipe,Enabled)} {
    error "Pipe reading (from $TH(File,$w)) is not allowed in this application."
  }
  if {([set index [string first "|" $TH(File,$w)]] >= 0)} {
    cd [string range $TH(File,$w) 0 [expr $index - 2]]
    set file [open [string range $TH(File,$w) $index end] r]
  } elseif $TH(Pipe) {
    cd [file dirname $TH(File,$w)]
    set file [open [file tail $TH(File,$w)] r]
  } else {  set file [open $TH(File,$w) r]}

  if {![file writable $TH(File,$w)] && [file exists $TH(File,$w)]} {
    th_flash_label $w -text "File is not writable!"
  }
  if $insert_flag {
    if {![catch "set TH(File,Old,$w)"]} {set TH(File,$w) $TH(File,Old,$w)}
    th_[winfo class $w]_insert_file $w $file
    set TH(Modified,$w) 1
  } else {
    th_[winfo class $w]_read_file $w $file
    catch {set TH(Mtime,$w) [file mtime $TH(File,$w)]}
    set TH(Modified,$w) 0
  if {([info procs th_kill_undos] != "") || \
     ([lsearch [array names auto_index] th_kill_undos] >= 0)} {
    th_kill_undos $w}
    th_file_update_widgets $w
    set TH(File,Last,$w) "r"
    }
  close $file
}


# Prompts user for a file, doing cmd if OK.
proc th_file_prompt {w cmd {msg "File:"}} {
  global TH
  if {[set f [th_show_entry $w file]] == ""} {th_beep ; return}
  $f.l configure -text $msg
  $f.e delete 0 end
  if {([catch "set TH(File,$w)"] || ($TH(File,$w) == ""))} {
    $f.e insert 0 "[pwd]/"
    set index end
  } else {
    $f.e insert 0 $TH(File,$w)
    set index [string last "/" $TH(File,$w)] ; incr index
  }
  $f.e icursor $index
  $f.e view $index
  th_bind $f.e OK "th_file_prompt_aux $w \[$f.e get\]; $cmd"
  return $f
}

proc th_file_prompt_aux {w file} {
  global TH
  if {[catch "set TH(Pipe)"]} {set TH(Pipe) 0}
  th_hide_entry $w file
  if {$TH(Pipe) && ([string first "|" $file] < 0)} {
    set TH(File,$w) "[file dirname $file]/| [file tail $file]"
  } elseif {([string index $file 0] != "/")} {
    set TH(File,$w) "[pwd]/$file"
  } else {set TH(File,$w) $file}
}

# If w's contents differ from TH(File,$w), prompt user to save contents.
# Executes cmd if user does not cancel.
proc th_confirm_save {w cmd} {
  global TH
  if {![catch "set TH(Modified,$w)"] && $TH(Modified,$w)} {
    if {([catch "set TH(File,$w)"] || ($TH(File,$w) == ""))} {set name "This"
    } else {set name [file tail $TH(File,$w)]}
  
    set message "$name has been modified. Do you want to save it first?"
    set choice [tk_dialog .conf "Save Dialog" $message question 0 "Save" "Don't Save" "Cancel"]

    if {$choice == 2} {return}
    if {$choice == 0} {
      th_save_file $w
      tkwait variable TH(Modified,$w)
  }}
  uplevel #0 $cmd
}

# Set modified if file has been modified since we last read/saved it.
proc th_check_mtime {w} {
  global TH
  if {[catch "set TH(Mtime,$w)"]} {return}
  if {([string first "|" $TH(File,$w)] >= 0)} {return}
  if {[catch "file mtime $TH(File,$w)"]} {set TH(Modified,$w) 1 ; return}
  if {([file mtime $TH(File,$w)] > $TH(Mtime,$w))} {set TH(Modified,$w) 1 ; return}
}


# Updates whatever widgets contain the file patn/name
proc th_file_update_widgets {w} {
  global TH
  if {([catch "set TH(File,$w)"] || ($TH(File,$w) == ""))} {return}

  if {[string index $TH(File,$w) 0] == "/"} {
    set path [file dirname $TH(File,$w)] ; set name [file tail $TH(File,$w)]
  } else {set path [pwd] ; set name $TH(File,$w)}

  set f [th_frame $w]
  if {[winfo exists $f.fpl]} {
    if {[lindex [$f.fpl configure -text] 4] != "-"} {
      $f.fpl configure -text $path
  }}
  if {[winfo exists $f.fnl]} {
    if {[lindex [$f.fnl configure -text] 4] != "-"} {
      $f.fnl configure -text $name
  }}
}

# Toggles a label between its normal contents and "-"
proc th_label_expand_toggle {w l} {
  if {[lindex [$l configure -text] 4] == "-"} {
    $l configure -text ""
    th_file_update_widgets $w
  } else {$l configure -text "-"}
}


