#
# Module for file I/O for Text widgets
#

# Writes contents of w out to descriptor f.
proc th_Text_write_file {w f} {
  if {([$w get {end -1 chars}] != "\n")} {$w insert end "\n"}
  puts $f [$w get 1.0 end] nonewline
}

# Changes w to contain contents of file descriptor f.
proc th_Text_read_file {w f} {
  $w delete 1.0 end
  $w insert 1.0 [read $f]
  $w mark set insert 1.0
  $w yview 1.0
}

# Inserts contents of f at insert in w.
proc th_Text_insert_file {w f} {
  set text [read $f]
  set i [$w index insert]
  $w insert insert $text
  global auto_index
  if {([info procs th_Text_figure_out_undo_insert] != "") || \
     ([lsearch [array names auto_index] th_Text_figure_out_undo_insert] >= 0)} {
    th_Text_figure_out_undo_insert $w $text  }
  $w mark set insert $i
  $w yview -pickplace insert
}


