#
# Module for managing grids in Text widgets
#

# Turns on or off the horizontal grid on w
# Args are packing info for the grid.
proc th_Text_toggle_grid_x {w args} {
  set g $w ; append g "gridx"
  global TH
  if {[winfo exists $g]} {
# turn grid off
    set TH(Grid_X,$w) 0
    destroy $g
  } else {
    set TH(Grid_X,$w) 1
# turn grid on
    entry $g -relief ridge -font [lindex [$w configure -font] 4] \
      -width [lindex [$w configure -width] 4] -borderwidth 2
    eval pack $g -before $w -fill x $args

# Disable scanning on g.
    foreach binding {<2> <B2-Motion>} { bind $g $binding {info tclversion} }

# Fill g with column numbers
    set width [lindex [$w configure -width] 4]
    $g delete 0 end
    for {set column 0} {$column <= $width} {incr column} {
      set char [string index $column [expr [string length $column] - 1]]
      if {$char == 0} {$g insert end "_"
      } else {$g insert end $char}}
    $g configure -state disabled
}}


# Called by a text widget to tell t what to yview
proc th_Text_yview {t dummy1 dummy2 y dummy4} {$t yview $y}

# Turn vertical grid on. (with width of 'width'...got that? :)
# Args are packing info for the grid.
proc th_Text_toggle_grid_y {w {width 4} args} {
  set g $w ; append g "gridy"
  global TH
  if {[winfo exists $g]} {
# turn grid off
    set TH(Grid_Y,$w) 0

# Reset w's scrollcommand to its scrollbar or nothing if it didn't have one.
    if {[scan [lindex [$g configure -yscrollcommand] 4] "%s set" sc] >= 0} {
      $w configure -yscrollcommand "$sc set"
    } else {$w configure -yscrollcommand {}}

    destroy $g
  } else {
# turn grid on
    set TH(Grid_Y,$w) 1

    text $g -relief ridge -wrap none -height [lindex [$w configure -height] 4] \
      -font [lindex [$w configure -font] 4] -width $width -borderwidth 2
    eval pack $g -before $w -side left $args

# Disable scanning on g.
    foreach binding {<2> <B2-Motion>} { bind $g $binding {info tclversion} }

# Fill g with numbers.
    scan [$w index end] "%d." lines
    for {set line 1} {$line <= $lines} {incr line} {
      $g insert end "$line\n"}
    $g configure -state disabled

# Tie w's yscrollcommand over to g.
    $g yview [$w index @0,0]
    if {[scan [lindex [$w configure -yscrollcommand] 4] "%s set" sc] >= 0} {
# Give g the responsibility of moving w's scrollbar.
      $g configure -yscrollcommand "$sc set"
    }
    $w configure -yscrollcommand "th_Text_yview $g"
}}

