#
# Operations for Tcl procedure/comment manipulation in Text widgets.
#


# Procedure boundary routines

proc th_proc_begin {w index} {
  set trace "$index lineend"
  while {[set trace [th_Text_string_last $w "proc" $trace]] != ""} {
    scan [$w index $trace] "%d.%d" row column
    if {($column == 0)} {return $trace}
  }
  return ""
}

proc th_proc_end {w index} {
  if {[set index [th_proc_begin $w $index]] == ""} {return ""}
  set begin $index
  set ob "\{"  ; set cb "\}"
  set arg_start [th_Text_string_first $w $ob $begin]
  set arg_end [th_Text_right_exp $w "$arg_start +1c" [list $ob $cb]]
  set body_start [th_Text_string_first $w $ob $arg_end]
  set end "[th_Text_right_exp $w "$body_start +1c" [list $ob $cb]] +1c"
  th_Text_add_tag_range $w function $begin $end
  return $end
}

proc th_proc_next {w index} {
  set trace $index
  while {[set trace [th_Text_string_first $w "proc" "$trace +1c"]] != ""} {
    scan [$w index $trace] "%d.%d" row column
    if {($column == 0)} {return $trace}}
  return ""
}

proc th_proc_prev {w index} {
  if {[$w compare [set begin [th_proc_begin $w $index]] != $index]} {
    return $begin 
  } else {return [th_proc_begin $w "$index -1c"]
}}

proc th_proc_select {w} {
  set s [th_proc_begin $w insert] ; set e [th_proc_end $w insert]
  if {($s == "") || ($e == "")} {th_beep ; return}
  th_Text_select_range $w $s $e
  th_Text_add_tag_range $w function $s $e
}


# Comment boundary routines

proc th_tclcomment_begin {w index} {
  scan [$w index $index] "%d.%d" i dummy
  if {[$w get "$i.0"] != "#"} {return ""}
  for {} {$i > 0} {incr i -1} {
    if {([$w get "$i.0"] == "#") && ([$w get "$i.0 -1 line"] != "#")} {
      return "$i.0"
  }}
  if {[$w get 1.0] == "#"} {return 1.0} else {return ""}
}

proc th_tclcomment_end {w index} {
  scan [$w index $index] "%d.%d" i dummy
  scan [$w index end] "%d.%d" e dummy
  if {[$w get "$i.0"] != "#"} {return ""}
  for {} {$i < $e} {incr i} {
    if {([$w get "$i.0"] != "#")} {return "$i.0 -1c"}}
  if {[$w get "$e.0"] == "#"} {return end} else {return ""}
}

proc th_tclcomment_next {w index} {
  scan [$w index $index] "%d.%d" i dummy
  scan [$w index end] "%d.%d" e dummy
  for {} {$i < $e} {incr i} {
    if {([$w get "$i.0"] != "#") &&
      ([$w get "$i.0 +1l"] == "#")} {return "$i.0 +1l"}}
  return ""
}

proc th_tclcomment_prev {w index} {
  if {[$w compare [set begin [th_tclcomment_begin $w $index]] != $index]} {
    return $begin 
  } else {return [th_tclcomment_begin $w "$index -1c"]
}}


# Adjusts selected region to fit in length columns, so that no lines wrap
# If unspecified, length defaults to window width.
proc th_tclcomment_format {w start end {length ""}} {
  if {$start == ""} {th_beep ; return}
  set s [$w index $start] ; set e [$w index $end]
  if {($length == "")} {set length [lindex [$w configure -width] 4]}
  set chars [$w get $s $e]
  set m1 [th_gensym] ; set m2 [th_gensym]
  $w mark set $m1 $s ; $w mark set $m2 $e
  th_Text_register_undoable_cmd $w [list th_Text_undo_filter $w $m1 $m2 \
		 $chars] "Adjust $chars" "$m1 $m2"
  set prefix ""
  for {set i 0} {[string first [$w get "$s +$i c"] "# "] >= 0} {incr i} {
    append prefix [$w get "$s +$i c"]
  }
  th_Text_delete_prefix $w $m1 $m2 $prefix
  th_Text_format $w $m1 $m2 [expr $length - [string length $prefix]]
  th_Text_add_prefix $w $m1 $m2 $prefix
  $w mark set $m1 "$m1 linestart"
  th_Text_add_tag_range $w comment $m1 $m2
}


proc th_tcl_mark {w} {
  th_Text_insert $w "\n"
  if {[$w get "insert -1l linestart"] == "#"} {
    th_Text_add_tag_range $w comment [th_tclcomment_begin $w "insert -1c"] "insert-1c"
  }

  if {[$w get "insert -2c"] == "\}"} {
    th_Text_balance_add_tag_range $w function th_proc_begin [list "\{" "\}"]
}}


