# Bindings for balancing paranethesis (and other character pairs)

load_library_module regions.tcl


# Returns index of closesst previous lone left partner, or "" if unsuccessful.
proc find_left_pair {t index {left ""} {right ""}} {
	if {($left == "") || ($right == "")} {
		global local_balance_list
		set left [lindex $local_balance_list 0]
		set right [lindex $local_balance_list 1]
	}

	set close_trace [$t index $index]
	set open_trace $close_trace
	while (1) {
		if {[set open_trace [text_string_last $t $left $open_trace]] \
				== ""} {return ""}
		if {[set close_trace [text_string_last $t $right $close_trace \
				$open_trace]] == ""} {return "$open_trace +1c"}
}}

# Returns index of closest next lone right partner, or "" if unsuccessful.
proc find_right_pair {t index {left ""} {right ""}} {
	if {($left == "") || ($right == "")} {
		global local_balance_list
		set left [lindex $local_balance_list 0]
		set right [lindex $local_balance_list 1]
	}
	set close_trace [$t index "$index -1c"]
	set open_trace $close_trace
	while (1) {
		if {[set close_trace [text_string_first $t $right \
				"$close_trace +1c"]] == ""} {return ""}
		if {[set open_trace [text_string_first $t $left \
				"$open_trace +1c" $close_trace]] == ""} {
			return $close_trace}
}}

proc find_left_pair_out {t index {left ""} {right ""}} {
	set new [find_left_pair $t $index $left $right]
	if {$new == ""} {return} else {return "$new -1c"}
}

proc find_right_pair_out {t index {left ""} {right ""}} {
	set new [find_right_pair $t "$index +1c" $left $right]
	if {$new == ""} {return} else {return "$new +1c"}
}


# Prompting for a balancing cluster.

proc prompt_for_local_balance_aux {t f cmd c} {
	if {(![regexp . $c])} {return}
	destroy $f.bal
	parse_bindings  $t {Key C-Key M-Key C-M-Key} ""
	global local_balance_list balance_list
	foreach item $balance_list {foreach list_index {0 1} {
		if {$c == [lindex $item $list_index]} {
			set local_balance_list $item
			if {[catch "uplevel #0 [list $cmd]"]} {beep}
			return
	}}}
	beep ; return
}

proc prompt_for_local_balance {t f args} {
	label $f.bal -text "Which cluster?"
	pack append $f $f.bal {right}
	parse_bindings $t \
{Key C-Key M-Key C-M-Key} "prompt_for_local_balance_aux $t $f \{$args\} %A" \
}

proc goto_left_pair {t} {
	set new [find_left_pair $t insert]
	if {$new == ""} {beep ; return}
	move_insert $t $new
}

proc goto_right_pair {t} {
	set new [find_right_pair $t insert]
	if {$new == ""} {beep ; return}
	move_insert $t $new
}


# Highlighting matching paren (which involves ensuring balancing between other
# pairs as well)

# Counts instances of $c between $start and $end in $t
proc char_count {t c start end} {
	set offset 0 ; set count 0
	set c [string trimleft $c \\]
	while {([set trace [text_string_first $t $c $start $end]] != "")} {
		incr count
		set start [$t index "$trace +1c"]
	}
	return $count
}

# Checks if $left and $right occur the same # of times in [$start $end] of $t
proc balance_count {t left right start end} {
	set c1 [char_count $t $left $start $end]
	set c2 [char_count $t $right $start $end]
	if {($c1 > $c2)} {return "[string trimleft $left \\] [expr $c1-$c2]"}
	if {($c2 > $c1)} {return "[string trimleft $right \\] [expr $c2-$c1]"}
	return ""
}

proc search_left_partner {t f left right} {
	global balance_list local_balance_list
	catch {$t tag remove balance 1.0 end}
	set local_balance_list [list [string trimleft $left \\] [string trimleft $right \\]]
	set result [find_left_pair $t insert]
	if {($result == "")} {
		set msg "No [string trimleft $left \\] found!!!" ; beep
	} else {$t tag add balance "$result -1c" $result
		global flash_time
		after $flash_time $t tag remove balance 1.0 end
		foreach pair $balance_list {if {($left != [lindex $pair 0])} {
			set char [balance_count $t [lindex $pair 0] \
				[lindex $pair 1] "$result -1c" insert]
			if {($char != "")} {
				set msg "Excess $char" ; beep ; break
			} else {set msg [$t get "$result linestart" $result]
	}}}}
	set max_length 20
	if {([string length $msg] < $max_length)} {set width [string length $msg]} else {set width $max_length}
	flash_label $f -text $msg -relief raised -width $width -anchor e
}


# Balance bindings. f is a frame widget to put messages in.
proc balancebind {f m} {
	global balance_list edit_flag
	if {[winfo exists $m]} {make_cascade_entry $m.extras.m Find 0}

	parse_bindings Text \
M-A		"prompt_for_local_balance %W $f goto_left_pair %W" \
M-E		"prompt_for_local_balance %W $f goto_right_pair %W" \
M-J		"prompt_for_local_balance %W $f select_group %W insert \
				find_left_pair_out find_right_pair_out"

	if $edit_flag {parse_bindings Text \
M-D		"prompt_for_local_balance %W $f delete_group_end %W insert \
				find_left_pair find_right_pair" \
M-H		"prompt_for_local_balance %W $f delete_group_begin %W insert \
				find_left_pair find_right_pair" \
M-U		"prompt_for_local_balance %W $f kill_group %W insert \
				find_left_pair_out find_right_pair_out"
}

	if {[winfo exists $m]} {
		parse_menuentries $m.browse.m.move {
{Expression 1 ""	 			{Beginning 0 M-A}
					{End 0 M-E}}}
		parse_menuentries $m.browse.m.select {{Expression 1 M-J}}

		if $edit_flag {
		parse_menuentries $m.edit.m.kill {{Expression 1 M-U}}
		parse_menuentries $m.edit.m.delete {
{Expression 1 ""				{Previous 0 M-H}
					{Next 0 M-D}}}
	}}

	foreach pair $balance_list {
		set left_key [lindex $pair 0]
		set right_key [lindex $pair 1]
		set right_keysym [lindex $pair 3]
		bind Text <$right_keysym> "search_left_partner %W $f \
						\\$left_key \\%A ;
				catch {self_insert %W %A}"

		if {[winfo exists $m]} {
			make_command_entry $m.extras.m.find "Partner to" \
						"$right_keysym $right_key"}
}}

set balance_list {	{\( \) parenleft parenright}
			{\[ \] bracketleft bracketright}
			{\{ \} braceleft braceright}}
balancebind $frame $menu
