;;;
;;; additional functions for Keys
;;; Stefan Strobel '94
;;;

(defun mark-move-right ()
  "move right and set the mark if its not active"
  (interactive)
  (if (not mark-active)
      (push-mark nil nil t))
  (forward-char))

(defun mark-move-left ()
  "move left and set the mark if its not active"
  (interactive)
  (if (not mark-active)
      (push-mark nil nil t))
  (backward-char))

(defun mark-move-down ()
  "move down and set the mark if its not active"
  (interactive)
  (if (not mark-active)
      (push-mark nil nil t))
  (next-line 1))

(defun mark-move-up ()
  "move up and set the mark if its not active"
  (interactive)
  (if (not mark-active)
      (push-mark nil nil t))
  (previous-line 1))

(defun mark-move-end ()
  "move left and set the mark if its not active"
  (interactive)
  (if (not mark-active)
      (push-mark nil nil t))
  (end-of-line))



(defun mouse-describe-function (event)
  "describe function under the mouse-cursor"
  (interactive "e")
  (save-excursion
    (mouse-set-point event)
    (let ((fn (function-called-at-point)))
      (describe-function fn)
      nil)))

(defun mouse-describe-ilisp (event)
  "describe symbol under the mouse-cursor"
  (interactive "e")
  (save-excursion
    (mouse-set-point event)
    (let* ((symbol-info (lisp-previous-symbol))
	   (symbol (car symbol-info))
	   (type (if (car (cdr symbol-info))
		     'function
		   'variable)))
      (documentation-lisp symbol type)
      nil)))

(defun no-action (event)
  "do nothing"
  (interactive "e"))


(define-key emacs-lisp-mode-map [S-mouse-1] 'mouse-describe-function)
(define-key lisp-mode-map       [S-mouse-1] 'mouse-describe-ilisp)
(define-key global-map          [S-mouse-2] 'no-action)
(define-key global-map          [S-mouse-3] 'no-action)

(global-set-key [S-f32]     'mark-move-right)
(global-set-key [S-f30]     'mark-move-left)
(global-set-key [S-f28]     'mark-move-up)
(global-set-key [S-f34]     'mark-move-down)
(global-set-key [S-f33]     'mark-move-end)

(global-set-key [S-right]   'mark-move-right)
(global-set-key [S-left]    'mark-move-left)
(global-set-key [S-up]      'mark-move-up)
(global-set-key [S-down]    'mark-move-down)
(global-set-key [S-end]     'mark-move-end)

