;;; hm--c++-menu.el: 
;;; v1.11; 20 Jun 1993
;;; Copyright (C) 1993  Heiko Muenkel
;;; email: muenkel@tnt.uni-hannover.de
;;;
;;;  This program is free software; you can redistribute it and/or modify
;;;  it under the terms of the GNU General Public License as published by
;;;  the Free Software Foundation; either version 1, or (at your option)
;;;  any later version.
;;;
;;;  This program is distributed in the hope that it will be useful,
;;;  but WITHOUT ANY WARRANTY; without even the implied warranty of
;;;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;;  GNU General Public License for more details.
;;;
;;;  You should have received a copy of the GNU General Public License
;;;  along with this program; if not, write to the Free Software
;;;  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
;;;
;;; 
;;; Description:
;;;
;;;	A popup and pulldown (programming) menu for the c++-mode.
;;;	The menus provides functions like compile, repeat compile,
;;;	debugging, sexp, indent and comment functions, functions
;;;	to customize mode properties like blinking parenthesis,
;;;	font lock mode, open parenthesis match, expanding macros
;;;	and so on.
;;;     There exists also some menu items to include header files. 
;;;     You can specify the files by setting the lisp variables:
;;;		hm--c-file-header
;;;		hm--h-file-header
;;;		hm--c-function-header
;;;		hm--h-macro-header
;;;		hm--c++-class-header
;;;	The values can be overwrite by the following environment variables:
;;;		C_FILE_HEADER
;;;		H_FILE_HEADER
;;;		C_FUNCTION_HEADER
;;;		H_MACRO_HEADER
;;;		H_C_PLUSPLUS_CLASS_HEADER
;;;     You should have receive the following prototype header files with 
;;;	this file:
;;;		c-file.header
;;;		h-file.header
;;;		c-function.header
;;;		h-macro.header
;;;		h-c++.header
;;;	We are working at a better support for these headerfiles. At the
;;;	moment the header are simple included. Only if the file header
;;;	(c-file.header, h-file.header) are included, the username, date
;;;	and filename are inserted automaticly.
;;;	The file header should only be included once per c++, c or h file.
;;;	Every function in a file should become a c function header. The
;;;	h macro header is for macros, which are used as functions and the
;;;	h c++ header is for class descriptions.
;;;
;;;	If you don't like these header functions you should delete the
;;;	menu-item "Header" with the lisp function 'delete-menu-item'.
;;;	Therefore you should add the lisp code to the c++-mode-hook.
;;; 
;;;     You need also the following lisp files:
;;;		hm--menu.el
;;;		hm--programming-menu.el
;;;		c++-mode.el
;;;
;;;	The file c++-mode.el should be in the standart lemacs distribution.
;;;
;;; Installation: 
;;;   
;;;	Put the files hm--c++-menu.el, hm--menu.el, hm--programming-menu.el
;;;	in one of your lisp load path directories.
;;;
;;;	Put the following line in your .emacs
;;;		(load-library "hm--c++-menu.el")
;;;
;;;	Look at the description part of these file and set the lisp or
;;;	unix environment variables for the header files and put the
;;;	header files in an appropriate directory (The other menu-items
;;;	works without these settings.).
;;;

(provide 'hm--c++-menu)
(require 'hm--menu)
(require 'hm--programming-menu)

;;
;; Menue "Programming" fr C++
;;


(defvar hm--c++-programming-menu nil "*Liste mit dem Menue Programming.")


(setq hm--c++-programming-menu
      '("Programming Menu"
	("Eval C++"
	 ["Compile..." hm--compile t]
	 ["Repeat compile" hm--repeat-compile t]
	 ["Debugger" gdb t]
	 )
	("Goto"
	 ["Beginning of defun" c++-beginning-of-defun t]
	 ["End of defun" c++-end-of-defun t]
	 ["Jump Match paren" c++-match-paren t]
	 ["Goto line..." goto-line t]
	 ["Find tag other window..." find-tag-other-window t]
	 )
	("Header"
	 ["Insert c function header" (hm--insert-header 
				      hm--c-function-header
				      "C_FUNCTION_HEADER"
				      nil) t]
	 ["Insert h macro header" (hm--insert-header 
				   hm--h-macro-header
				   "H_MACRO_HEADER"
				   nil) t]
	 ["Insert c++ class header" (hm--insert-header 
				     hm--c++-class-header
				     "H_C_PLUSPLUS_CLASS_HEADER"
				     nil) t]
	 ["Insert c file header" (hm--insert-header 
				  hm--c-file-header
				  "C_FILE_HEADER"
				  t) t]
	 ["Insert h file header" (hm--insert-header
				  hm--h-file-header
				  "H_FILE_HEADER"
				  t) t]
	 )
	("Misc"
	 ["Mark c function" mark-c-function t]
	 ["Insert braces" hm--c-insert-braces t]
	 ["Expand macros" c-macro-expand t]
	 )
	"----"
	("Syntax Expr Cmds"
	 ["Forward c++-sexp" c++-forward-sexp t]
	 ["Backward c++-sexp" c++-backward-sexp t]
	 ["Forward sexp" forward-sexp t]
	 ["Backward sexp" backward-sexp t]
	 ["Kill sexp" kill-sexp t]
	 ["Mark sexp" mark-sexp t]
	 )
	("Indent/Comment"
	 ["Indent region" indent-region t]
	 ["Indent sexp" indent-sexp t]
	 "----"
	 ["Comment region" c++-comment-region t]
	 ["Uncomment region" c++-uncomment-region t]
	 )
	("Mode Properties"
	 ["Font lock mode" font-lock-mode t]
	 ["Fontify buffer" font-lock-fontify-buffer t]
	 "----"
	 ["Init blinking parenthesis" hm--init-blinking-parenthesis t]
	 ["No open parenthesis match" hm--unset-matching-open-parenthesis t]
	 )
	))


(defun hm--install-c++-programming-menu ()
  (if (and current-menubar (not (assoc "Programming" current-menubar)))
      (progn
	(set-buffer-menubar (copy-sequence current-menubar))
	(hm--set-popup-menu 'hm--c++-programming-menu)
	(add-menu nil "Programming" (cdr hm--c++-programming-menu)))))


;(defun hm--popup-c-c++-programming-menu (event)
;  "Gibt Programming- Menue aus."
;  (interactive "@e")
;  (popup-menu hm--c-c++-programming-menu))
;
;
;(defun hm--c++-new-keys ()
;  (define-key c++-mode-map '(button3) 'hm--popup-c-c++-programming-menu)
;  )


(add-hook 'c++-mode-hook 'hm--install-c++-programming-menu)
;(add-hook 'c++-mode-hook 'hm--c++-new-keys)


      




