;;; hm--y-or-n.el: 
;;; v1.00; 03 Jul 1993
;;; Copyright (C) 1993  Heiko Muenkel
;;; email: muenkel@tnt.uni-hannover.de
;;;
;;;  This program is free software; you can redistribute it and/or modify
;;;  it under the terms of the GNU General Public License as published by
;;;  the Free Software Foundation; either version 1, or (at your option)
;;;  any later version.
;;;
;;;  This program is distributed in the hope that it will be useful,
;;;  but WITHOUT ANY WARRANTY; without even the implied warranty of
;;;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;;  GNU General Public License for more details.
;;;
;;;  You should have received a copy of the GNU General Public License
;;;  along with this program; if not, write to the Free Software
;;;  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
;;;
;;; 
;;; Description:
;;;
;;;	This file provides simple dialog boxes for the lemacs without
;;;	motif. It requires also the following file:
;;;		menu-utils.el
;;;	I don't know who the author of this file is.
;;; 
;;; Installation: 
;;;   
;;;	Put the files menu-utils.el and hm--y-or-n.el in one of your lisp
;;;	load path directories and the following line in your .emacs:
;;;		(load-library "menu-utils")
;;;		(load-library "hm--y-or-n")
;;;


(provide 'hm--y-or-n)


(defun y-or-n-p (prompt)
  (if current-mouse-event
      (equal "y"
	  (popup-choice-menu (list (cons (hm--put-string-in-the-middle
					  "Y"
					  (length prompt)) 
					 "y")
				   (cons (hm--put-string-in-the-middle
					  "N"
					  (length prompt)) 
					 "n")) 
			     prompt))
    (y-or-n-p-minibuf prompt)))


(defun yes-or-no-p (prompt)
  (if current-mouse-event
      (equal "yes"
	(popup-choice-menu (list (cons (hm--put-string-in-the-middle 
					"YES"
					(length prompt))
				       "yes") 
				 (cons (hm--put-string-in-the-middle
					"NO"
					(length prompt))
				       "no")) 
			   prompt))
    (yes-or-no-p-minibuf prompt))) 



(defun hm--put-string-in-the-middle (string length)
  (if (> length (length string))
      (let* ((no-of-pre-blanks (- (/ length 2) (/ (length string) 2)))
	     (no-of-post-blanks (- length no-of-pre-blanks (length string))))
	(concat (make-string no-of-pre-blanks ? )
		string
		(make-string no-of-post-blanks ? )))
    string))
