*** exf.c.orig	Thu Jan 12 16:34:48 1995
--- exf.c	Thu Jan 12 21:56:51 1995
***************
*** 804,809 ****
--- 804,823 ----
  	if (!noname && file_lock(sp, NULL, NULL, fd, 0) == LOCK_UNAVAIL)
  		msgq(sp, M_ERR, "265|%s: write lock was unavailable", name);
  
+ #if __linux__
+ 	/*
+ 	 * In libc 4.5.x, fdopen(fd, "w") clears the O_APPEND flag (if set).
+ 	 * This bug is fixed in libc 4.6.x.
+ 	 *
+ 	 * This code works around this problem for libc 4.5.x users.
+ 	 * Note that this code is harmless if you're using libc 4.6.x.
+ 	 */
+ 	if (LF_ISSET(FS_APPEND) && lseek(fd, (off_t)0, SEEK_END) < 0) {
+ 		msgq(sp, M_SYSERR, name);
+ 		return (1);
+ 	}
+ #endif
+ 
  	/* Use stdio for buffering. */
  	if ((fp = fdopen(fd, "w")) == NULL) {
  		(void)close(fd);
