/*-
 * Copyright (c) 1993, 1994
 *	The Regents of the University of California.  All rights reserved.
 * Copyright (c) 1994, 1995
 *	Keith Bostic.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)cl.h	8.5 (Berkeley) 2/16/95
 */

typedef struct _cl_private {
	char	*VB;		/* Visual bell termcap string. */

#define	CL_CURSES_INIT	0x01	/* Curses/termcap initialized. */
	u_int8_t flags;
} CL_PRIVATE;

#define	CLP(sp)		((CL_PRIVATE *)((sp)->gp->cl_private))

/* Generic interfaces to the curses support. */
int	cl_init __P((SCR *));

/* Curses support function prototypes. */
int	cl_addnstr __P((SCR *, const char *, size_t));
int	cl_addstr __P((SCR *, const char *));
int	cl_bell __P((SCR *));
int	cl_clear __P((SCR *));
int	cl_clrtoeol __P((SCR *));
int	cl_cursor __P((SCR *, size_t *, size_t *));
int	cl_deleteln __P((SCR *));
int	cl_end __P((SCR *));
int	cl_fmap __P((SCR *, enum seqtype, CHAR_T *, size_t, CHAR_T *, size_t));
int	cl_insertln __P((SCR *));
int	cl_inverse __P((SCR *, int));
int	cl_linverse __P((SCR *, size_t));
int	cl_keypad __P((SCR *, int));
int	cl_move __P((SCR *, size_t, size_t));
int	cl_refresh __P((SCR *));
int	cl_restore __P((SCR *));
int	cl_ssize __P((SCR *, int));
int	cl_suspend __P((SCR *));
int	cl_term_end __P((SCR *));
int	cl_term_init __P((SCR *));
