#!/usr/local/bin/perl
#  import.pl - functions to implement importing from other formats
#
#  Written by Curtis Olson.  Started August 25, 1994.
#
#  Copyright (C) 1994  Curtis L. Olson  - curt@sledge.mn.org
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

# $Id: import.pl,v 1.2 1994/11/01 22:39:10 clolson Exp $
# (Log is kept at end of this file)


# specify the installed location of the necessary pieces.
$cbb_incl_dir = ".";
unshift(@INC, $cbb_incl_dir);


require "common.pl";


# import the data from the old CBB format
sub import_old_cbb {
    # in: file base name
    # out: result

    local($file) = @_;
    $sorted_keys = 0;
    $calced = 0;

    open(LOAD, "<$file") || return "error";

    while ( <LOAD> ) {
	chop;
	&create_trans($_);
    }

    close(LOAD);

    return "ok";
}


# import a quicken export file (.qif)
sub import_qif {
    # in: file
    # out: result

    local($file) = @_;
    $sorted_keys = 0;
    $calced = 0;

    open(QIF, "<$file");

    ($date, $check, $desc, $debit, $credit, $cat, $split, $com, 
    	$cleared) = ("", "", "", "", "", "", "", "", "");

    while ( <QIF> ) {
	chop;			# get rid of that pesky newline.
	s/:/-/g;		# eliminate our delimiter characters from
	s/\|/-/g;		# the import file.
	s/\r//g;		# strip the dos ^M if needed
	if ( m/^\!/ ) {
	    # Type
	    # print "$_\n";
	} elsif ( m/^D/ ) {
	    # Date
	    ($month, $day, $year) = split(/\/ */, substr($_,1));
	    $month = &pad($month);
	    $day = &pad($day);
	    $date = "$year$month$day";
	    # print "$date\n";
	} elsif ( m/^T/ ) {
	    # Transaction Amount
	    s/,//g;		# remove , from numbers (i.e. thousands)
	    $amt = substr($_,1);
	    if ($amt >= 0) {
		$credit = $amt;
		$debit = 0;
	    } else {
		$debit = substr($amt,1); # remove the '-' to make amt >= 0
		$credit = 0;
	    }
	    # print "credit = $credit  debit = $debit\n";
	} elsif ( m/^C/ ) {
	    # Cleared
	    $cleared = substr($_,1);
	    # print "Cleared = $cleared\n";
	} elsif ( m/^N/ ) {
	    # check Number
	    $check = substr($_,1);
	    # print "Check # = $check\n";
	} elsif ( m/^P/ ) {
	    # descriPtion
	    $desc = substr($_,1);
	    # print "$desc\n";
	} elsif ( m/^L/ ) {
	    # category
	    $cat = substr($_,1);
	    #print "$cat\n";
	} elsif ( m/^S/ ) {
	    # split category
	    if ($split eq "") {
		# first split
		$split = "|".substr($_,1)."|";
	    } else {
		# not first split :)
		$split = $split.substr($_,1)."|";
	    }
	} elsif ( m/^E/ ) {
	    # split comment
	    $split = $split.substr($_,1)."|"
	} elsif ( m/^\$/ ) {
	    # split amount
	    $split = $split.substr($_,1)."|";
	} elsif ( m/^M/ ) {
	    # coMment
	    $com = substr($_,1);
	    #print "Comment = $com\n";
	} elsif ( m/^\^/ ) {
	    #print "End of record\n";
	    if ($split ne "") {
		$cat = $split;
	    }
	    &create_trans(
	    	"$date:$check:$desc:$debit:$credit:$cat:$com:$cleared:0.00" );
	    ($date, $check, $desc, $debit, $credit, $cat, $split, $com, 
	    	$cleared) = ("", "", "", "", "", "", "", "", "");
	} elsif ( $_ eq "" ) {
	    # toss empty lines ...
	} else {
	    print "unknown data: $_\n";
	}
    }

    close(QIF);

    return "ok";
}


1;				# need to return a true value


# ----------------------------------------------------------------------------
# $Log: import.pl,v $
# Revision 1.2  1994/11/01  22:39:10  clolson
# Added log.pl --> implemented logging.
# Worked on install script.
#
# Revision 1.1  1994/10/31  15:18:52  curt
# These files resulted from the splitting of engine.pl
#
