#!/usr/local/bin/perl
#  memorized.pl - functions to implement memorized transactions
#
#  Written by Curtis Olson.  Started October 13, 1994.
#
#  Copyright (C) 1994  Curtis L. Olson  - curt@sledge.mn.org
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

# $Id: memorized.pl,v 1.2 1994/11/01 22:39:18 clolson Exp $
# (Log is kept at end of this file)

# WARNING:  This file must be "required" after the main transaction file.

# %MEMS - an associative array of transactions and description keys
# @MEMKEYS - a sorted list of description keys (for memorized transactions)


# initialize the memorized transaction list
sub init_mems {
    # out: result

    %MEMS = ();
    $sorted_memkeys = 1;

    return "ok";
}


# insert a memorized transaction into the MEMS list
sub insert_mem {
    # in: trans
    # out: trans

    local($trans) = @_;

    ($date, $check, $desc, $debit, $credit, $cat, $com, $cleared, $total) =
	split(/:/, $trans);

    $MEMS{$desc} = $trans;

    print DEBUG "insert_mem:  $desc -> $trans\n" if $debug;

    return "$trans";
}


# build the MEMS list
sub rehash_mems {
    # out: result

    &init_mems();

    if ($calced == 0) {
	&calc_trans();
    }

    if ($sorted_keys == 0) {
	&sort_keys();
    }

    foreach $key (@KEYS) {
	&insert_mem($TRANS{$key});
    }

    @MEMKEYS = sort(keys %MEMS);

    return "ok";
}


# attempt to find a transaction matching the description
# incomplete descriptions are allowed
sub find_mem {
    # in: desc
    # out: trans

    local($desc) = @_;

    if ( $desc ne "" ) {
        foreach $memkey (@MEMKEYS) {
	    if ( $memkey =~ m/^$desc/i ) {
	        return "$desc:$MEMS{$memkey}";
	    }
        }
    }

    return "none";
}


&init_mems();


1;				# need to return a true value


# ----------------------------------------------------------------------------
# $Log: memorized.pl,v $
# Revision 1.2  1994/11/01  22:39:18  clolson
# Added log.pl --> implemented logging.
# Worked on install script.
#
# Revision 1.1  1994/10/31  15:18:53  curt
# These files resulted from the splitting of engine.pl
#
