#!/usr/local/bin/perl
#  rep-txn-by-cat.pl - Prints a report of the transactions sorted by category.
#
#  Written by Curtis Olson.  Started November 12, 1994.
#
#  Copyright (C) 1994  Curtis L. Olson  - curt@sledge.mn.org
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

# $Id: rep-txn-by-cat.pl,v 1.5 1994/11/28 20:07:28 clolson Exp $
# (Log is kept at end of this file)


# specify the installed location of the necessary pieces.
$cbb_incl_dir = "..";
unshift(@INC, $cbb_incl_dir);

require "reports.pl";


($#ARGV >= 0) || die "Usage: report [ -from date ] [ -to date] account";


# process arguments

$fromdate = "all";
$todate = "all";

while ( $#ARGV >= 0 ) {
    $arg = shift(@ARGV);
    if ( substr($arg, 0 , 1) eq "-" ) {
	if ( $arg eq "-from" ) {
	    $nicefrom = shift(@ARGV);

	    ($month, $day, $year) = split(/\//, $nicefrom);
	    $month = &pad($month);
	    $day = &pad($day);
	    $year = &pad($year);
	    if ( length($year) == 2 ) {
		$year = "19" . "$year";
	    }
	    $fromdate = "$year" . "$month" . "$day";

	    print "from $fromdate\n";
	} elsif ( $arg eq "-to" ) {
	    $niceto = shift(@ARGV);

	    ($month, $day, $year) = split(/\//, $niceto);
	    $month = &pad($month);
	    $day = &pad($day);
	    $year = &pad($year);
	    if ( length($year) == 2 ) {
		$year = "19" . "$year";
	    }
	    $todate = "$year" . "$month" . "$day";

	    print "to $todate\n";
	} elsif ( $arg eq "-to" ) {
	    $niceto = shift(@ARGV);
	    # print "to $todate\n";
	}
    } else {
	(&load_trans($arg) eq "ok") || die "Cannot open account:  $arg";
    }
}


&rep_txn_by_cat("$fromdate $todate");


# ----------------------------------------------------------------------------
# $Log: rep-txn-by-cat.pl,v $
# Revision 1.5  1994/11/28  20:07:28  clolson
# Moved "guts" to report.pl
#
# Revision 1.4  1994/11/20  15:37:25  curt
# Tiny perl4/5 compatibility changes.
#
# Revision 1.3  1994/11/14  21:25:43  clolson
# Added -from date and -to date options.
#
# Revision 1.2  1994/11/14  20:36:01  clolson
# Started working on reports !!!
#
